/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.rest.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.ow2.jasmine.probe.JasmineProbeException;
import org.ow2.jasmine.probe.JasmineProbeManager;
import org.ow2.jasmine.probe.JasmineTarget;
import org.ow2.jasmine.probe.api.generated.ErrorType;
import org.ow2.jasmine.probe.api.generated.PropType;
import org.ow2.jasmine.probe.api.generated.TargetBaseType;
import org.ow2.jasmine.probe.api.generated.TargetResource;
import org.ow2.jasmine.probe.rest.Targets;
import org.ow2.jasmine.probe.rest.impl.RestUtil;

public class JTargets
implements Targets {
    private JasmineProbeManager jpManager = null;

    public JTargets(JasmineProbeManager jpManager) {
        this.jpManager = jpManager;
    }

    @Override
    public Response getTarget(String name, UriInfo ui) {
        JasmineTarget jtarget;
        UriBuilder ub = ui.getAbsolutePathBuilder();
        String targetUri = ub.build(new Object[]{""}).toString();
        String baseUri = targetUri.substring(0, targetUri.lastIndexOf(name));
        try {
            jtarget = this.jpManager.getTarget(name);
        }
        catch (JasmineProbeException e) {
            ErrorType err = new ErrorType();
            err.setMessage(e.getMessage());
            QName qname = new QName("org.ow2.jasmine.probe:probe-config", "error");
            JAXBElement errElem = new JAXBElement(qname, ErrorType.class, (Object)err);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errElem).type("application/xml").build();
        }
        if (jtarget == null) {
            ErrorType err = new ErrorType();
            err.setMessage("Cannot find target with name: " + name);
            QName qname = new QName("org.ow2.jasmine.probe:probe-config", "error");
            JAXBElement errElem = new JAXBElement(qname, ErrorType.class, (Object)err);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errElem).type("application/xml").build();
        }
        TargetResource target = new TargetResource();
        target.setName(name);
        target.setHref(targetUri);
        ArrayList<PropType> property = new ArrayList<PropType>();
        for (String propKey : jtarget.getProperties().keySet()) {
            String propValue = (String)jtarget.getProperties().get(propKey);
            PropType prop = new PropType();
            prop.setValue(propValue);
            prop.setKey(propKey);
            property.add(prop);
        }
        target.setProperty(property);
        QName qname = new QName("org.ow2.jasmine.probe:probe-config", "target");
        JAXBElement targetResource = new JAXBElement(qname, TargetResource.class, (Object)target);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)targetResource).type(MediaType.APPLICATION_XML_TYPE).build();
    }

    @Override
    public Response getTargets(boolean verbose, UriInfo ui) {
        ArrayList<JAXBElement> elementsList = new ArrayList<JAXBElement>();
        List targetList = this.jpManager.getTargets();
        for (JasmineTarget target : targetList) {
            String targetName = target.getName();
            TargetResource targetElement = new TargetResource();
            targetElement.setName(target.getName());
            URI targetUri = ui.getAbsolutePathBuilder().path(targetName).build(new Object[0]);
            targetElement.setHref(targetUri.toString());
            if (verbose) {
                // empty if block
            }
            QName name = new QName("org.ow2.jasmine.probe:probe-config", "target");
            JAXBElement xmlElement = new JAXBElement(name, TargetResource.class, (Object)targetElement);
            elementsList.add(xmlElement);
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new GenericEntity<List<JAXBElement<TargetResource>>>(elementsList){}).type(MediaType.APPLICATION_XML_TYPE).build();
    }

    @Override
    public Response deleteTarget(String name) {
        try {
            this.jpManager.removeTarget(name);
        }
        catch (JasmineProbeException e) {
            return RestUtil.errorResponse(e, Response.Status.NOT_FOUND);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Override
    public Response createTarget(TargetBaseType targetDef) {
        JasmineTarget target = new JasmineTarget();
        target.setName(targetDef.getName());
        target.setType(targetDef.getType());
        HashMap<String, String> properties = new HashMap<String, String>();
        for (PropType prop : targetDef.getProperty()) {
            properties.put(prop.getKey(), prop.getValue());
        }
        target.setProperties(properties);
        try {
            this.jpManager.createTarget(target);
        }
        catch (JasmineProbeException e) {
            return RestUtil.errorResponse(e, Response.Status.BAD_REQUEST);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

