package org.ow2.jasmine.probe.rest.impl;

import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.ow2.jasmine.probe.JasmineProbeManager;
import org.ow2.jasmine.probe.JasminePropertyInfo;
import org.ow2.jasmine.probe.api.generated.PropInfoType;
import org.ow2.jasmine.probe.api.generated.ResourceType;
import org.ow2.jasmine.probe.rest.OutputTypes;

public class JOutputTypes implements OutputTypes {

    private JasmineProbeManager jpManager = null;

    public JOutputTypes(JasmineProbeManager jpManager) {
        this.jpManager = jpManager;
    }

    @Override
    public Response getOutputTypes() {
        List<JAXBElement<ResourceType>> elementsList = new ArrayList<JAXBElement<ResourceType>>();

        for (String type : jpManager.getOutputTypes()) {
            ResourceType typeElement = new ResourceType();
            typeElement.setType(type);

            QName qname  = new QName("org.ow2.jasmine.probe:probe-config", "outputType");
            JAXBElement xmlElement = new JAXBElement<ResourceType>(qname, ResourceType.class, typeElement);
            elementsList.add(xmlElement);
        }

        return Response
                        .status(Response.Status.OK)
                        .entity(new GenericEntity<List<JAXBElement<ResourceType>>>(elementsList) {})
                        .type(MediaType.APPLICATION_XML_TYPE)
                        .build();
    }

    public Response getOutputTypeProps(String type) {
        List<JAXBElement<PropInfoType>> elementsList = new ArrayList<JAXBElement<PropInfoType>>();

        List<JasminePropertyInfo> propertyInfos = jpManager.getOutputPropertyInfos(type);
        for (JasminePropertyInfo propertyInfo : propertyInfos) {
            PropInfoType propInfoElement = new PropInfoType();
            if (propertyInfo.isRequired()) {
                propInfoElement.setRequired("true");
            } else {
                propInfoElement.setRequired("false");
            }
            propInfoElement.setDescription(propertyInfo.getDescription());
            propInfoElement.setName(propertyInfo.getName());

            QName qname  = new QName("org.ow2.jasmine.probe:probe-config", "outputProperty");
            JAXBElement xmlElement = new JAXBElement<PropInfoType>(qname, PropInfoType.class, propInfoElement);
            elementsList.add(xmlElement);
        }

        return Response
                        .status(Response.Status.OK)
                        .entity(new GenericEntity<List<JAXBElement<PropInfoType>>>(elementsList) {})
                        .type(MediaType.APPLICATION_XML_TYPE)
                        .build();
    }

}
