/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.rules.cluster.cmi;

import java.util.HashSet;
import java.util.Set;
import org.ow2.cmi.controller.server.ServerClusterViewManager;
import org.ow2.cmi.reference.ServerId;
import org.ow2.cmi.reference.ServerNotFoundException;
import org.ow2.cmi.reference.ServerRef;
import org.ow2.jasmine.rules.cluster.cmi.ServerState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMIAction {
    private ServerClusterViewManager clusterViewManager;
    private static CMIAction cmiAction = null;

    private CMIAction() {
    }

    public static CMIAction getCMIAction() {
        if (cmiAction == null) {
            cmiAction = new CMIAction();
        }
        return cmiAction;
    }

    public void blacklistMe(String serverName) {
        if (this.clusterViewManager == null) {
            return;
        }
        for (ServerId serverId : this.getServerRefs(serverName)) {
            this.clusterViewManager.addServerToBlackList((ServerRef)serverId);
        }
    }

    public void unblacklistMe(String serverName) {
        if (this.clusterViewManager == null) {
            return;
        }
        for (ServerId serverId : this.getServerRefs(serverName)) {
            this.clusterViewManager.removeServerFromBlackList((ServerRef)serverId);
        }
    }

    public ServerState getServerState(String serverName) {
        if (this.clusterViewManager == null) {
            return null;
        }
        Set<ServerId> serverIds = this.getServerRefs(serverName);
        if (serverIds.isEmpty()) {
            return null;
        }
        boolean blacklisted = false;
        int loadFactor = Integer.MIN_VALUE;
        try {
            for (ServerId serverId : serverIds) {
                boolean bl = blacklisted = blacklisted || this.clusterViewManager.isServerBlackListed((ServerRef)serverId);
                int lf = this.clusterViewManager.getLoadFactor((ServerRef)serverId);
                if (lf <= loadFactor) continue;
                loadFactor = lf;
            }
        }
        catch (ServerNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return new ServerState(serverName, blacklisted, loadFactor);
    }

    public void setLoadFactor(String serverName, int loadFactor) {
        if (this.clusterViewManager == null) {
            return;
        }
        for (ServerId serverId : this.getServerRefs(serverName)) {
            this.clusterViewManager.setLoadFactor((ServerRef)serverId, loadFactor);
        }
    }

    private Set<ServerId> getServerRefs(String serverName) {
        HashSet<ServerId> serverRefs = new HashSet();
        if (serverName == null) {
            for (String protocol : this.clusterViewManager.getProtocols()) {
                serverRefs.add(this.clusterViewManager.getRefOnLocalRegistry(protocol));
            }
        } else {
            serverRefs = this.clusterViewManager.getRefsOnRegistries(serverName);
        }
        return serverRefs;
    }

    public void destroy() {
        this.clusterViewManager = null;
        cmiAction = null;
    }

    public void setClusterViewManager(ServerClusterViewManager clusterViewManager) {
        this.clusterViewManager = clusterViewManager;
    }
}

