/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ThreaDumpUtil.java 5826 2009-12-24 17:31:36Z eyindanga $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.rules.threadump;

import java.io.File;
import java.io.InputStream;
import java.util.Properties;

import org.osgi.framework.BundleContext;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/**
 * @author eyindanga
 *
 */
public final class ThreaDumpUtil {

    /**
     * Logger.
     */
    private static Log logger = LogFactory.getLog(ThreaDumpUtil.class);
    /**
     * Default private constructor.
     */
    private ThreaDumpUtil() {

    }

    public static ThreadDumpConfig loadConfig(final String configPath, BundleContext bundleContext) throws ThreadDumpException {
        if (configPath != null) {
            Properties prop = new Properties();
            InputStream stream = null;
            File f = new File(configPath);
            if (f.exists()) {
                try {
                    stream = f.getCanonicalFile().toURL().openStream();
                    prop.load(stream);
                    return new ThreadDumpConfig(prop);
                } catch (Exception e) {
                    throw new ThreadDumpException(e.getMessage());
                }
            }
        }
        return null;
    }

    public static void displayConfig(final ThreadDumpConfig cfg) {
        logger.debug("Thread dump configuration \n" + cfg);
    }
    /**
     * Convert the value of current used memory to the corresponding unit.
     * @param memoryThresholdUnit The unit to convert to.
     * @param byteValue the value of current used memory in bytes
     * @return the converted value
     * @throws ThreadDumpException. any.
     */
    public static double convertCurrentValue(final String memoryThresholdUnit,
            final String byteValue) throws ThreadDumpException {
        try {
            double val = Double.parseDouble(byteValue);
            if (ThreadDumpEnum.
                    MEMORY_THRESHOLD_UNIT_B.equals(memoryThresholdUnit)) {
                return val;
            }else if (ThreadDumpEnum.
                    MEMORY_THRESHOLD_UNIT_KB.equals(memoryThresholdUnit)) {
                return val / 1024;
            }else if (ThreadDumpEnum.
                    MEMORY_THRESHOLD_UNIT_GB.equals(memoryThresholdUnit)) {
                return val / (1024 * 1024 * 1024);
            }else if (ThreadDumpEnum.
                    MEMORY_THRESHOLD_UNIT_TB.equals(memoryThresholdUnit)) {
                return val / (1024 * 1024 * 1024 * 1024);
            }else {
                return val / (1024 * 1024);
            }
        } catch (Exception e) {
            throw new ThreadDumpException(e.getMessage());
        }
    }
    /**
     * Checks if the current memory value is >= memoryThreshold
     * @param curValue value of current used memory
     * @param memoryThreshold memory threshold.
     * @return <code>true</code> if so.
     */
    public static boolean checkit(double curValue, double memoryThreshold) {
        return curValue >= memoryThreshold;
    }
}
