/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ThreadDumpConfig.java 5827 2009-12-28 11:18:06Z eyindanga $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.rules.threadump;

import java.io.Serializable;
import java.util.Properties;

public class ThreadDumpConfig implements Serializable {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /**
     * Jmx URL of the target JOnAS server.
     */
    private String jonasJxmUrl = null;

    /**
     * Output type. Possible values are TTY, FILE
     */
    private String outputType = null;

    /**
     * Path of the output file.
     */
    private String outputFilePath = null;

    /**
     * Memory threshold.
     */
    private double memoryThreshold = -1L;

    /**
     * Memory threshold unit
     */
    private String memoryThresholdUnit = null;

    /**
     * How many times to repeat the thread dump.
     */
    private int repeat = -1;

    /**
     * How many times to repeat the thread dump: initial value.
     */
    private int initialRepeat = -1;

    /**
     * The name of the working memory.
     */
    private String workingMemory = null;


    /**
     * Urls of the targets.
     */

    private String targetFilter = null;


    /**
     * @return the targetFilter
     */
    public String getTargetFilter() {
        return targetFilter;
    }

    /**
     * @param targetFilter the targetFilter to set
     */
    public void setTargetFilter(String targetFilter) {
        this.targetFilter = targetFilter;
    }

    /**
     * @return the workingMemory
     */
    public String getWorkingMemory() {
        return workingMemory;
    }

    /**
     * @param workingMemory the workingMemory to set
     */
    public void setWorkingMemory(String workingMemory) {
        this.workingMemory = workingMemory;
    }

    /**
     * @return the repeat
     */
    public int getRepeat() {
        return repeat;
    }

    /**
     * @param repeat the repeat to set
     */
    public void setRepeat(int repeat) {
        this.repeat = repeat;
    }

    /**
     * Constructor that parses user properties.
     *
     * @param prop
     *            The properties to parse
     * @throws ThreadDumpException
     */

    public ThreadDumpConfig(Properties prop) throws ThreadDumpException {
        outputType = prop.getProperty(ThreadDumpEnum.OUTPUT_TYPE.getValue(),
                ThreadDumpEnum.OUTPUT_TYPE_TTY_VALUE.getValue());
        if (ThreadDumpEnum.OUTPUT_TYPE_FILE_VALUE.
                getValue().equalsIgnoreCase(outputType)) {
            // ThreadDump output is a file.
            // get the output path
            outputFilePath = prop.getProperty(
                    ThreadDumpEnum.OUTPUT_FILE_PATH.getValue());
            if (outputFilePath == null) {
                throw new ThreadDumpException("Please set the output file");
            }

        } else if (ThreadDumpEnum.OUTPUT_TYPE_TTY_VALUE.getValue()
                .equalsIgnoreCase(outputType)) {
            // output is TTY
        } else {
            throw new ThreadDumpException("Unrecognized output type "
                    + outputType);
        }
        try {
            String str = prop.getProperty(
                    ThreadDumpEnum.MEMORY_THRESHOLD.getValue());
            memoryThreshold = Double.parseDouble(str);
            memoryThresholdUnit = prop.getProperty(
                    ThreadDumpEnum.MEMORY_THRESHOLD_UNIT.getValue(),
                    ThreadDumpEnum.MEMORY_THRESHOLD_UNIT_MB.getValue());

            String repeat_str = prop.getProperty(
                    ThreadDumpEnum.REPEAT.getValue());
            /**
             * How many times to repeat the thread dump.
             */
             if (repeat_str != null) {
                 repeat = Integer.parseInt(repeat_str);
                 initialRepeat = Integer.parseInt(repeat_str);
             }
             workingMemory = prop.getProperty(
                     ThreadDumpEnum.WORKING_MEMORY.getValue(),
                     ThreadDumpEnum.DEF_WORKING_MEMORY.getValue());
             /**
              * get targets filter.
              */
             targetFilter = prop.getProperty(
                     ThreadDumpEnum.TARGET_JMXURLS.getValue());
        } catch (Exception e) {
            throw new ThreadDumpException(e.getMessage());
        }

    }

    /**
     * @return the memoryThreshold
     */
    public double getMemoryThreshold() {
        return memoryThreshold;
    }

    /**
     * @param memoryThreshold the memoryThreshold to set
     */
    public void setMemoryThreshold(long memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
    }

    /**
     * @return the memoryThresholdUnit
     */
    public String getMemoryThresholdUnit() {
        return memoryThresholdUnit;
    }

    /**
     * @param memoryThresholdUnit the memoryThresholdUnit to set
     */
    public void setMemoryThresholdUnit(String memoryThresholdUnit) {
        this.memoryThresholdUnit = memoryThresholdUnit;
    }

    /**
     * @return the jonasJxmUrl
     */
    public String getJonasJxmUrl() {
        return jonasJxmUrl;
    }

    /**
     * @param jonasJxmUrl
     *            the jonasJxmUrl to set
     */
    public void setJonasJxmUrl(String jonasJxmUrl) {
        this.jonasJxmUrl = jonasJxmUrl;
    }

    /**
     * @return the outputType
     */
    public String getOutputType() {
        return outputType;
    }

    /**
     * @param outputType
     *            the outputType to set
     */
    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    /**
     * @return the outputFilePath
     */
    public String getOutputFilePath() {
        return outputFilePath;
    }

    /**
     * @param outputFilePath
     *            the outputFilePath to set
     */
    public void setOutputFilePath(String outputFilePath) {
        this.outputFilePath = outputFilePath;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer("ThreadDumpConfig[output type: " + outputType
                + "\n");
        if (outputFilePath != null) {
            buff.append("output File Path: " + outputFilePath +  " \n");
        }
        if (jonasJxmUrl != null) {
            buff.append("Jmx Url: " + jonasJxmUrl + " \n");
        }
        buff.append("Repeat thread dump " + initialRepeat + " times. \n");
        buff.append("Target url filter " + targetFilter + " \n");
        buff.append("Working memory " + workingMemory + " \n");
        buff.append("Memory threshold " + memoryThreshold + " \n");
        buff.append("Memory threshold unit " + memoryThresholdUnit + "]");
        return buff.toString();
    }

}
