/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ThreadDumpEnum.java 5827 2009-12-28 11:18:06Z eyindanga $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.rules.threadump;

/**
 * @author eyindanga
 *
 */
public enum ThreadDumpEnum {
    /**
     * Prefix of thread dump properties.
     */
    THREAD_DUMP_PREFIX("thread.dump."),
    /**
     * If the output is a file.
     */
    CONFIG_FILE(THREAD_DUMP_PREFIX.value + "config"),

    /**
     * If the output is a file.
     */
    JONAS_BASE("jonas.base"),

    /**
     * If the output is a file.
     */
    CONFIG_FILE_DEFAULTNAME("myrules-config.properties"),
    /**
     * If the output is a file.
     */
    OUTPUT_TYPE_FILE_VALUE("file"),
    /**
     * If the output is a tty.
     */
    OUTPUT_TYPE_TTY_VALUE("tty"),
    /**
     * Prefix of output types.
     */
    OUTPUT_TYPE(THREAD_DUMP_PREFIX.value + "output.type"),
    /**
     * Memory treshold property.
     */
    MEMORY_THRESHOLD(THREAD_DUMP_PREFIX.value + "memory.threshold"),
    /**
     * Memory treshold unit.
     */
    MEMORY_THRESHOLD_UNIT(THREAD_DUMP_PREFIX.value + "memory.threshold.unit"),

    /**
     * Kilo Bytes Memory treshold unit.
     */
    MEMORY_THRESHOLD_UNIT_KB("KB"),

    /**
     * Bytes Memory treshold unit.
     */
    MEMORY_THRESHOLD_UNIT_B("B"),

    /**
     * Mega Bytes Memory treshold unit.
     */
    MEMORY_THRESHOLD_UNIT_MB("MB"),
    /**
     * Giga Bytes Memory treshold unit.
     */
    MEMORY_THRESHOLD_UNIT_GB("GB"),

    /**
     * Tera Bytes Memory treshold unit.
     */
    MEMORY_THRESHOLD_UNIT_TB("TB"),

    /**
     * Target JMX urls.
     */
    TARGET_JMXURLS(THREAD_DUMP_PREFIX.value + "target.jmxurls.regexp"),


    /**
     * Path of the output file.
     */
    OUTPUT_FILE_PATH(THREAD_DUMP_PREFIX.value + "output.file"),

    /**
     * Path of the output file.
     */
    WORKING_MEMORY(THREAD_DUMP_PREFIX.value + "wm"),

    /**
     * Path of the output file.
     */
    DEF_WORKING_MEMORY("autonomous"),
    /**
     * Dump the thread <code>repeat</code> times.
     */
    REPEAT(THREAD_DUMP_PREFIX.value + "repeat");
    /**
     * The value of the property.
     */
    private String value;
    /**
     * Constructor using value field.
     * @param field's value the value to set.
     */
    private ThreadDumpEnum(String value) {
        this.setValue(value);
    }
    /**
     * @param value the value to set
     */
    public void setValue(String value) {
        this.value = value;
    }
    /**
     * @return the value
     */
    public String getValue() {
        return value;
    }

}
