/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ThreadDumpActivator.java 5827 2009-12-28 11:18:06Z eyindanga $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.rules.threadump.osgi;

import java.io.File;

import org.osgi.framework.BundleContext;
import org.ow2.jasmine.rules.osgi.impl.RulesActivator;
import org.ow2.jasmine.rules.threadump.ThreaDumpUtil;
import org.ow2.jasmine.rules.threadump.ThreadDumpAction;
import org.ow2.jasmine.rules.threadump.ThreadDumpConfig;
import org.ow2.jasmine.rules.threadump.ThreadDumpEnum;
import org.ow2.jasmine.rules.threadump.ThreadDumpException;

/**
 * @author zeng-ls
 *
 */
public class ThreadDumpActivator extends RulesActivator {

    @Override
    protected void doStart(BundleContext context) throws Exception {
        String configFile = System.getProperty(
                ThreadDumpEnum.CONFIG_FILE.getValue());
        if (configFile == null) {
            String jonas_base = System.getProperty(
                    ThreadDumpEnum.JONAS_BASE.getValue());
            if (jonas_base != null) {
                File file = new File(jonas_base + File.separator + "conf",
                        ThreadDumpEnum.CONFIG_FILE_DEFAULTNAME.getValue());
                if (file.exists()) {
                    configFile = file.getAbsolutePath();
                }
            }
        }
        if (configFile == null) {
            throw new ThreadDumpException("No configuration file found " +
                    "for rule");
        }
        ThreadDumpAction threadDumpAction =
            ThreadDumpAction.getThreadDumpAction();
        ThreadDumpConfig cfg = ThreaDumpUtil.loadConfig(configFile, context);
        threadDumpAction.setThreadDumpConfig(cfg);
        ThreaDumpUtil.displayConfig(cfg);

        /**
         * Add this rule to the autonomous working memory.
         */
        workingMemoryName = cfg.getWorkingMemory();
        /**
         * Set threadDump action as global.
         */
        setGlobal("threadDumpAction", threadDumpAction);
    }

    @Override
    protected void doStop(BundleContext context) throws Exception {
        /**
         * Set threadDump action as global.
         */
        setGlobal("threadDumpAction", null);

    }

}
