/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.rules.threadump;

import java.io.File;
import java.io.InputStream;
import java.util.Properties;
import org.osgi.framework.BundleContext;
import org.ow2.jasmine.rules.threadump.ThreadDumpConfig;
import org.ow2.jasmine.rules.threadump.ThreadDumpEnum;
import org.ow2.jasmine.rules.threadump.ThreadDumpException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class ThreaDumpUtil {
    private static Log logger = LogFactory.getLog(ThreaDumpUtil.class);

    private ThreaDumpUtil() {
    }

    public static ThreadDumpConfig loadConfig(String configPath, BundleContext bundleContext) throws ThreadDumpException {
        if (configPath != null) {
            Properties prop = new Properties();
            InputStream stream = null;
            File f = new File(configPath);
            if (f.exists()) {
                try {
                    stream = f.getCanonicalFile().toURL().openStream();
                    prop.load(stream);
                    return new ThreadDumpConfig(prop);
                }
                catch (Exception e) {
                    throw new ThreadDumpException(e.getMessage());
                }
            }
        }
        return null;
    }

    public static void displayConfig(ThreadDumpConfig cfg) {
        logger.debug((Object)("Thread dump configuration \n" + cfg), new Object[0]);
    }

    public static double convertCurrentValue(String memoryThresholdUnit, String byteValue) throws ThreadDumpException {
        try {
            double val = Double.parseDouble(byteValue);
            if (ThreadDumpEnum.MEMORY_THRESHOLD_UNIT_B.equals(memoryThresholdUnit)) {
                return val;
            }
            if (ThreadDumpEnum.MEMORY_THRESHOLD_UNIT_KB.equals(memoryThresholdUnit)) {
                return val / 1024.0;
            }
            if (ThreadDumpEnum.MEMORY_THRESHOLD_UNIT_GB.equals(memoryThresholdUnit)) {
                return val / 1.073741824E9;
            }
            if (ThreadDumpEnum.MEMORY_THRESHOLD_UNIT_TB.equals(memoryThresholdUnit)) {
                return val / 0.0;
            }
            return val / 1048576.0;
        }
        catch (Exception e) {
            throw new ThreadDumpException(e.getMessage());
        }
    }

    public static boolean checkit(double curValue, double memoryThreshold) {
        return curValue >= memoryThreshold;
    }
}

