/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.rules.threadump;

import java.util.regex.Pattern;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.ow2.jasmine.rules.threadump.ThreaDumpUtil;
import org.ow2.jasmine.rules.threadump.ThreadDumpConfig;
import org.ow2.jasmine.rules.threadump.ThreadDumpEnum;
import org.ow2.jasmine.rules.threadump.ThreadDumpException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ThreadDumpAction {
    private static ThreadDumpAction threaDumpAction;
    private ThreadDumpConfig threadDumpConfig = null;
    private static Log logger;

    private ThreadDumpAction() {
    }

    public static ThreadDumpAction getThreadDumpAction() {
        if (threaDumpAction == null) {
            threaDumpAction = new ThreadDumpAction();
        }
        return threaDumpAction;
    }

    public void setThreadDumpConfig(ThreadDumpConfig threadDumpConfig) {
        this.threadDumpConfig = threadDumpConfig;
    }

    public ThreadDumpConfig getThreadDumpConfig() {
        return this.threadDumpConfig;
    }

    public void validate(String value, String jxmUrl, String domain, String serverName) throws ThreadDumpException {
        double curValue;
        if (this.getThreadDumpConfig().getJonasJxmUrl() == null) {
            this.getThreadDumpConfig().setJonasJxmUrl(jxmUrl);
        }
        if (ThreaDumpUtil.checkit(curValue = ThreaDumpUtil.convertCurrentValue(this.threadDumpConfig.getMemoryThresholdUnit(), value), this.threadDumpConfig.getMemoryThreshold())) {
            int repeat = this.threadDumpConfig.getRepeat();
            if (repeat == -1 || repeat > 0) {
                logger.debug((Object)(curValue + " >= " + this.threadDumpConfig.getMemoryThreshold() + " " + this.threadDumpConfig.getMemoryThresholdUnit() + " .Generating threadump"), new Object[0]);
                this.generateThreadDump(this.getThreadDumpConfig().getJonasJxmUrl(), domain, serverName);
            } else {
                logger.debug((Object)(curValue + " >= " + this.threadDumpConfig.getMemoryThreshold() + " " + this.threadDumpConfig.getMemoryThresholdUnit() + " But repeat times exceeded."), new Object[0]);
            }
        }
    }

    private void generateThreadDump(String jmxUrl, String domain, String serverName) throws ThreadDumpException {
        try {
            if (this.threadDumpConfig.getTargetFilter() != null && Pattern.matches(this.threadDumpConfig.getTargetFilter(), jmxUrl)) {
                JMXServiceURL url = new JMXServiceURL(jmxUrl);
                JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
                MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
                ObjectName mbeanName = new ObjectName(domain + ":j2eeType=J2EEServer,name=" + serverName);
                String opName = null;
                Object[] params = new String[]{""};
                String[] signature = new String[]{""};
                if (ThreadDumpEnum.OUTPUT_TYPE_FILE_VALUE.getValue().equalsIgnoreCase(this.threadDumpConfig.getOutputType())) {
                    opName = "printThreadStackDump";
                    params[0] = this.threadDumpConfig.getOutputFilePath();
                    signature[0] = "java.lang.String";
                } else {
                    opName = "logThreadStackDump";
                    params = null;
                    signature = null;
                }
                mbsc.invoke(mbeanName, opName, params, signature);
                int repeat = this.threadDumpConfig.getRepeat();
                if (repeat != -1) {
                    this.threadDumpConfig.setRepeat(--repeat);
                }
                this.threadDumpConfig.setJonasJxmUrl(jmxUrl);
            }
        }
        catch (Exception e) {
            throw new ThreadDumpException(e);
        }
    }

    static {
        logger = LogFactory.getLog(ThreadDumpAction.class);
    }
}

