/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.rules.threadump;

import java.io.Serializable;
import java.util.Properties;
import org.ow2.jasmine.rules.threadump.ThreadDumpEnum;
import org.ow2.jasmine.rules.threadump.ThreadDumpException;

public class ThreadDumpConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String jonasJxmUrl = null;
    private String outputType = null;
    private String outputFilePath = null;
    private double memoryThreshold = -1.0;
    private String memoryThresholdUnit = null;
    private int repeat = -1;
    private int initialRepeat = -1;
    private String workingMemory = null;
    private String targetFilter = null;

    public String getTargetFilter() {
        return this.targetFilter;
    }

    public void setTargetFilter(String targetFilter) {
        this.targetFilter = targetFilter;
    }

    public String getWorkingMemory() {
        return this.workingMemory;
    }

    public void setWorkingMemory(String workingMemory) {
        this.workingMemory = workingMemory;
    }

    public int getRepeat() {
        return this.repeat;
    }

    public void setRepeat(int repeat) {
        this.repeat = repeat;
    }

    public ThreadDumpConfig(Properties prop) throws ThreadDumpException {
        this.outputType = prop.getProperty(ThreadDumpEnum.OUTPUT_TYPE.getValue(), ThreadDumpEnum.OUTPUT_TYPE_TTY_VALUE.getValue());
        if (ThreadDumpEnum.OUTPUT_TYPE_FILE_VALUE.getValue().equalsIgnoreCase(this.outputType)) {
            this.outputFilePath = prop.getProperty(ThreadDumpEnum.OUTPUT_FILE_PATH.getValue());
            if (this.outputFilePath == null) {
                throw new ThreadDumpException("Please set the output file");
            }
        } else if (!ThreadDumpEnum.OUTPUT_TYPE_TTY_VALUE.getValue().equalsIgnoreCase(this.outputType)) {
            throw new ThreadDumpException("Unrecognized output type " + this.outputType);
        }
        try {
            String str = prop.getProperty(ThreadDumpEnum.MEMORY_THRESHOLD.getValue());
            this.memoryThreshold = Double.parseDouble(str);
            this.memoryThresholdUnit = prop.getProperty(ThreadDumpEnum.MEMORY_THRESHOLD_UNIT.getValue(), ThreadDumpEnum.MEMORY_THRESHOLD_UNIT_MB.getValue());
            String repeat_str = prop.getProperty(ThreadDumpEnum.REPEAT.getValue());
            if (repeat_str != null) {
                this.repeat = Integer.parseInt(repeat_str);
                this.initialRepeat = Integer.parseInt(repeat_str);
            }
            this.workingMemory = prop.getProperty(ThreadDumpEnum.WORKING_MEMORY.getValue(), ThreadDumpEnum.DEF_WORKING_MEMORY.getValue());
            this.targetFilter = prop.getProperty(ThreadDumpEnum.TARGET_JMXURLS.getValue());
        }
        catch (Exception e) {
            throw new ThreadDumpException(e.getMessage());
        }
    }

    public double getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public void setMemoryThreshold(long memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
    }

    public String getMemoryThresholdUnit() {
        return this.memoryThresholdUnit;
    }

    public void setMemoryThresholdUnit(String memoryThresholdUnit) {
        this.memoryThresholdUnit = memoryThresholdUnit;
    }

    public String getJonasJxmUrl() {
        return this.jonasJxmUrl;
    }

    public void setJonasJxmUrl(String jonasJxmUrl) {
        this.jonasJxmUrl = jonasJxmUrl;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    public String getOutputFilePath() {
        return this.outputFilePath;
    }

    public void setOutputFilePath(String outputFilePath) {
        this.outputFilePath = outputFilePath;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("ThreadDumpConfig[output type: " + this.outputType + "\n");
        if (this.outputFilePath != null) {
            buff.append("output File Path: " + this.outputFilePath + " \n");
        }
        if (this.jonasJxmUrl != null) {
            buff.append("Jmx Url: " + this.jonasJxmUrl + " \n");
        }
        buff.append("Repeat thread dump " + this.initialRepeat + " times. \n");
        buff.append("Target url filter " + this.targetFilter + " \n");
        buff.append("Working memory " + this.workingMemory + " \n");
        buff.append("Memory threshold " + this.memoryThreshold + " \n");
        buff.append("Memory threshold unit " + this.memoryThresholdUnit + "]");
        return buff.toString();
    }
}

