/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.rules.threadump.osgi;

import java.io.File;
import org.osgi.framework.BundleContext;
import org.ow2.jasmine.rules.osgi.impl.RulesActivator;
import org.ow2.jasmine.rules.threadump.ThreaDumpUtil;
import org.ow2.jasmine.rules.threadump.ThreadDumpAction;
import org.ow2.jasmine.rules.threadump.ThreadDumpConfig;
import org.ow2.jasmine.rules.threadump.ThreadDumpEnum;
import org.ow2.jasmine.rules.threadump.ThreadDumpException;

public class ThreadDumpActivator
extends RulesActivator {
    protected void doStart(BundleContext context) throws Exception {
        File file;
        String jonas_base;
        String configFile = System.getProperty(ThreadDumpEnum.CONFIG_FILE.getValue());
        if (configFile == null && (jonas_base = System.getProperty(ThreadDumpEnum.JONAS_BASE.getValue())) != null && (file = new File(jonas_base + File.separator + "conf", ThreadDumpEnum.CONFIG_FILE_DEFAULTNAME.getValue())).exists()) {
            configFile = file.getAbsolutePath();
        }
        if (configFile == null) {
            throw new ThreadDumpException("No configuration file found for rule");
        }
        ThreadDumpAction threadDumpAction = ThreadDumpAction.getThreadDumpAction();
        ThreadDumpConfig cfg = ThreaDumpUtil.loadConfig(configFile, context);
        threadDumpAction.setThreadDumpConfig(cfg);
        ThreaDumpUtil.displayConfig(cfg);
        this.workingMemoryName = cfg.getWorkingMemory();
        this.setGlobal("threadDumpAction", threadDumpAction);
    }

    protected void doStop(BundleContext context) throws Exception {
        this.setGlobal("threadDumpAction", null);
    }
}

