/**
 * JASMINe VMMapi: JASMINe Virtual Machine Management API
 * Copyright (C) 2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JMXUtil.java 3177 2009-03-20 13:30:34Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.vmm.agent.jmx;

import java.lang.reflect.Proxy;

import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;

/**
 * Various JMX-related utility methods
 */
public class JMXUtil {
    /**
     * Returns the object name of a the MBean represented by the given proxy
     *
     * @param proxy MBean proxy
     * @return the object name of the MBean
     */
    public static ObjectName proxyToObjectName(final Object proxy) {
        MBeanServerInvocationHandler ih = (MBeanServerInvocationHandler) Proxy.getInvocationHandler(proxy);
        return ih.getObjectName();
    }

    /**
     * Transforms a MBean proxy to a notification emitter
     *
     * @param proxy MBean proxy
     * @return the notification emitter
     */
    public static NotificationEmitter proxyToEmitter(final Object proxy) {
        MBeanServerInvocationHandler ih = (MBeanServerInvocationHandler) Proxy.getInvocationHandler(proxy);
        MBeanServerConnection mbsc = ih.getMBeanServerConnection();
        ObjectName name = ih.getObjectName();
        return (NotificationEmitter) JMX.newMXBeanProxy(mbsc, name, Cloneable.class, true);
    }

    /**
     * Cast a MBean proxy to a given type
     *
     * @param <E> type of the proxy to return
     * @param proxy MBean proxy
     * @param c
     * @return proxy of the target type
     */
    public static <E> E castProxy(final Object proxy, final Class<E> c) {
        MBeanServerInvocationHandler ih = (MBeanServerInvocationHandler) Proxy.getInvocationHandler(proxy);
        MBeanServerConnection mbsc = ih.getMBeanServerConnection();
        ObjectName name = ih.getObjectName();
        return JMX.newMXBeanProxy(mbsc, name, c, true);
    }
}
