/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.vmware;

import com.vmware.vim.ArrayOfManagedObjectReference;
import com.vmware.vim.DynamicProperty;
import com.vmware.vim.ManagedObjectReference;
import com.vmware.vim.ObjectContent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.domain.ServerPool;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareEventCollector;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareHost;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareServiceConnection;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineImageMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;

class VMwareServerPool
extends ServerPool {
    protected static Logger logger = Logger.getLogger(VMwareServerPool.class);
    private static int KEEP_ALIVE_PERIOD_MS = 120000;
    private static final int THREADPOOL_SIZE = 20;
    private static ExecutorService executorService = Executors.newFixedThreadPool(20);
    private VMwareServiceConnection connection;
    private HashMap<String, VMwareHost> hostRefs = new HashMap();
    private String mountPoint;
    private ManagedObjectReference mountedFolderRef;
    private ManagedObjectReference vmFolderRef;
    private ManagedObjectReference datastoreRef;
    private VMwareVMTemplateDataStore imageStore;

    public VMwareServerPool(String name, ObjectName objectName, Properties props) throws VMMException {
        super(name, objectName);
        String hostName = props.getProperty("virtualCenterHostName");
        this.mountPoint = props.getProperty("mountpoint");
        String userName = props.getProperty("user");
        String password = props.getProperty("password");
        String datastoreName = props.getProperty("datastore");
        try {
            this.connection = new VMwareServiceConnection(hostName, userName, password);
            logger.debug((Object)"Connecting to Virtual Center...");
            this.connection.connect();
            logger.debug((Object)"Done.");
            this.mountedFolderRef = this.connection.getService().findByInventoryPath(this.connection.getServiceContent().getSearchIndex(), this.mountPoint);
            if (this.mountedFolderRef == null) {
                String msg = "VMware Driver initialization error: mountpoint " + this.mountPoint + " not found ";
                logger.error((Object)msg);
                throw new VMMException(msg);
            }
            this.vmFolderRef = (ManagedObjectReference)this.getDynamicProarray(this.mountedFolderRef, "vmFolder")[0].getVal();
            if (this.vmFolderRef == null) {
                String msg = "VMware Driver initialization error: virtual machine Folder is not found";
                logger.error((Object)msg);
                throw new VMMException(msg);
            }
            ArrayOfManagedObjectReference dataStoreRefs = (ArrayOfManagedObjectReference)this.getDynamicProarray(this.mountedFolderRef, "datastore")[0].getVal();
            if (dataStoreRefs != null) {
                for (int i = 0; i < dataStoreRefs.getManagedObjectReference().length; ++i) {
                    String dsName = (String)this.getDynamicProarray(dataStoreRefs.getManagedObjectReference(i), "info.name")[0].getVal();
                    if (!dsName.equals(datastoreName)) continue;
                    this.datastoreRef = dataStoreRefs.getManagedObjectReference(i);
                    break;
                }
            }
            if (this.datastoreRef == null) {
                String msg = "VMware Driver initialization error: Datastore " + datastoreName + " cannot be found";
                logger.error((Object)msg);
                throw new VMMException(msg);
            }
            String vmImageStoreName = this.mountPoint + "-VMIStore";
            this.imageStore = new VMwareVMTemplateDataStore(MBeanObjectNamer.makeVMImageStoreName(vmImageStoreName), vmImageStoreName, this.datastoreRef);
            AgentCommon.getMBeanServer().registerMBean(this.imageStore, this.imageStore.getObjectName());
        }
        catch (Exception ex) {
            String msg = "VMware Driver initialization error: " + ex.getMessage();
            logger.error((Object)msg, (Throwable)ex);
            throw new VMMException(msg);
        }
        new VMwareEventCollector(this, new VMwareServiceConnection(hostName, userName, password), this.mountPoint).start();
        executorService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(KEEP_ALIVE_PERIOD_MS);
                            VMwareServiceConnection vMwareServiceConnection = VMwareServerPool.this.connection;
                            synchronized (vMwareServiceConnection) {
                                Calendar calendar = VMwareServerPool.this.connection.getService().currentTime(VMwareServerPool.this.connection.getServiceInstanceRef());
                            }
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)"error", (Throwable)ex);
                        continue;
                    }
                    break;
                }
            }
        });
    }

    public ExecutorService getExecutorService() {
        return executorService;
    }

    public VMwareServiceConnection getConnection() {
        return this.connection;
    }

    @Override
    public VirtualMachineImageStoreMXBean getVMImageStore() {
        return this.imageStore;
    }

    public String getMountPoint() {
        return this.mountPoint;
    }

    VMwareHost getHostByName(String name) {
        return this.hostRefs.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HostMXBean newHost(String hostName, Map<String, String> props) {
        VMwareHost host = this.hostRefs.get(hostName);
        if (host != null) {
            return host;
        }
        ManagedObjectReference mor = null;
        try {
            VMwareServiceConnection vMwareServiceConnection = this.connection;
            synchronized (vMwareServiceConnection) {
                mor = this.connection.getDecendentMoRef(null, "HostSystem", hostName);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Unable to find HostSystem managed object " + hostName + " in VMware VC inventory"), (Throwable)ex);
            return null;
        }
        if (mor == null) {
            logger.error((Object)("Host " + hostName + " not found"));
            return null;
        }
        ObjectName mbeanObjectName = MBeanObjectNamer.makeHostName(this.getPath() + "/" + hostName, hostName);
        host = new VMwareHost(this, mor, mbeanObjectName, hostName);
        host.getResidentVMs();
        try {
            AgentCommon.getMBeanServer().registerMBean(host, mbeanObjectName);
        }
        catch (Exception ex) {
            logger.error((Object)("Unable to register MBean " + mbeanObjectName), (Throwable)ex);
            return null;
        }
        this.hostRefs.put(hostName, host);
        this.addHost(host);
        return host;
    }

    public ManagedObjectReference getMountedFolderRef() {
        return this.mountedFolderRef;
    }

    public ManagedObjectReference getVmFolderRef() {
        return this.vmFolderRef;
    }

    public ManagedObjectReference getDatastoreRef() {
        return this.datastoreRef;
    }

    private DynamicProperty[] getDynamicProarray(ManagedObjectReference MOR, String pName) throws Exception {
        ObjectContent[] objContent = this.connection.getObjectProperties(null, MOR, new String[]{pName});
        ObjectContent contentObj = objContent[0];
        DynamicProperty[] objArr = contentObj.getPropSet();
        return objArr;
    }

    private static class VMwareVirtualMachineImage
    extends ManagedResource
    implements VirtualMachineImageMXBean {
        private String name;
        private String uuid;

        public VMwareVirtualMachineImage(ObjectName objectName, String name, String uuid) {
            super(objectName);
            this.name = name;
            this.uuid = uuid;
        }

        public String getName() {
            return this.name;
        }

        public String getUUID() {
            return this.name;
        }

        public String getMetaData() {
            return "";
        }

        public String toString() {
            return "VMwareTemplate(name=" + this.getName() + ",uuid=" + this.getUUID() + ")";
        }
    }

    private class VMwareVMTemplateDataStore
    extends ManagedResource
    implements VirtualMachineImageStoreMXBean {
        private String name;
        private ArrayList<VirtualMachineImageMXBean> imageList;
        private ManagedObjectReference datastoreRef;

        public VMwareVMTemplateDataStore(ObjectName objectName, String name, ManagedObjectReference datastoreRef) {
            super(objectName);
            this.imageList = new ArrayList();
            this.name = name;
            this.datastoreRef = datastoreRef;
        }

        public long getCapacityMB() {
            try {
                long capacityInBytes = (Long)VMwareServerPool.this.getDynamicProarray(this.datastoreRef, "summary.capacity")[0].getVal();
                return capacityInBytes / 1024L;
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to get datastore capacity", (Throwable)ex);
                return -1L;
            }
        }

        public long getFreeSpaceMB() {
            try {
                long freeSpaceInBytes = (Long)VMwareServerPool.this.getDynamicProarray(this.datastoreRef, "summary.freeSpace")[0].getVal();
                return freeSpaceInBytes / 1024L;
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to get datastore free space", (Throwable)ex);
                return -1L;
            }
        }

        public String getName() {
            return this.name;
        }

        public List<VirtualMachineImageMXBean> listVMImageTemplates() {
            if (this.imageList.size() == 0) {
                try {
                    ArrayList vms = VMwareServerPool.this.connection.getDecendentMoRefs(VMwareServerPool.this.getMountedFolderRef(), "VirtualMachine");
                    for (ManagedObjectReference vmMor : vms) {
                        DynamicProperty[] properties;
                        boolean isTemplate = (Boolean)VMwareServerPool.this.getDynamicProarray(vmMor, "summary.config.template")[0].getVal();
                        if (!isTemplate || (properties = VMwareServerPool.this.getDynamicProarray(vmMor, "config.name")) == null || properties.length < 1) continue;
                        String vmName = (String)properties[0].getVal();
                        String uuid = (String)VMwareServerPool.this.getDynamicProarray(vmMor, "config.uuid")[0].getVal();
                        ObjectName on = MBeanObjectNamer.makeVMImageName(uuid);
                        VMwareVirtualMachineImage image = new VMwareVirtualMachineImage(on, vmName, uuid);
                        logger.debug((Object)("New VMware template: " + image));
                        AgentCommon.getMBeanServer().registerMBean(image, on);
                        this.imageList.add(image);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to list VM templates", (Throwable)ex);
                }
            }
            return this.imageList;
        }

        public VirtualMachineImageMXBean lookUpByUUID(String uuid) {
            for (VirtualMachineImageMXBean image : this.imageList) {
                if (!image.getUUID().equals(uuid)) continue;
                return image;
            }
            return null;
        }

        public void removeVMImageTemplate(VirtualMachineImageMXBean vmImage) throws VMMException {
            String vmImageID = vmImage.getUUID();
            try {
                ManagedObjectReference vmMOR = VMwareServerPool.this.connection.getDecendentMoRef(null, "VirtualMachine", vmImageID);
                VMwareServerPool.this.connection.getService().destroy_Task(vmMOR);
            }
            catch (Exception ex) {
                logger.error((Object)("Failed to retrieve VM reference " + vmImageID), (Throwable)ex);
            }
        }
    }
}

