/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.xen;

import java.util.Map;
import java.util.Properties;
import javax.management.ObjectName;
import org.ow2.jasmine.vmm.agent.domain.ServerPool;
import org.ow2.jasmine.vmm.agent.driver.xen.XenHost;
import org.ow2.jasmine.vmm.agent.driver.xen.XenVMImageStore;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;

public class XenServerPool
extends ServerPool {
    private String xenAPIPort;
    private String xenAPIUser;
    private String xenAPIPassword;
    private VirtualMachineImageStoreMXBean imageStore;
    private String vmmDomain0HomeDir;
    private String vmImageStoreDir;
    private String sshPassword;

    public XenServerPool(String name, ObjectName objectName, Properties props) {
        super(name, objectName);
        this.xenAPIPort = props.getProperty("xenapiDefaulPort", "9363");
        this.xenAPIUser = props.getProperty("xenapiDefaultUser", "root");
        this.xenAPIPassword = props.getProperty("xenapiDefaultPassword");
        this.vmmDomain0HomeDir = props.getProperty("vmmDomain0HomeDir", "/opt/vmm");
        this.vmImageStoreDir = props.getProperty("vmImageStoreDir", "/var/xen/images/templates");
        this.sshPassword = props.getProperty("sshDefaultRootPassword");
    }

    @Override
    public HostMXBean newHost(String hostName, Map<String, String> props) {
        try {
            HostMXBean host2;
            for (HostMXBean host2 : this.hosts) {
                if (!host2.getHostName().equals(hostName)) continue;
                return host2;
            }
            ObjectName mbeanObjectName = MBeanObjectNamer.makeHostName(this.getPath() + "/" + hostName, hostName);
            host2 = XenHost.newHost(this, mbeanObjectName, hostName, new XenHost.XenAPIParams(this.xenAPIPort, this.xenAPIUser, this.xenAPIPassword), this.sshPassword);
            if (host2 != null) {
                AgentCommon.getMBeanServer().registerMBean(host2, mbeanObjectName);
                this.hosts.add(host2);
                logger.info((Object)("In domain " + this.name + ": added Host MBean " + mbeanObjectName));
                if (this.imageStore == null) {
                    ObjectName defaultDataStoreName = MBeanObjectNamer.makeVMImageStoreName(hostName + ".default");
                    this.imageStore = new XenVMImageStore(defaultDataStoreName, this.vmImageStoreDir, hostName, this.vmmDomain0HomeDir, this.sshPassword);
                    AgentCommon.getMBeanServer().registerMBean(this.imageStore, defaultDataStoreName);
                }
            }
            return host2;
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to add XenHost", (Throwable)ex);
            return null;
        }
    }

    @Override
    public VirtualMachineImageStoreMXBean getVMImageStore() {
        return this.imageStore;
    }

    public String getVMMDomain0HomeDir() {
        return this.vmmDomain0HomeDir;
    }
}

