/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.xen;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.driver.util.RemoteExec;
import org.ow2.jasmine.vmm.agent.driver.xen.Utils;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineImageMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XenVMImageStore
extends ManagedResource
implements VirtualMachineImageStoreMXBean {
    static Logger logger = Logger.getLogger(XenVMImageStore.class);
    private String rootDirectory;
    private String storeServer;
    private String sshPassword;
    private String vmmDomain0HomeDir;
    private ArrayList<XenVirtualMachineImage> vmList = new ArrayList();

    public XenVMImageStore(ObjectName objectName, String rootDirectory, String storeServer, String vmmDomain0HomeDir, String sshPassword) throws VMMException {
        super(objectName);
        this.storeServer = storeServer;
        this.rootDirectory = rootDirectory;
        this.sshPassword = sshPassword;
        this.vmmDomain0HomeDir = vmmDomain0HomeDir;
        this.sync();
    }

    public void removeVMImageTemplate(VirtualMachineImageMXBean vmImage) throws VMMException {
        String vmImageID = vmImage.getUUID();
        try {
            String command = this.vmmDomain0HomeDir + "/bin/deleteVMTemplate " + vmImageID;
            logger.debug((Object)("Removing VM image: " + command));
            RemoteExec.Result result = RemoteExec.commandAsRoot(this.storeServer, this.sshPassword, command);
            if (result.exitCode != 0) {
                logger.error((Object)result.error);
                throw new VMMException(result.error);
            }
        }
        catch (Exception ex) {
            throw new VMMException(ex.getMessage());
        }
    }

    synchronized void sync() throws VMMException {
        String[] imageFileNames;
        RemoteExec.Result result;
        try {
            String command = "cd " + this.rootDirectory + " ; ls -1 *.xml";
            logger.debug((Object)("Listing VM images: " + command));
            result = RemoteExec.commandAsRoot(this.storeServer, this.sshPassword, command);
        }
        catch (RemoteExec.SshException ex) {
            throw new VMMException(ex.getMessage());
        }
        if (result.exitCode != 0) {
            logger.error((Object)result.error);
            throw new VMMException(result.error);
        }
        for (String fileName : imageFileNames = result.output.split("\\s+")) {
            XenVirtualMachineImage image;
            String uuid = fileName.substring(0, fileName.length() - 4);
            if (this.lookUpByUUID(uuid) != null) continue;
            String command = "cd " + this.rootDirectory + " ; cat " + fileName;
            try {
                result = RemoteExec.commandAsRoot(this.storeServer, this.sshPassword, command);
            }
            catch (RemoteExec.SshException ex) {
                logger.error((Object)"SSH failure", (Throwable)ex);
                continue;
            }
            if (result.exitCode != 0 || (image = XenVirtualMachineImage.newVMImage(MBeanObjectNamer.makeVMImageName(uuid), result.output)) == null) continue;
            try {
                AgentCommon.getMBeanServer().registerMBean(image, image.getObjectName());
                logger.info((Object)("Added VMImage " + image.name + " (" + image.description + ")"));
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to register VMImage MBean", (Throwable)ex);
                continue;
            }
            this.vmList.add(image);
        }
        for (XenVirtualMachineImage image : this.vmList) {
            boolean match = false;
            for (String fileName : imageFileNames) {
                String uuid = fileName.substring(0, fileName.length() - 4);
                if (!image.getUUID().equals(uuid)) continue;
                match = true;
                break;
            }
            if (match) continue;
            try {
                AgentCommon.getMBeanServer().unregisterMBean(MBeanObjectNamer.makeVMImageName(image.getName()));
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to unregister VMImage MBean", (Throwable)ex);
            }
            this.vmList.remove(image);
        }
    }

    void newTemplateFromVMImage(String vmName, String vmImageUUID, String name, String description) throws VMMException {
        RemoteExec.Result result = null;
        try {
            String command = this.vmmDomain0HomeDir + "/bin/makeNewVMTemplate " + vmName + " " + vmImageUUID + " \"" + name + "\" \"" + description + "\"";
            logger.debug((Object)("Creating new VM image from VM " + vmName + "...\n"));
            result = RemoteExec.commandAsRoot(this.storeServer, this.sshPassword, command);
        }
        catch (Exception ex) {
            logger.error((Object)("SSH failure with host " + this.storeServer), (Throwable)ex);
        }
        if (result.exitCode != 0) {
            logger.error((Object)result.error);
            throw new VMMException(result.error);
        }
        this.sync();
    }

    public VirtualMachineImageMXBean lookUpByName(String name) {
        for (XenVirtualMachineImage image : this.vmList) {
            if (!image.getName().equals(name)) continue;
            return image;
        }
        return null;
    }

    public VirtualMachineImageMXBean lookUpByUUID(String uuid) {
        for (XenVirtualMachineImage image : this.vmList) {
            if (!image.getUUID().equals(uuid)) continue;
            return image;
        }
        return null;
    }

    public List<VirtualMachineImageMXBean> listVMImageTemplates() {
        ArrayList<VirtualMachineImageMXBean> result = new ArrayList<VirtualMachineImageMXBean>(this.vmList);
        return result;
    }

    public long getCapacityMB() {
        return Utils.getDiskCapacityMB(this.storeServer, this.sshPassword, this.rootDirectory);
    }

    public long getFreeSpaceMB() {
        return Utils.getDiskFreeSpaceMB(this.storeServer, this.sshPassword, this.rootDirectory);
    }

    public String getName() {
        return "DiskImageStore(" + this.rootDirectory + ")";
    }

    private static class XenVirtualMachineImage
    extends ManagedResource
    implements VirtualMachineImageMXBean {
        private String name;
        private String uuid;
        private String metadata;
        private String description;
        private String imageFile;

        public static XenVirtualMachineImage newVMImage(ObjectName objectName, String metadata) {
            ByteArrayInputStream stream = new ByteArrayInputStream(metadata.getBytes());
            XenVirtualMachineImage vmi = new XenVirtualMachineImage(objectName);
            VMIXMLHandler handler = new VMIXMLHandler(vmi);
            try {
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                parser.parse((InputStream)stream, (DefaultHandler)handler);
            }
            catch (Exception ex) {
                return null;
            }
            vmi.metadata = new String(metadata);
            return vmi;
        }

        private XenVirtualMachineImage(ObjectName objectName) {
            super(objectName);
        }

        public String getMetaData() {
            return this.metadata;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getUUID() {
            return this.uuid;
        }

        public String getImageFile() {
            return this.imageFile;
        }

        static class VMIXMLHandler
        extends DefaultHandler {
            XenVirtualMachineImage vmi;
            String currentText;

            VMIXMLHandler(XenVirtualMachineImage vmi) {
                this.vmi = vmi;
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attrs) {
                if (qName.equals("virtualMachineImage")) {
                    String name = attrs.getValue("name");
                    String uuid = attrs.getValue("uuid");
                    this.vmi.name = name;
                    this.vmi.uuid = uuid;
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) {
                this.currentText = "";
                for (int i = start; i < start + length; ++i) {
                    this.currentText = this.currentText + ch[i];
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (qName.equals("description")) {
                    this.vmi.description = this.currentText;
                } else if (qName.equals("imageFile")) {
                    this.vmi.imageFile = this.currentText;
                }
            }
        }
    }
}

