package org.ow2.jasmine.vmm.agent.domain.policy;

import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.ServerPoolMXBean;
import org.ow2.jasmine.vmm.api.VMConfigSpec;

/**
 * The VMPlacementPolicy interface abstracts a VM placement policy which decides
 * on which host of server pool a new virtual machine should be place. Every
 * server pool is associated with one VM placement policy.
 */
public interface VMPlacementPolicy {

    /**
     * Returns the host of a server pool where the virtual machine whose
     * configuration is provided as input should be placed.
     *
     * @param pool the server pool where the virtual machine is to placed
     * @param vmSpec the configuration of the virtual machine
     * @return the host where the virtual machine should be placed or null if
     *         the policy is unable to place the virtual machine due to lack of
     *         resources
     */
    HostMXBean placeVM(ServerPoolMXBean pool, VMConfigSpec vmSpec);

}