/*
 * Decompiled with CFR 0.152.
 */
package com.xensource.xenapi;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Host;
import com.xensource.xenapi.Marshalling;
import com.xensource.xenapi.PoolPatch;
import com.xensource.xenapi.Task;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.XenAPIObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.SoftReference;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostPatch
extends XenAPIObject {
    protected final String ref;
    private static final Map<String, SoftReference<HostPatch>> cache = new HashMap<String, SoftReference<HostPatch>>();

    private HostPatch(String ref) {
        this.ref = ref;
    }

    @Override
    public String toWireString() {
        return this.ref;
    }

    protected static synchronized HostPatch getInstFromRef(String ref) {
        HostPatch instance;
        if (cache.containsKey(ref) && (instance = cache.get(ref).get()) != null) {
            return instance;
        }
        instance = new HostPatch(ref);
        cache.put(ref, new SoftReference<HostPatch>(instance));
        return instance;
    }

    public Record getRecord(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host_patch.get_record";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toHostPatchRecord(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static HostPatch getByUuid(Connection c, String uuid) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host_patch.get_by_uuid";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(uuid)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toHostPatch(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static Set<HostPatch> getByNameLabel(Connection c, String label) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host_patch.get_by_name_label";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(label)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfHostPatch(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getUuid(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host_patch.get_uuid";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getNameLabel(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host_patch.get_name_label";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getNameDescription(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host_patch.get_name_description";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getVersion(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host_patch.get_version";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Host getHost(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host_patch.get_host";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toHost(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Boolean getApplied(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host_patch.get_applied";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toBoolean(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Date getTimestampApplied(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host_patch.get_timestamp_applied";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toDate(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Long getSize(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host_patch.get_size";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toLong(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public PoolPatch getPoolPatch(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host_patch.get_pool_patch";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toPoolPatch(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, String> getOtherConfig(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host_patch.get_other_config";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void setOtherConfig(Connection c, Map<String, String> otherConfig) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host_patch.set_other_config";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(otherConfig)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void addToOtherConfig(Connection c, String key, String value) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host_patch.add_to_other_config";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key), Marshalling.toXMLRPC(value)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void removeFromOtherConfig(Connection c, String key) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host_patch.remove_from_other_config";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    @Deprecated
    public Task destroyAsync(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.host_patch.destroy";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    @Deprecated
    public void destroy(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host_patch.destroy";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    @Deprecated
    public Task applyAsync(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.host_patch.apply";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    @Deprecated
    public String apply(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host_patch.apply";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static Set<HostPatch> getAll(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host_patch.get_all";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfHostPatch(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static Map<HostPatch, Record> getAllRecords(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host_patch.get_all_records";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfHostPatchHostPatchRecord(result);
        }
        throw new Types.BadServerResponse(response);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Record
    implements Types.Record {
        public String uuid;
        public String nameLabel;
        public String nameDescription;
        public String version;
        public Host host;
        public Boolean applied;
        public Date timestampApplied;
        public Long size;
        public PoolPatch poolPatch;
        public Map<String, String> otherConfig;

        public String toString() {
            StringWriter writer = new StringWriter();
            PrintWriter print = new PrintWriter(writer);
            print.printf("%1$20s: %2$s\n", "uuid", this.uuid);
            print.printf("%1$20s: %2$s\n", "nameLabel", this.nameLabel);
            print.printf("%1$20s: %2$s\n", "nameDescription", this.nameDescription);
            print.printf("%1$20s: %2$s\n", "version", this.version);
            print.printf("%1$20s: %2$s\n", "host", this.host);
            print.printf("%1$20s: %2$s\n", "applied", this.applied);
            print.printf("%1$20s: %2$s\n", "timestampApplied", this.timestampApplied);
            print.printf("%1$20s: %2$s\n", "size", this.size);
            print.printf("%1$20s: %2$s\n", "poolPatch", this.poolPatch);
            print.printf("%1$20s: %2$s\n", "otherConfig", this.otherConfig);
            return writer.toString();
        }

        @Override
        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("uuid", this.uuid);
            map.put("name_label", this.nameLabel);
            map.put("name_description", this.nameDescription);
            map.put("version", this.version);
            map.put("host", this.host);
            map.put("applied", this.applied);
            map.put("timestamp_applied", this.timestampApplied);
            map.put("size", this.size);
            map.put("pool_patch", this.poolPatch);
            map.put("other_config", this.otherConfig);
            return map;
        }
    }
}

