/*
 * Decompiled with CFR 0.152.
 */
package com.xensource.xenapi;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Marshalling;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.XenAPIObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.SoftReference;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMMetrics
extends XenAPIObject {
    protected final String ref;
    private static final Map<String, SoftReference<VMMetrics>> cache = new HashMap<String, SoftReference<VMMetrics>>();

    private VMMetrics(String ref) {
        this.ref = ref;
    }

    @Override
    public String toWireString() {
        return this.ref;
    }

    protected static synchronized VMMetrics getInstFromRef(String ref) {
        VMMetrics instance;
        if (cache.containsKey(ref) && (instance = cache.get(ref).get()) != null) {
            return instance;
        }
        instance = new VMMetrics(ref);
        cache.put(ref, new SoftReference<VMMetrics>(instance));
        return instance;
    }

    public Record getRecord(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_metrics.get_record";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toVMMetricsRecord(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static VMMetrics getByUuid(Connection c, String uuid) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_metrics.get_by_uuid";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(uuid)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toVMMetrics(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getUuid(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_metrics.get_uuid";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Long getMemoryActual(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_metrics.get_memory_actual";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toLong(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Long getVCPUsNumber(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_metrics.get_VCPUs_number";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toLong(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<Long, Double> getVCPUsUtilisation(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_metrics.get_VCPUs_utilisation";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfLongDouble(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<Long, Long> getVCPUsCPU(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_metrics.get_VCPUs_CPU";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfLongLong(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, String> getVCPUsParams(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_metrics.get_VCPUs_params";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<Long, Set<String>> getVCPUsFlags(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_metrics.get_VCPUs_flags";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfLongSetOfString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Set<String> getState(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_metrics.get_state";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Date getStartTime(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_metrics.get_start_time";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toDate(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Date getInstallTime(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_metrics.get_install_time";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toDate(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Date getLastUpdated(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_metrics.get_last_updated";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toDate(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static Set<VMMetrics> getAll(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_metrics.get_all";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfVMMetrics(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static Map<VMMetrics, Record> getAllRecords(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_metrics.get_all_records";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfVMMetricsVMMetricsRecord(result);
        }
        throw new Types.BadServerResponse(response);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Record
    implements Types.Record {
        public String uuid;
        public Long memoryActual;
        public Long VCPUsNumber;
        public Map<Long, Double> VCPUsUtilisation;
        public Map<Long, Long> VCPUsCPU;
        public Map<String, String> VCPUsParams;
        public Map<Long, Set<String>> VCPUsFlags;
        public Set<String> state;
        public Date startTime;
        public Date installTime;
        public Date lastUpdated;

        public String toString() {
            StringWriter writer = new StringWriter();
            PrintWriter print = new PrintWriter(writer);
            print.printf("%1$20s: %2$s\n", "uuid", this.uuid);
            print.printf("%1$20s: %2$s\n", "memoryActual", this.memoryActual);
            print.printf("%1$20s: %2$s\n", "VCPUsNumber", this.VCPUsNumber);
            print.printf("%1$20s: %2$s\n", "VCPUsUtilisation", this.VCPUsUtilisation);
            print.printf("%1$20s: %2$s\n", "VCPUsCPU", this.VCPUsCPU);
            print.printf("%1$20s: %2$s\n", "VCPUsParams", this.VCPUsParams);
            print.printf("%1$20s: %2$s\n", "VCPUsFlags", this.VCPUsFlags);
            print.printf("%1$20s: %2$s\n", "state", this.state);
            print.printf("%1$20s: %2$s\n", "startTime", this.startTime);
            print.printf("%1$20s: %2$s\n", "installTime", this.installTime);
            print.printf("%1$20s: %2$s\n", "lastUpdated", this.lastUpdated);
            return writer.toString();
        }

        @Override
        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("uuid", this.uuid);
            map.put("memory_actual", this.memoryActual);
            map.put("VCPUs_number", this.VCPUsNumber);
            map.put("VCPUs_utilisation", this.VCPUsUtilisation);
            map.put("VCPUs_CPU", this.VCPUsCPU);
            map.put("VCPUs_params", this.VCPUsParams);
            map.put("VCPUs_flags", this.VCPUsFlags);
            map.put("state", this.state);
            map.put("start_time", this.startTime);
            map.put("install_time", this.installTime);
            map.put("last_updated", this.lastUpdated);
            return map;
        }
    }
}

