/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.vmware;

import com.vmware.vim.DynamicProperty;
import com.vmware.vim.InvalidPowerState;
import com.vmware.vim.ManagedObjectReference;
import com.vmware.vim.ObjectContent;
import com.vmware.vim.VirtualDevice;
import com.vmware.vim.VirtualEthernetCard;
import com.vmware.vim.VirtualHardware;
import com.vmware.vim.VirtualMachineCloneSpec;
import com.vmware.vim.VirtualMachinePowerState;
import com.vmware.vim.VirtualMachineRelocateSpec;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareHost;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareServerPool;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareServiceConnection;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.IllegalOperationException;
import org.ow2.jasmine.vmm.api.InsufficientResourcesException;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;

class VMwareVirtualMachine
extends ManagedResource
implements VirtualMachineMXBean {
    static Logger logger = Logger.getLogger(VMwareVirtualMachine.class);
    private VMwareServerPool pool;
    private VMwareServiceConnection connection;
    private VMwareHost host;
    private ManagedObjectReference ref;
    private String nameLabel;
    private String uuid;
    private String macAddress;
    private String ipAddress;
    HashMap<String, BigInteger> metricValues = null;
    private VirtualMachineMXBean.PowerState lastState = VirtualMachineMXBean.PowerState.UNKNOWN;

    public VMwareVirtualMachine(ObjectName objectName, VMwareServerPool pool, ManagedObjectReference mor, VMwareHost host, String nameLabel) {
        super(objectName);
        this.pool = pool;
        this.connection = host.getDefaultConnection();
        this.ref = mor;
        this.host = host;
        this.uuid = null;
        this.nameLabel = nameLabel;
    }

    public void updateMetrics(HashMap<String, BigInteger> m) {
        this.metricValues = m;
    }

    @Override
    public boolean canLiveMigrateToHost(HostMXBean targetHost) {
        return false;
    }

    public ManagedObjectReference getRef() {
        return this.ref;
    }

    @Override
    public void migrate(HostMXBean targetHost, boolean live) throws InstanceNotFoundException, IllegalOperationException, VMMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public float[] getLoadPerVCPU() {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public String getUuid() {
        if (this.uuid == null) {
            this.uuid = VMwareVirtualMachine.getUuid(this.connection, this.ref);
        }
        return this.uuid;
    }

    public static String getUuid(VMwareServiceConnection connection, ManagedObjectReference ref) {
        String uuid = "";
        try {
            DynamicProperty[] props = VMwareVirtualMachine.getDynamicProarray(connection, ref, "config.uuid");
            if (props == null || props.length < 1) {
                logger.error((Object)"Cannot retrieve UUID of VM ");
                uuid = "-1";
            } else {
                uuid = (String)props[0].getVal();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"[VMWareVirtualMachine.getUUID()] : ", (Throwable)ex);
        }
        return uuid;
    }

    @Override
    public Date getStartTime() {
        logger.error((Object)"[VMWareVirtualMachine.getStartTime()] : Not Implemented ! ");
        return null;
    }

    @Override
    public HostMXBean getHostMBean() {
        return this.host;
    }

    @Override
    public String getNameLabel() {
        return this.nameLabel;
    }

    @Override
    public String getMacAddress() {
        if (this.macAddress == null) {
            try {
                VirtualHardware hw = (VirtualHardware)VMwareVirtualMachine.getDynamicProarray(this.connection, this.ref, "config.hardware")[0].getVal();
                for (VirtualDevice vd : hw.getDevice()) {
                    if (!(vd instanceof VirtualEthernetCard)) continue;
                    this.macAddress = ((VirtualEthernetCard)vd).getMacAddress();
                    break;
                }
            }
            catch (Exception ex) {
                logger.error((Object)"[VMWareVirtualMachine.getMacAddress()] : ", (Throwable)ex);
            }
        }
        return this.macAddress;
    }

    @Override
    public String getGuestIpAddress() {
        if (this.ipAddress == null) {
            int tryNumber = 24;
            try {
                while (tryNumber-- > 0) {
                    logger.debug((Object)("Retrieving IP address of VM " + this.nameLabel + " ..."));
                    DynamicProperty[] props = VMwareVirtualMachine.getDynamicProarray(this.connection, this.ref, "guest.ipAddress");
                    if (props != null && props.length > 0) {
                        this.ipAddress = (String)props[0].getVal();
                        logger.debug((Object)("IP address of VM " + this.nameLabel + " is " + this.ipAddress));
                        break;
                    }
                    Thread.sleep(10000L);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"[VMWareVirtualMachine.getGuestIpAddress()] : ", (Throwable)ex);
            }
        }
        return this.ipAddress;
    }

    @Override
    public float getCPULoad() {
        if (this.metricValues != null && this.metricValues.get("cpu.usage") != null) {
            return this.metricValues.get("cpu.usage").floatValue() / 10000.0f;
        }
        return 0.0f;
    }

    public long getUpTimeSeconds() {
        if (this.metricValues != null && this.metricValues.get("sys.uptime") != null) {
            return this.metricValues.get("sys.uptime").longValue();
        }
        return 0L;
    }

    @Override
    public long getMemorySizeMB() {
        long result = 0L;
        try {
            result = ((Integer)VMwareVirtualMachine.getDynamicProarray(this.connection, this.ref, "config.hardware.memoryMB")[0].getVal()).intValue();
        }
        catch (Exception ex) {
            logger.error((Object)"[VMWareVirtualMachine.getMemorySizeMB()] : ", (Throwable)ex);
        }
        return result;
    }

    @Override
    public void setMemorySizeMB(long size) {
        logger.error((Object)"[VMWareVirtualMachine.setMemorySizeMB(...)] : Not Implemented ! ");
    }

    @Override
    public long getMemoryUsedMB() {
        if (this.metricValues != null) {
            return this.metricValues.get("mem.active").longValue() * 1024L;
        }
        return 0L;
    }

    @Override
    public int getNumVCPUs() {
        int result = 0;
        try {
            result = (Integer)VMwareVirtualMachine.getDynamicProarray(this.connection, this.ref, "config.hardware.numCPU")[0].getVal();
        }
        catch (Exception ex) {
            logger.error((Object)"[VMWareVirtualMachine.getNumVCPUs()] : ", (Throwable)ex);
        }
        return result;
    }

    @Override
    public void setNumVCPUs(int numVCPUs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSchedulingCap() {
        int result = 0;
        logger.error((Object)"[VMWareVirtualMachine.getSchedulingCap()] : Not Implemented ! ");
        return result;
    }

    @Override
    public void setSchedulingCap(int schedulingCap) {
        logger.error((Object)"[VMWareVirtualMachine.setSchedulingCap(...)] : Not Implemented ! ");
    }

    @Override
    public int getSchedulingWeight() {
        int result = 0;
        logger.error((Object)"[VMWareVirtualMachine.getSchedulingWeight()] : Not Implemented ! ");
        return result;
    }

    @Override
    public void setSchedulingWeight(int schedulingWeight) {
        logger.error((Object)"[VMWareVirtualMachine.setSchedulingWeight(...)] : Not Implemented ! ");
    }

    @Override
    public VirtualMachineMXBean.PowerState getState() {
        block6: {
            try {
                DynamicProperty[] props = VMwareVirtualMachine.getDynamicProarray(this.connection, this.ref, "runtime.powerState");
                if (props != null) {
                    VirtualMachinePowerState state = (VirtualMachinePowerState)props[0].getVal();
                    if (state.getValue().equals("poweredOff")) {
                        return VirtualMachineMXBean.PowerState.HALTED;
                    }
                    if (state.getValue().equals("poweredOn")) {
                        return VirtualMachineMXBean.PowerState.RUNNING;
                    }
                    if (state.getValue().equals("suspended")) {
                        return VirtualMachineMXBean.PowerState.SUSPENDED;
                    }
                    break block6;
                }
                return VirtualMachineMXBean.PowerState.UNKNOWN;
            }
            catch (Exception ex) {
                logger.error((Object)("[VMWareVirtualMachine.getState()]: VM " + this.getNameLabel()), (Throwable)ex);
            }
        }
        return VirtualMachineMXBean.PowerState.UNKNOWN;
    }

    void onPowerStateChangedVM(VirtualMachineMXBean.PowerState state, long time) {
        if (state != this.lastState) {
            this.emitNotification("vm.state", state.toString(), null);
            logger.debug((Object)("VM " + this.getNameLabel() + " new power state: " + state.toString()));
            this.lastState = state;
        }
    }

    @Override
    public String getUserData(String key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void addUserData(String key, String value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend() {
        try {
            VMwareServiceConnection vMwareServiceConnection = this.connection;
            synchronized (vMwareServiceConnection) {
                ManagedObjectReference taskmor = this.connection.getService().suspendVM_Task(this.ref);
                boolean result = this.getTaskInfo(taskmor);
                if (result) {
                    logger.debug((Object)("Virtual Machine " + this.nameLabel + " suspended on successfully"));
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error suspending VM", (Throwable)ex);
        }
    }

    @Override
    public void resume() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        try {
            VMwareServiceConnection vMwareServiceConnection = this.connection;
            synchronized (vMwareServiceConnection) {
                ManagedObjectReference taskmor = this.connection.getService().powerOffVM_Task(this.ref);
                boolean result = this.getTaskInfo(taskmor);
                if (result) {
                    logger.debug((Object)("Virtual Machine " + this.nameLabel + " powered off successfuly"));
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error shutting down VM", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        try {
            VMwareServiceConnection vMwareServiceConnection = this.connection;
            synchronized (vMwareServiceConnection) {
                ManagedObjectReference taskmor = this.connection.getService().powerOnVM_Task(this.ref, null);
                boolean result = this.getTaskInfo(taskmor);
                if (result) {
                    logger.debug((Object)("Virtual Machine " + this.nameLabel + " powered on successfully"));
                }
            }
        }
        catch (InvalidPowerState e) {
            logger.debug((Object)"Virtual Machine is already powered on");
        }
        catch (Exception ex) {
            logger.error((Object)"Error starting VM", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reboot() {
        VMwareServiceConnection vMwareServiceConnection = this.connection;
        synchronized (vMwareServiceConnection) {
            try {
                this.connection.getService().resetVM_Task(this.ref);
            }
            catch (Exception ex) {
                logger.error((Object)"Error rebooting VM", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (this.getState() == VirtualMachineMXBean.PowerState.RUNNING) {
            this.shutdown();
        }
        try {
            VMwareServiceConnection vMwareServiceConnection = this.connection;
            synchronized (vMwareServiceConnection) {
                ManagedObjectReference taskmor = this.connection.getService().destroy_Task(this.ref);
                boolean result = this.getTaskInfo(taskmor);
                if (result) {
                    logger.debug((Object)("Virtual Machine " + this.nameLabel + " destroyed successfully"));
                }
            }
            this.host.onVMDestroy(this);
            AgentCommon.getMBeanServer().unregisterMBean(this.objectName);
        }
        catch (InvalidPowerState e) {
            logger.debug((Object)"Invalid power state");
        }
        catch (Exception ex) {
            logger.error((Object)"Error destroying VM", (Throwable)ex);
        }
    }

    private static DynamicProperty[] getDynamicProarray(VMwareServiceConnection connection, ManagedObjectReference MOR, String pName) throws Exception {
        ObjectContent[] objContent = connection.getObjectProperties(null, MOR, new String[]{pName});
        if (objContent != null) {
            ObjectContent contentObj = objContent[0];
            DynamicProperty[] objArr = contentObj.getPropSet();
            return objArr;
        }
        return null;
    }

    private boolean getTaskInfo(ManagedObjectReference taskmor) throws Exception {
        boolean valid = false;
        String res = this.connection.waitForTask(taskmor);
        valid = res.equalsIgnoreCase("success");
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeTemplate(String vmImageID, String name, String description) throws InsufficientResourcesException, IllegalOperationException, VMMException {
        VMwareServiceConnection connection = this.host.getConnectionPool().getConnection();
        if (connection == null) {
            logger.debug((Object)"Out of connection");
            throw new VMMException("Too many VM creation requests, try again later");
        }
        VirtualMachineCloneSpec cloneSpec = new VirtualMachineCloneSpec();
        VirtualMachineRelocateSpec relocSpec = new VirtualMachineRelocateSpec();
        try {
            this.shutdown();
            relocSpec.setPool(this.host.getVCResourcePool());
            relocSpec.setDatastore(this.pool.getDatastoreRef());
            cloneSpec.setLocation(relocSpec);
            cloneSpec.setPowerOn(false);
            cloneSpec.setTemplate(true);
            VMwareServiceConnection vMwareServiceConnection = connection;
            synchronized (vMwareServiceConnection) {
                logger.debug((Object)("Making template " + vmImageID + " from VM " + this.getNameLabel()));
                String status = "";
                try {
                    ManagedObjectReference cloneTask = connection.getService().cloneVM_Task(this.ref, this.pool.getVmTemplateFolderRef(), vmImageID, cloneSpec);
                    status = connection.waitForTask(cloneTask);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to create template", (Throwable)e);
                    throw new VMMException(e);
                }
                logger.debug((Object)("CloneVMTask, status=" + status));
                if (status.equalsIgnoreCase("failure")) {
                    String msg = "Failure -: Virtual Machine cannot be cloned to template";
                    logger.error((Object)msg);
                    throw new VMMException(msg);
                }
            }
        }
        finally {
            connection.release();
            this.start();
        }
    }
}

