/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.xen;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Host;
import com.xensource.xenapi.HostCpu;
import com.xensource.xenapi.VM;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.driver.util.RemoteExec;
import org.ow2.jasmine.vmm.agent.driver.xen.XenSSH;
import org.ow2.jasmine.vmm.agent.driver.xen.XenServerPool;
import org.ow2.jasmine.vmm.agent.driver.xen.XenVMImageStore;
import org.ow2.jasmine.vmm.agent.driver.xen.XenVirtualMachine;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.InsufficientResourcesException;
import org.ow2.jasmine.vmm.api.InvalidVMConfigException;
import org.ow2.jasmine.vmm.api.ServerPoolMXBean;
import org.ow2.jasmine.vmm.api.VMConfigSpec;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;

public class XenHost
extends ManagedResource
implements HostMXBean,
NotificationEmitter {
    static Logger logger = Logger.getLogger(XenHost.class);
    static String XEN_CONFIG_HOME = "/etc/xen/auto";
    private static final int MAX_PARALELL_VM_CREATION_PER_HOST = 3;
    private static final int THREADPOOL_SIZE = 4;
    private static ExecutorService executorService = Executors.newFixedThreadPool(4);
    private List<XenVirtualMachine> vmList = new CopyOnWriteArrayList<XenVirtualMachine>();
    private XenServerPool serverPool;
    private Connection connection;
    private Timer perfTimer;
    private Host host;
    private String hostName;
    private int numCPU = -1;
    private float aggregatedCPULoad = -1.0f;
    private long cpuFrequencyMhz = -1L;
    private RemoteExec.SshAuthInfo authInfo;
    private Set<HostMXBean.PerfMetric> currentMonitoredMetrics;
    private long currentMonitoringPeriod;
    HashMap<String, String> hypervisorInfo;
    HashMap<String, String> cpuInfo;
    private long lastCPULoadSampleTime = 0L;

    public static XenHost newHost(XenServerPool resourcePool, ObjectName objectName, String hostName, XenAPIParams xenAPIParams, RemoteExec.SshAuthInfo authInfo) {
        try {
            String xenAPIURL = "http://" + hostName + ":" + xenAPIParams.getXenAPIPort();
            Connection connection = new Connection(xenAPIURL, xenAPIParams.getXenAPIUser(), xenAPIParams.getXenAPIPassword());
            Connection connection2 = new Connection(xenAPIURL, xenAPIParams.getXenAPIUser(), xenAPIParams.getXenAPIPassword());
            XenHost xenHost = new XenHost(resourcePool, connection, connection2, objectName, hostName, authInfo);
            return xenHost;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private XenHost(XenServerPool serverPool, Connection connection, Connection connection2, ObjectName objectName, String hostName, RemoteExec.SshAuthInfo authInfo) {
        super(objectName);
        this.serverPool = serverPool;
        this.connection = connection;
        this.hostName = hostName;
        this.authInfo = authInfo;
        try {
            Set hosts = Host.getAll((Connection)connection);
            this.host = (Host)hosts.iterator().next();
            this.populate();
        }
        catch (Exception ex) {
            logger.debug((Object)("Host " + hostName), (Throwable)ex);
        }
    }

    RemoteExec.SshAuthInfo getSshAuthInfo() {
        return this.authInfo;
    }

    Connection getXenAPIConnection() {
        return this.connection;
    }

    private void addVM(XenVirtualMachine vm) {
        this.vmList.add(vm);
    }

    private void removeVM(XenVirtualMachine vm) {
        this.vmList.remove(vm);
    }

    @Override
    public ServerPoolMXBean getServerPool() {
        return this.serverPool;
    }

    public void postMigrateVM(XenVirtualMachine vm, XenHost newHost) {
        this.removeVM(vm);
        newHost.addVM(vm);
    }

    public void onVMDestroy(XenVirtualMachine vm) {
        this.removeVM(vm);
        this.emitNotification("vm.del", "Destroyed", vm.getObjectName());
    }

    @Override
    public void configurePerfMonitor(Set<HostMXBean.PerfMetric> metricsOfInterest, long periodMillis) {
        this.stopPerfMonitor();
        if (periodMillis < 1000L) {
            periodMillis = 1000L;
        }
        if (metricsOfInterest.contains((Object)HostMXBean.PerfMetric.VM_CPU_LOAD)) {
            this.currentMonitoringPeriod = periodMillis;
            this.currentMonitoredMetrics = metricsOfInterest;
            this.startPerfMonitor();
        }
    }

    String getIPAddress(String macAddress) {
        macAddress = macAddress.toUpperCase();
        logger.debug((Object)("Determining IP address from MAC address " + macAddress + " ..."));
        RemoteExec.Result result = null;
        String command = "getIPfromMAC.sh " + macAddress;
        logger.debug((Object)("Launching command: " + command));
        try {
            result = RemoteExec.commandAsRoot(this.hostName, this.authInfo, command);
        }
        catch (RemoteExec.SshException ex) {
            logger.debug((Object)"SSH failure", (Throwable)ex);
            return null;
        }
        if (result.exitCode != 0) {
            logger.error((Object)("Cannot get IP from MAC " + result.output));
            return null;
        }
        String ipAddress = result.output;
        if (ipAddress != null && ipAddress.length() > 0 && ipAddress.endsWith("\n")) {
            ipAddress = ipAddress.substring(0, ipAddress.length() - 1);
        }
        logger.debug((Object)("Mac-to-IP " + macAddress + " -> " + ipAddress));
        return ipAddress;
    }

    private synchronized void startPerfMonitor() {
        if (this.perfTimer == null) {
            this.perfTimer = new Timer();
            this.perfTimer.schedule((TimerTask)new PerfTimerTask(), 0L, this.currentMonitoringPeriod);
            logger.info((Object)("Host " + this.hostName + ": started periodic performance reporting task"));
        }
    }

    private synchronized void stopPerfMonitor() {
        if (this.perfTimer != null) {
            this.perfTimer.cancel();
            logger.info((Object)("Host " + this.hostName + ": stopped periodic performance reporting task"));
        }
        this.perfTimer = null;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public Map<String, String> getHypervisorInfo() {
        if (this.hypervisorInfo == null) {
            this.hypervisorInfo = new HashMap();
            this.hypervisorInfo.put("vendor", "");
            this.hypervisorInfo.put("name", "Xen");
            this.hypervisorInfo.put("version", "3.2");
        }
        return this.hypervisorInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getCPUInfo() {
        if (this.cpuInfo == null) {
            this.cpuInfo = new HashMap();
            Connection connection = this.connection;
            synchronized (connection) {
                try {
                    HostCpu[] cpus = this.host.getHostCPUs(this.connection).toArray(new HostCpu[0]);
                    this.numCPU = cpus.length;
                    HostCpu.Record rec = cpus[0].getRecord(this.connection);
                    this.cpuInfo.put("model", rec.modelname);
                    this.cpuFrequencyMhz = rec.speed;
                    this.cpuInfo.put("speed", Long.toString(rec.speed));
                    this.cpuInfo.put("vendor", rec.vendor);
                }
                catch (Exception ex) {
                    logger.debug((Object)("Host " + this.hostName), (Throwable)ex);
                }
            }
        }
        return this.cpuInfo;
    }

    public long getCPUFrequencyMhz() {
        if (this.cpuFrequencyMhz == -1L) {
            this.getCPUInfo();
        }
        return this.cpuFrequencyMhz;
    }

    @Override
    public int getNumCPU() {
        if (this.numCPU == -1) {
            this.getCPUInfo();
        }
        return this.numCPU;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public VirtualMachineImageStoreMXBean getVMImageStore() {
        return this.serverPool.getVMImageStore();
    }

    @Override
    public long getFreeMemoryMB() {
        RemoteExec.Result result = null;
        String command = "xm info | grep ^free_memory | awk '{print $3}'";
        try {
            result = RemoteExec.commandAsRoot(this.hostName, this.authInfo, command);
        }
        catch (RemoteExec.SshException ex) {
            logger.error((Object)"SSH exception: ", (Throwable)ex);
        }
        if (result.exitCode != 0) {
            logger.error((Object)("getFreeMemoryMB: SSH " + command + " failed"));
            return 0L;
        }
        if (result.output.endsWith("\n")) {
            result.output = result.output.substring(0, result.output.length() - 1);
        }
        long freeMem = Long.parseLong(result.output);
        for (XenVirtualMachine vm : this.vmList) {
            XenVirtualMachine xvm = vm;
            if (xvm.getDomID() != 0L) continue;
            freeMem += xvm.getMemorySizeMB() - 546L;
        }
        return freeMem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populate() {
        try {
            Connection connection = this.connection;
            synchronized (connection) {
                Set vms = VM.getAll((Connection)this.connection);
                for (VM vm : vms) {
                    ObjectName name = vm.getDomid(this.connection) == 0L ? MBeanObjectNamer.makeVirtualMachineName(this.serverPool.getPath() + "/" + vm.getNameLabel(this.connection), this.host.getUuid(this.connection)) : MBeanObjectNamer.makeVirtualMachineName(this.serverPool.getPath() + "/" + vm.getNameLabel(this.connection), vm.getUuid(this.connection));
                    XenVirtualMachine xenVM = new XenVirtualMachine(name, this, this.connection, vm, null);
                    this.addVM(xenVM);
                    AgentCommon.getMBeanServer().registerMBean(xenVM, name);
                    logger.info((Object)("Added XenVirtualMachineMBean " + name));
                }
            }
        }
        catch (Exception ex) {
            logger.debug((Object)("Host " + this.hostName), (Throwable)ex);
        }
    }

    @Override
    public List<VirtualMachineMXBean> getResidentVMs() {
        ArrayList<VirtualMachineMXBean> result = new ArrayList<VirtualMachineMXBean>(this.vmList);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualMachineMXBean doCreateVM(VMConfigSpec vmSpec, boolean sync) throws InvalidVMConfigException, VMMException {
        RemoteExec.Result result;
        logger.info((Object)("Creating new VM [name=" + vmSpec.getName() + ",memorySizeMB=" + vmSpec.getMemorySizeMB() + ",diskSize=" + vmSpec.getDiskSizeMB() + ",numVCPU=" + vmSpec.getNumVCPU() + "]"));
        XenVMImageStore.XenVirtualMachineImage template = (XenVMImageStore.XenVirtualMachineImage)this.serverPool.getVMImageStore().lookUpByUUID(vmSpec.getVmImageUUID());
        if (template == null) {
            throw new InvalidVMConfigException("Invalid VM Image UUID");
        }
        String vmName = vmSpec.getName() + "-" + System.currentTimeMillis();
        try {
            result = XenSSH.createVM(this, vmName, vmSpec, template.getFileName());
        }
        catch (RemoteExec.SshException ex) {
            logger.error((Object)"SSH failed: ", (Throwable)ex);
            throw new VMMException("VM creation failed: SSH connection failure", ex);
        }
        if (result.exitCode != 0) {
            logger.error((Object)("Command createVM failed: " + result.error));
            throw new VMMException("VM creation failed: " + result.error);
        }
        VM newVM = null;
        String vmUUID = "";
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                newVM = (VM)VM.getByNameLabel((Connection)this.connection, (String)vmName).iterator().next();
                vmUUID = newVM.getUuid(this.connection);
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to get VM uuid: ", (Throwable)ex);
            }
        }
        ObjectName name = null;
        XenVirtualMachine xenVM = null;
        try {
            name = MBeanObjectNamer.makeVirtualMachineName(this.serverPool.getPath() + "/" + vmName, vmUUID);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("imageID", vmSpec.getVmImageUUID());
            xenVM = new XenVirtualMachine(name, this, this.connection, newVM, map);
            this.addVM(xenVM);
            AgentCommon.getMBeanServer().registerMBean(xenVM, name);
        }
        catch (Exception ex) {
            logger.debug((Object)("Host " + this.hostName), (Throwable)ex);
            throw new VMMException(ex);
        }
        this.emitNotification("vm.add", "Created", name);
        return xenVM;
    }

    @Override
    public VirtualMachineMXBean createVM(String name, long memorySizeMB, int numVCPU, int diskSizeMB, String vmImageUUID, final boolean sync) throws InsufficientResourcesException, InvalidVMConfigException, VMMException {
        final VMConfigSpec vmSpec2 = new VMConfigSpec(name, memorySizeMB, numVCPU, diskSizeMB, vmImageUUID);
        if (!sync) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        XenHost.this.doCreateVM(vmSpec2, sync);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            return null;
        }
        return this.doCreateVM(vmSpec2, sync);
    }

    @Override
    public VirtualMachineMXBean createVM(VMConfigSpec vmSpec, final boolean sync) throws InsufficientResourcesException, InvalidVMConfigException, VMMException {
        final VMConfigSpec vmSpec2 = new VMConfigSpec(vmSpec);
        if (!sync) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        XenHost.this.doCreateVM(vmSpec2, sync);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            return null;
        }
        return this.doCreateVM(vmSpec2, sync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTotalMemoryMB() {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                return this.host.getMetrics(this.connection).getMemoryTotal(this.connection) / 0x100000L;
            }
            catch (Exception ex) {
                logger.debug((Object)("Host " + this.hostName), (Throwable)ex);
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[] getLoadPerCPU() {
        float[] result = new float[]{};
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                Set cpus = this.host.getHostCPUs(this.connection);
                result = new float[cpus.size()];
                int i = 0;
                for (HostCpu cpu : cpus) {
                    result[i++] = (float)(cpu.getUtilisation(this.connection) * 100.0);
                }
            }
            catch (Exception ex) {
                logger.debug((Object)("Host " + this.hostName), (Throwable)ex);
            }
        }
        return result;
    }

    @Override
    public float getCPULoad() {
        return this.aggregatedCPULoad;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"vm.state", "vm.add", "vm.del", "vm.error", "log"}, Notification.class.getName(), "Host event")};
    }

    @Override
    public Map<String, Float> getVMCPULoads() {
        HashMap<String, Float> cpuLoads = new HashMap<String, Float>();
        RemoteExec.Result result = null;
        String command = "xentop -b -i 2 -d 1";
        try {
            result = RemoteExec.commandAsRoot(this.hostName, this.authInfo, command);
        }
        catch (RemoteExec.SshException ex) {
            return cpuLoads;
        }
        try {
            String s;
            BufferedReader reader = new BufferedReader(new StringReader(result.output));
            int matched = 0;
            while ((s = reader.readLine()) != null && (s.indexOf("NAME") == -1 || ++matched != 2)) {
            }
            float acc = 0.0f;
            while ((s = reader.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(s);
                String vmLabel = st.nextToken();
                st.nextToken();
                st.nextToken();
                String cpuLoadString = st.nextToken();
                st.nextToken();
                st.nextToken();
                String t = st.nextToken();
                if (t.equals("no")) {
                    st.nextToken();
                }
                st.nextToken();
                String vcpusString = st.nextToken();
                float cpuLoad = Float.parseFloat(cpuLoadString) / 100.0f;
                cpuLoads.put(vmLabel, Float.valueOf(cpuLoad /= (float)this.getNumCPU()));
            }
        }
        catch (Exception ex) {
            logger.debug((Object)("Host " + this.hostName), (Throwable)ex);
        }
        return cpuLoads;
    }

    private class PerfTimerTask
    extends TimerTask {
        private PerfTimerTask() {
        }

        @Override
        public void run() {
            HashMap<String, Float> cpuLoads = new HashMap<String, Float>();
            RemoteExec.Result result = null;
            String command = "xentop -b -i 2 -d 1";
            try {
                result = RemoteExec.commandAsRoot(XenHost.this.hostName, XenHost.this.authInfo, command);
            }
            catch (RemoteExec.SshException ex) {
                logger.error((Object)"Failed to invoke xentop", (Throwable)ex);
                return;
            }
            long now = System.currentTimeMillis();
            try {
                boolean sampleCPU;
                String s;
                BufferedReader reader = new BufferedReader(new StringReader(result.output));
                int matched = 0;
                while ((s = reader.readLine()) != null && (s.indexOf("NAME") == -1 || ++matched != 2)) {
                }
                float acc = 0.0f;
                boolean bl = sampleCPU = now - XenHost.this.lastCPULoadSampleTime > 20000L;
                while ((s = reader.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(s);
                    String vmLabel = st.nextToken();
                    st.nextToken();
                    st.nextToken();
                    String cpuLoadString = st.nextToken();
                    st.nextToken();
                    st.nextToken();
                    String t = st.nextToken();
                    if (t.equals("no")) {
                        st.nextToken();
                    }
                    st.nextToken();
                    String vcpusString = st.nextToken();
                    float cpuLoad = Float.parseFloat(cpuLoadString) / 100.0f;
                    cpuLoads.put(vmLabel, Float.valueOf(cpuLoad /= (float)XenHost.this.getNumCPU()));
                    if (sampleCPU) {
                        for (XenVirtualMachine vm : XenHost.this.vmList) {
                            XenVirtualMachine xvm = vm;
                            if (!xvm.getNameLabel().equals(vmLabel)) continue;
                            xvm.updateCPUConsumption(now, cpuLoad);
                        }
                    }
                    acc += cpuLoad;
                }
                XenHost.this.aggregatedCPULoad = acc;
                if (sampleCPU) {
                    XenHost.this.lastCPULoadSampleTime = now;
                }
            }
            catch (Exception ex) {
                logger.debug((Object)("Host " + XenHost.this.hostName), (Throwable)ex);
            }
            XenHost.this.emitNotification("host.perfreport", "CPU load", cpuLoads);
        }
    }

    public static class XenAPIParams {
        private final String xenAPIPort;
        private final String xenAPIUser;
        private final String xenAPIPassword;

        public XenAPIParams(String xenAPIPort, String xenAPIUser, String xenAPIPassword) {
            this.xenAPIPort = xenAPIPort;
            this.xenAPIUser = xenAPIUser;
            this.xenAPIPassword = xenAPIPassword;
        }

        public String getXenAPIPort() {
            return this.xenAPIPort;
        }

        public String getXenAPIUser() {
            return this.xenAPIUser;
        }

        public String getXenAPIPassword() {
            return this.xenAPIPassword;
        }
    }
}

