/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.vmware;

import java.io.File;
import java.util.Properties;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ServerPool;
import org.ow2.jasmine.vmm.agent.driver.Driver;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareServerPool;

public class VMwareDriver
implements Driver {
    protected static Logger logger = Logger.getLogger(VMwareDriver.class);
    static final String VMWARE_KEYSTORE_FILENAME = "vmware.keystore";

    @Override
    public ServerPool newServerPool(String name, ObjectName objectname, Properties props) {
        try {
            VMwareServerPool pool = new VMwareServerPool(name, objectname, props);
            return pool;
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to create server pool", (Throwable)ex);
            return null;
        }
    }

    static {
        String keyStoreFileName = System.getProperty("vmm.home") + File.separator + "etc" + File.separator + VMWARE_KEYSTORE_FILENAME;
        logger.debug((Object)("Setting system prop javax.net.ssl.trustStore to " + keyStoreFileName));
        System.setProperty("javax.net.ssl.trustStore", keyStoreFileName);
    }
}

