/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.vmware;

import com.vmware.vim.ArrayOfManagedObjectReference;
import com.vmware.vim.DynamicProperty;
import com.vmware.vim.ManagedObjectReference;
import com.vmware.vim.ObjectContent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.domain.ServerPool;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareEventCollector;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareHost;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareServiceConnection;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineImageMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;

class VMwareServerPool
extends ServerPool {
    protected static Logger logger = Logger.getLogger(VMwareServerPool.class);
    private static int KEEP_ALIVE_PERIOD_MS = 120000;
    private static final int THREADPOOL_SIZE = 20;
    private static final int CONNECTION_DEFAULT_POOL_SIZE = 4;
    private static ExecutorService executorService = Executors.newFixedThreadPool(20);
    private ConnectionPool connectionPool;
    private VMwareServiceConnection defaultConnection;
    private HashMap<String, VMwareHost> hostRefs = new HashMap();
    private String datacenter;
    private String vmFolderName;
    private ManagedObjectReference datacenterRef;
    private ManagedObjectReference vmFolderRef;
    private ManagedObjectReference datastoreRef;
    private ManagedObjectReference vmTemplateFolderRef;
    private ManagedObjectReference hostFolderRef;
    private VMwareVMTemplateDataStore imageStore;

    public VMwareServerPool(String name, ObjectName objectName, Properties props) throws VMMException {
        super(name, objectName);
        String hostName = props.getProperty("virtualCenterHostName");
        this.datacenter = props.getProperty("datacenter");
        this.vmFolderName = props.getProperty("vmFolderPath");
        String vmTemplateFolderName = props.getProperty("vmTemplateFolderPath");
        String userName = props.getProperty("user");
        String password = props.getProperty("password");
        String datastoreName = props.getProperty("datastore");
        try {
            this.connectionPool = new ConnectionPool(4, hostName, userName, password);
            this.defaultConnection = this.connectionPool.getConnection();
            logger.debug((Object)("Finding datacenter " + this.datacenter));
            this.datacenterRef = this.defaultConnection.getService().findByInventoryPath(this.defaultConnection.getServiceContent().getSearchIndex(), this.datacenter);
            if (this.datacenterRef == null) {
                String msg = "VMware Driver initialization error: datacenter " + this.datacenter + " not found ";
                logger.error((Object)msg);
                throw new VMMException(msg);
            }
            this.vmFolderRef = this.vmFolderName != null ? this.defaultConnection.getService().findByInventoryPath(this.defaultConnection.getServiceContent().getSearchIndex(), this.vmFolderName) : (ManagedObjectReference)this.getDynamicProarray(this.datacenterRef, "vmFolder")[0].getVal();
            if (this.vmFolderRef == null) {
                String msg = "VMware Driver initialization error: virtual machine folder " + this.vmFolderName + " not found";
                logger.error((Object)msg);
                throw new VMMException(msg);
            }
            this.vmTemplateFolderRef = vmTemplateFolderName != null ? this.defaultConnection.getService().findByInventoryPath(this.defaultConnection.getServiceContent().getSearchIndex(), vmTemplateFolderName) : this.vmFolderRef;
            if (this.vmTemplateFolderRef == null) {
                String msg = "VMware Driver initialization error: virtual machine template folder " + vmTemplateFolderName + " not found";
                logger.error((Object)msg);
                throw new VMMException(msg);
            }
            this.hostFolderRef = (ManagedObjectReference)this.getDynamicProarray(this.datacenterRef, "hostFolder")[0].getVal();
            if (this.hostFolderRef == null) {
                String msg = "VMware Driver initialization error: host folder not found for datacenter " + this.datacenter;
                logger.error((Object)msg);
                throw new VMMException(msg);
            }
            ArrayOfManagedObjectReference dataStoreRefs = (ArrayOfManagedObjectReference)this.getDynamicProarray(this.datacenterRef, "datastore")[0].getVal();
            if (dataStoreRefs != null) {
                for (int i = 0; i < dataStoreRefs.getManagedObjectReference().length; ++i) {
                    String dsName = (String)this.getDynamicProarray(dataStoreRefs.getManagedObjectReference(i), "info.name")[0].getVal();
                    if (!dsName.equals(datastoreName)) continue;
                    this.datastoreRef = dataStoreRefs.getManagedObjectReference(i);
                    break;
                }
            }
            if (this.datastoreRef == null) {
                String msg = "VMware Driver initialization error: Datastore " + datastoreName + " cannot be found";
                logger.error((Object)msg);
                throw new VMMException(msg);
            }
            String vmImageStoreName = this.datacenter + "-VMIStore";
            this.imageStore = new VMwareVMTemplateDataStore(MBeanObjectNamer.makeVMImageStoreName(vmImageStoreName), vmImageStoreName, this.datastoreRef);
            AgentCommon.getMBeanServer().registerMBean(this.imageStore, this.imageStore.getObjectName());
        }
        catch (Exception ex) {
            String msg = "VMware Driver initialization error: " + ex.getMessage();
            logger.error((Object)msg, (Throwable)ex);
            throw new VMMException(msg);
        }
        new VMwareEventCollector(this, new VMwareServiceConnection(hostName, userName, password), this.datacenter).start();
    }

    public ExecutorService getExecutorService() {
        return executorService;
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    @Override
    public VirtualMachineImageStoreMXBean getVMImageStore() {
        return this.imageStore;
    }

    public String getMountPoint() {
        return this.datacenter;
    }

    VMwareHost getHostByName(String name) {
        return this.hostRefs.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HostMXBean newHost(String hostName, Map<String, String> props) {
        VMwareHost host = this.hostRefs.get(hostName);
        if (host != null) {
            return host;
        }
        ManagedObjectReference mor = null;
        try {
            VMwareServiceConnection vMwareServiceConnection = this.defaultConnection;
            synchronized (vMwareServiceConnection) {
                mor = this.defaultConnection.getDecendentMoRef(this.getHostFolderRef(), "HostSystem", hostName);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Unable to find HostSystem managed object " + hostName + " in VMware VC inventory"), (Throwable)ex);
            return null;
        }
        if (mor == null) {
            logger.error((Object)("Host " + hostName + " not found"));
            return null;
        }
        ObjectName mbeanObjectName = MBeanObjectNamer.makeHostName(this.getPath() + "/" + hostName, hostName);
        host = new VMwareHost(this, mor, mbeanObjectName, hostName);
        host.getResidentVMs();
        try {
            AgentCommon.getMBeanServer().registerMBean(host, mbeanObjectName);
        }
        catch (Exception ex) {
            logger.error((Object)("Unable to register MBean " + mbeanObjectName), (Throwable)ex);
            return null;
        }
        this.hostRefs.put(hostName, host);
        this.addHost(host);
        try {
            this.connectionPool.ensureCapacity(1 + this.hostRefs.size() * 3);
        }
        catch (Exception ex) {
            logger.error((Object)"Cannot increase connection pool", (Throwable)ex);
        }
        return host;
    }

    public ManagedObjectReference getDatacenterRef() {
        return this.datacenterRef;
    }

    public ManagedObjectReference getVmFolderRef() {
        return this.vmFolderRef;
    }

    public ManagedObjectReference getHostFolderRef() {
        return this.hostFolderRef;
    }

    public ManagedObjectReference getVmTemplateFolderRef() {
        return this.vmTemplateFolderRef;
    }

    public ManagedObjectReference getDatastoreRef() {
        return this.datastoreRef;
    }

    private DynamicProperty[] getDynamicProarray(ManagedObjectReference MOR, String pName) throws Exception {
        ObjectContent[] objContent = this.defaultConnection.getObjectProperties(null, MOR, new String[]{pName});
        ObjectContent contentObj = objContent[0];
        DynamicProperty[] objArr = contentObj.getPropSet();
        return objArr;
    }

    private static class VMwareVirtualMachineImage
    extends ManagedResource
    implements VirtualMachineImageMXBean {
        private String name;
        private String uuid;

        public VMwareVirtualMachineImage(ObjectName objectName, String name, String uuid) {
            super(objectName);
            this.name = name;
            this.uuid = uuid;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getUUID() {
            return this.name;
        }

        @Override
        public String getMetaData() {
            return "";
        }

        public String toString() {
            return "VMwareTemplate(name=" + this.getName() + ",uuid=" + this.getUUID() + ")";
        }
    }

    class VMwareVMTemplateDataStore
    extends ManagedResource
    implements VirtualMachineImageStoreMXBean {
        private String name;
        private ArrayList<VirtualMachineImageMXBean> imageList;
        private ManagedObjectReference datastoreRef;
        private boolean needSync;

        public VMwareVMTemplateDataStore(ObjectName objectName, String name, ManagedObjectReference datastoreRef) {
            super(objectName);
            this.imageList = new ArrayList();
            this.needSync = true;
            this.name = name;
            this.datastoreRef = datastoreRef;
        }

        @Override
        public long getCapacityMB() {
            try {
                long capacityInBytes = (Long)VMwareServerPool.this.getDynamicProarray(this.datastoreRef, "summary.capacity")[0].getVal();
                return capacityInBytes / 1024L;
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to get datastore capacity", (Throwable)ex);
                return -1L;
            }
        }

        @Override
        public long getFreeSpaceMB() {
            try {
                long freeSpaceInBytes = (Long)VMwareServerPool.this.getDynamicProarray(this.datastoreRef, "summary.freeSpace")[0].getVal();
                return freeSpaceInBytes / 1024L;
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to get datastore free space", (Throwable)ex);
                return -1L;
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        public synchronized void sync() {
            this.needSync = true;
        }

        @Override
        public synchronized List<VirtualMachineImageMXBean> listVMImageTemplates() {
            if (this.needSync) {
                try {
                    ArrayList vms = VMwareServerPool.this.defaultConnection.getDecendentMoRefs(VMwareServerPool.this.getVmTemplateFolderRef(), "VirtualMachine");
                    for (ManagedObjectReference vmMor : vms) {
                        VirtualMachineImageMXBean image2;
                        DynamicProperty[] properties;
                        boolean isTemplate = (Boolean)VMwareServerPool.this.getDynamicProarray(vmMor, "summary.config.template")[0].getVal();
                        if (!isTemplate || (properties = VMwareServerPool.this.getDynamicProarray(vmMor, "config.name")) == null || properties.length < 1) continue;
                        String vmName = (String)properties[0].getVal();
                        String uuid = (String)VMwareServerPool.this.getDynamicProarray(vmMor, "config.uuid")[0].getVal();
                        boolean found = false;
                        for (VirtualMachineImageMXBean image2 : this.imageList) {
                            if (!image2.getUUID().equals(vmName)) continue;
                            found = true;
                        }
                        if (found) continue;
                        ObjectName on = MBeanObjectNamer.makeVMImageName(uuid);
                        image2 = new VMwareVirtualMachineImage(on, vmName, uuid);
                        logger.debug((Object)("New VMware template: " + image2));
                        AgentCommon.getMBeanServer().registerMBean(image2, on);
                        this.imageList.add(image2);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to list VM templates", (Throwable)ex);
                }
                this.needSync = false;
            }
            return this.imageList;
        }

        @Override
        public synchronized VirtualMachineImageMXBean lookUpByUUID(String uuid) {
            for (VirtualMachineImageMXBean image : this.listVMImageTemplates()) {
                if (!image.getUUID().equals(uuid)) continue;
                return image;
            }
            return null;
        }

        @Override
        public synchronized void removeVMImageTemplate(VirtualMachineImageMXBean vmImage) throws VMMException {
            String vmImageID = vmImage.getUUID();
            try {
                ManagedObjectReference vmMOR = VMwareServerPool.this.defaultConnection.getDecendentMoRef(null, "VirtualMachine", vmImageID);
                VMwareServerPool.this.defaultConnection.getService().destroy_Task(vmMOR);
            }
            catch (Exception ex) {
                logger.error((Object)("Failed to retrieve VM reference " + vmImageID), (Throwable)ex);
            }
        }
    }

    class ConnectionPool {
        private List<VMwareServiceConnection> connections = new ArrayList<VMwareServiceConnection>();
        private String hostName;
        private String userName;
        private String password;

        ConnectionPool(int initialCapacity, String hostName, String userName, String password) throws Exception {
            this.userName = userName;
            this.hostName = hostName;
            this.password = password;
            this.ensureCapacity(initialCapacity);
            executorService.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep(KEEP_ALIVE_PERIOD_MS);
                                ConnectionPool connectionPool = ConnectionPool.this;
                                synchronized (connectionPool) {
                                    Iterator i$ = ConnectionPool.this.connections.iterator();
                                    while (i$.hasNext()) {
                                        VMwareServiceConnection connection;
                                        VMwareServiceConnection vMwareServiceConnection = connection = (VMwareServiceConnection)i$.next();
                                        synchronized (vMwareServiceConnection) {
                                            Calendar time = connection.getService().currentTime(connection.getServiceInstanceRef());
                                        }
                                    }
                                }
                            }
                        }
                        catch (Exception ex) {
                            logger.error((Object)"error", (Throwable)ex);
                            continue;
                        }
                        break;
                    }
                }
            });
        }

        synchronized void ensureCapacity(int minCapacity) throws Exception {
            if (this.connections.size() < minCapacity) {
                for (int i = minCapacity - this.connections.size(); i > 0; --i) {
                    VMwareServiceConnection connection = new VMwareServiceConnection(this.hostName, this.userName, this.password);
                    logger.debug((Object)("Connecting to VMware VirtualCenter " + this.hostName + " ..."));
                    connection.connect();
                    logger.debug((Object)"Done");
                    this.connections.add(connection);
                }
            }
        }

        synchronized VMwareServiceConnection getConnection() {
            for (VMwareServiceConnection connection : this.connections) {
                if (!connection.lease()) continue;
                return connection;
            }
            return null;
        }
    }
}

