/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.jmx;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import org.ow2.jasmine.vmm.agent.jmx.JMXNotificationAppenderMBean;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;

public class JMXNotificationAppender
extends AppenderSkeleton
implements NotificationBroadcaster,
JMXNotificationAppenderMBean {
    private String objectName;
    private ObjectName oName;
    private String notificationType;
    private boolean isStarted;
    private long notificationSequence;
    private List<ListenerInfo> notificationListeners = new CopyOnWriteArrayList<ListenerInfo>();

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getNotificationType() {
        return this.notificationType;
    }

    public void setNotificationType(String notificationType) {
        this.notificationType = notificationType;
    }

    private boolean start() {
        if (this.isStarted) {
            return true;
        }
        try {
            MBeanServer mbeanServer = AgentCommon.getMBeanServer();
            if (mbeanServer != null) {
                this.oName = ObjectName.getInstance(this.objectName);
                mbeanServer.registerMBean(this, this.oName);
                this.isStarted = true;
            }
        }
        catch (Exception ex) {
            this.errorHandler.error("Cannot register JMXNotificationAppenderMBean: " + ex);
        }
        return this.isStarted;
    }

    protected synchronized void append(LoggingEvent event) {
        if (this.start()) {
            StringBuffer message = new StringBuffer(this.layout.format(event));
            if (this.layout.ignoresThrowable() && event.getThrowableStrRep() != null) {
                for (String exceptionStringRep : event.getThrowableStrRep()) {
                    message.append(exceptionStringRep);
                }
            }
            Notification notification = new Notification(this.notificationType, (Object)this.oName, this.notificationSequence++, message.toString());
            this.fireNotification(notification);
        }
    }

    public void close() {
        if (this.isStarted) {
            try {
                MBeanServer mbeanServer = AgentCommon.getMBeanServer();
                if (mbeanServer != null) {
                    mbeanServer.unregisterMBean(this.oName);
                    this.isStarted = true;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.isStarted = false;
    }

    public boolean requiresLayout() {
        return true;
    }

    private void fireNotification(Notification notif) {
        try {
            for (ListenerInfo li : this.notificationListeners) {
                li.listener.handleNotification(notif, li.handback);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("Listener can't be null");
        }
        this.notificationListeners.add(new ListenerInfo(listener, filter, handback));
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{this.notificationType}, Notification.class.getName(), "Log")};
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        WildcardListenerInfo wildcard = new WildcardListenerInfo(listener);
        boolean removed = this.notificationListeners.removeAll(Collections.singleton(wildcard));
        if (!removed) {
            throw new ListenerNotFoundException("Listener not registered");
        }
    }

    private static class WildcardListenerInfo
    extends ListenerInfo {
        WildcardListenerInfo(NotificationListener listener) {
            super(listener, null, null);
        }

        @Override
        public boolean equals(Object o) {
            assert (!(o instanceof WildcardListenerInfo));
            return o.equals(this);
        }
    }

    private static class ListenerInfo {
        NotificationListener listener;
        NotificationFilter filter;
        Object handback;

        ListenerInfo(NotificationListener listener, NotificationFilter filter, Object handback) {
            this.listener = listener;
            this.filter = filter;
            this.handback = handback;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ListenerInfo)) {
                return false;
            }
            ListenerInfo li = (ListenerInfo)o;
            if (li instanceof WildcardListenerInfo) {
                return li.listener == this.listener;
            }
            return li.listener == this.listener && li.filter == this.filter && li.handback == this.handback;
        }
    }
}

