/*
 * Decompiled with CFR 0.152.
 */
package com.xensource.xenapi;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.HostCpu;
import com.xensource.xenapi.HostCrashdump;
import com.xensource.xenapi.HostMetrics;
import com.xensource.xenapi.HostPatch;
import com.xensource.xenapi.Marshalling;
import com.xensource.xenapi.PBD;
import com.xensource.xenapi.PIF;
import com.xensource.xenapi.SR;
import com.xensource.xenapi.Task;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.VM;
import com.xensource.xenapi.XenAPIObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Host
extends XenAPIObject {
    protected final String ref;
    private static final Map<String, SoftReference<Host>> cache = new HashMap<String, SoftReference<Host>>();

    private Host(String ref) {
        this.ref = ref;
    }

    @Override
    public String toWireString() {
        return this.ref;
    }

    protected static synchronized Host getInstFromRef(String ref) {
        Host instance;
        if (cache.containsKey(ref) && (instance = cache.get(ref).get()) != null) {
            return instance;
        }
        instance = new Host(ref);
        cache.put(ref, new SoftReference<Host>(instance));
        return instance;
    }

    public Record getRecord(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_record";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toHostRecord(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static Host getByUuid(Connection c, String uuid) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_by_uuid";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(uuid)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toHost(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static Set<Host> getByNameLabel(Connection c, String label) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_by_name_label";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(label)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfHost(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getUuid(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_uuid";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getNameLabel(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_name_label";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getNameDescription(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_name_description";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Set<Types.HostAllowedOperations> getAllowedOperations(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_allowed_operations";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfHostAllowedOperations(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, Types.HostAllowedOperations> getCurrentOperations(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_current_operations";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringHostAllowedOperations(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Long getAPIVersionMajor(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_API_version_major";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toLong(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Long getAPIVersionMinor(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_API_version_minor";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toLong(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getAPIVersionVendor(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_API_version_vendor";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, String> getAPIVersionVendorImplementation(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_API_version_vendor_implementation";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Boolean getEnabled(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_enabled";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toBoolean(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, String> getSoftwareVersion(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_software_version";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, String> getOtherConfig(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_other_config";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Set<String> getCapabilities(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_capabilities";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, String> getCpuConfiguration(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_cpu_configuration";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getSchedPolicy(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_sched_policy";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Set<String> getSupportedBootloaders(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_supported_bootloaders";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Set<VM> getResidentVMs(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_resident_VMs";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfVM(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, String> getLogging(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_logging";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Set<PIF> getPIFs(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_PIFs";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfPIF(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public SR getSuspendImageSr(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_suspend_image_sr";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSR(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public SR getCrashDumpSr(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_crash_dump_sr";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSR(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Set<HostCrashdump> getCrashdumps(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_crashdumps";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfHostCrashdump(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Set<HostPatch> getPatches(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_patches";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfHostPatch(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Set<PBD> getPBDs(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_PBDs";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfPBD(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Set<HostCpu> getHostCPUs(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_host_CPUs";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfHostCpu(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getHostname(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_hostname";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getAddress(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_address";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public HostMetrics getMetrics(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_metrics";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toHostMetrics(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, String> getLicenseParams(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_license_params";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void setNameLabel(Connection c, String label) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.set_name_label";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(label)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setNameDescription(Connection c, String description) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.set_name_description";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(description)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setOtherConfig(Connection c, Map<String, String> otherConfig) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.set_other_config";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(otherConfig)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void addToOtherConfig(Connection c, String key, String value) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.add_to_other_config";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key), Marshalling.toXMLRPC(value)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void removeFromOtherConfig(Connection c, String key) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.remove_from_other_config";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setLogging(Connection c, Map<String, String> logging) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.set_logging";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(logging)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void addToLogging(Connection c, String key, String value) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.add_to_logging";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key), Marshalling.toXMLRPC(value)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void removeFromLogging(Connection c, String key) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.remove_from_logging";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setSuspendImageSr(Connection c, SR suspendImageSr) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.set_suspend_image_sr";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(suspendImageSr)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setCrashDumpSr(Connection c, SR crashDumpSr) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.set_crash_dump_sr";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(crashDumpSr)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setHostname(Connection c, String hostname) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.set_hostname";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(hostname)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setAddress(Connection c, String address) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.set_address";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(address)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public Task disableAsync(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.host.disable";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void disable(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.disable";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public Task enableAsync(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.host.enable";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void enable(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.enable";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public Task shutdownAsync(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.host.shutdown";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void shutdown(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.shutdown";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public Task rebootAsync(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.host.reboot";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void reboot(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.reboot";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public Task dmesgAsync(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.host.dmesg";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String dmesg(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.dmesg";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Task dmesgClearAsync(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.host.dmesg_clear";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String dmesgClear(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.dmesg_clear";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Task getLogAsync(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.host.get_log";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getLog(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_log";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Task sendDebugKeysAsync(Connection c, String keys) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.host.send_debug_keys";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(keys)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void sendDebugKeys(Connection c, String keys) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.send_debug_keys";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(keys)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public Task bugreportUploadAsync(Connection c, String url, Map<String, String> options) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.host.bugreport_upload";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(url), Marshalling.toXMLRPC(options)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void bugreportUpload(Connection c, String url, Map<String, String> options) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.bugreport_upload";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(url), Marshalling.toXMLRPC(options)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public static Set<String> listMethods(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.list_methods";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Task licenseApplyAsync(Connection c, String contents) throws Types.BadServerResponse, XmlRpcException, Types.LicenseProcessingError {
        Object[] error;
        String method_call = "Async.host.license_apply";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(contents)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        if (response.get("Status").equals("Failure") && (error = (Object[])response.get("ErrorDescription"))[0].equals("LICENSE_PROCESSING_ERROR")) {
            throw new Types.LicenseProcessingError();
        }
        throw new Types.BadServerResponse(response);
    }

    public void licenseApply(Connection c, String contents) throws Types.BadServerResponse, XmlRpcException, Types.LicenseProcessingError {
        Object[] error;
        String method_call = "host.license_apply";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(contents)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        if (response.get("Status").equals("Failure") && (error = (Object[])response.get("ErrorDescription"))[0].equals("LICENSE_PROCESSING_ERROR")) {
            throw new Types.LicenseProcessingError();
        }
        throw new Types.BadServerResponse(response);
    }

    public Task destroyAsync(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.host.destroy";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void destroy(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.destroy";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public Task assertCanEvacuateAsync(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.host.assert_can_evacuate";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void assertCanEvacuate(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.assert_can_evacuate";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public Task evacuateAsync(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.host.evacuate";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void evacuate(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.evacuate";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public Task syslogReconfigureAsync(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.host.syslog_reconfigure";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void syslogReconfigure(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.syslog_reconfigure";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public static Task managementReconfigureAsync(Connection c, PIF pif) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.host.management_reconfigure";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(pif)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static void managementReconfigure(Connection c, PIF pif) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.management_reconfigure";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(pif)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public static void localManagementReconfigure(Connection c, String iface) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.local_management_reconfigure";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(iface)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public static void managementDisable(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.management_disable";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public String getSystemStatusCapabilities(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_system_status_capabilities";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static Set<Host> getAll(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_all";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfHost(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static Map<Host, Record> getAllRecords(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "host.get_all_records";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfHostHostRecord(result);
        }
        throw new Types.BadServerResponse(response);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Record
    implements Types.Record {
        public String uuid;
        public String nameLabel;
        public String nameDescription;
        public Set<Types.HostAllowedOperations> allowedOperations;
        public Map<String, Types.HostAllowedOperations> currentOperations;
        public Long APIVersionMajor;
        public Long APIVersionMinor;
        public String APIVersionVendor;
        public Map<String, String> APIVersionVendorImplementation;
        public Boolean enabled;
        public Map<String, String> softwareVersion;
        public Map<String, String> otherConfig;
        public Set<String> capabilities;
        public Map<String, String> cpuConfiguration;
        public String schedPolicy;
        public Set<String> supportedBootloaders;
        public Set<VM> residentVMs;
        public Map<String, String> logging;
        public Set<PIF> PIFs;
        public SR suspendImageSr;
        public SR crashDumpSr;
        public Set<HostCrashdump> crashdumps;
        public Set<HostPatch> patches;
        public Set<PBD> PBDs;
        public Set<HostCpu> hostCPUs;
        public String hostname;
        public String address;
        public HostMetrics metrics;
        public Map<String, String> licenseParams;

        public String toString() {
            StringWriter writer = new StringWriter();
            PrintWriter print = new PrintWriter(writer);
            print.printf("%1$20s: %2$s\n", "uuid", this.uuid);
            print.printf("%1$20s: %2$s\n", "nameLabel", this.nameLabel);
            print.printf("%1$20s: %2$s\n", "nameDescription", this.nameDescription);
            print.printf("%1$20s: %2$s\n", "allowedOperations", this.allowedOperations);
            print.printf("%1$20s: %2$s\n", "currentOperations", this.currentOperations);
            print.printf("%1$20s: %2$s\n", "APIVersionMajor", this.APIVersionMajor);
            print.printf("%1$20s: %2$s\n", "APIVersionMinor", this.APIVersionMinor);
            print.printf("%1$20s: %2$s\n", "APIVersionVendor", this.APIVersionVendor);
            print.printf("%1$20s: %2$s\n", "APIVersionVendorImplementation", this.APIVersionVendorImplementation);
            print.printf("%1$20s: %2$s\n", "enabled", this.enabled);
            print.printf("%1$20s: %2$s\n", "softwareVersion", this.softwareVersion);
            print.printf("%1$20s: %2$s\n", "otherConfig", this.otherConfig);
            print.printf("%1$20s: %2$s\n", "capabilities", this.capabilities);
            print.printf("%1$20s: %2$s\n", "cpuConfiguration", this.cpuConfiguration);
            print.printf("%1$20s: %2$s\n", "schedPolicy", this.schedPolicy);
            print.printf("%1$20s: %2$s\n", "supportedBootloaders", this.supportedBootloaders);
            print.printf("%1$20s: %2$s\n", "residentVMs", this.residentVMs);
            print.printf("%1$20s: %2$s\n", "logging", this.logging);
            print.printf("%1$20s: %2$s\n", "PIFs", this.PIFs);
            print.printf("%1$20s: %2$s\n", "suspendImageSr", this.suspendImageSr);
            print.printf("%1$20s: %2$s\n", "crashDumpSr", this.crashDumpSr);
            print.printf("%1$20s: %2$s\n", "crashdumps", this.crashdumps);
            print.printf("%1$20s: %2$s\n", "patches", this.patches);
            print.printf("%1$20s: %2$s\n", "PBDs", this.PBDs);
            print.printf("%1$20s: %2$s\n", "hostCPUs", this.hostCPUs);
            print.printf("%1$20s: %2$s\n", "hostname", this.hostname);
            print.printf("%1$20s: %2$s\n", "address", this.address);
            print.printf("%1$20s: %2$s\n", "metrics", this.metrics);
            print.printf("%1$20s: %2$s\n", "licenseParams", this.licenseParams);
            return writer.toString();
        }

        @Override
        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("uuid", this.uuid);
            map.put("name_label", this.nameLabel);
            map.put("name_description", this.nameDescription);
            map.put("allowed_operations", this.allowedOperations);
            map.put("current_operations", this.currentOperations);
            map.put("API_version_major", this.APIVersionMajor);
            map.put("API_version_minor", this.APIVersionMinor);
            map.put("API_version_vendor", this.APIVersionVendor);
            map.put("API_version_vendor_implementation", this.APIVersionVendorImplementation);
            map.put("enabled", this.enabled);
            map.put("software_version", this.softwareVersion);
            map.put("other_config", this.otherConfig);
            map.put("capabilities", this.capabilities);
            map.put("cpu_configuration", this.cpuConfiguration);
            map.put("sched_policy", this.schedPolicy);
            map.put("supported_bootloaders", this.supportedBootloaders);
            map.put("resident_VMs", this.residentVMs);
            map.put("logging", this.logging);
            map.put("PIFs", this.PIFs);
            map.put("suspend_image_sr", this.suspendImageSr);
            map.put("crash_dump_sr", this.crashDumpSr);
            map.put("crashdumps", this.crashdumps);
            map.put("patches", this.patches);
            map.put("PBDs", this.PBDs);
            map.put("host_CPUs", this.hostCPUs);
            map.put("hostname", this.hostname);
            map.put("address", this.address);
            map.put("metrics", this.metrics);
            map.put("license_params", this.licenseParams);
            return map;
        }
    }
}

