/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.main;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.Properties;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.Domain;
import org.ow2.jasmine.vmm.agent.domain.DomainBuilder;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.DomainMXBean;
import org.ow2.jasmine.vmm.api.VMMAgentMXBean;

public class VirtManagerAgent
extends AgentCommon
implements VMMAgentMXBean {
    private static Logger logger = Logger.getLogger(VirtManagerAgent.class);
    public static final String vmmHome = System.getProperty("vmm.home");
    static VirtManagerAgent instance;
    Domain rootDomain;

    public DomainMXBean getRootDomain() {
        return this.rootDomain;
    }

    public static void main(String[] args) {
        if (vmmHome == null) {
            logger.error((Object)"vmm.home system property must be set");
            System.exit(1);
        }
        instance = new VirtManagerAgent(args);
    }

    private VirtManagerAgent(String[] args) {
        int port;
        instance = this;
        Properties properties = new Properties();
        String agentPropFileName = "etc" + File.separator + "agent.properties";
        try {
            properties.load(new FileInputStream(new File(vmmHome, agentPropFileName)));
        }
        catch (IOException ex) {
            logger.fatal((Object)("Cannot load VMM agent property file " + agentPropFileName), (Throwable)ex);
            System.exit(1);
        }
        ObjectName agentName = MBeanObjectNamer.makeAgentName();
        try {
            mbs.registerMBean(this, agentName);
        }
        catch (Exception ex) {
            logger.fatal((Object)("Cannot register MXBean " + agentName));
            System.exit(1);
        }
        logger.info((Object)("Created VMMAgent MBean " + agentName));
        try {
            port = Integer.parseInt(properties.getProperty("vmm.port"));
        }
        catch (NumberFormatException ex) {
            port = 9999;
        }
        String managedResourcesFileName = properties.getProperty("vmm.resourceFile", "managed-resources.xml");
        File managedResourcesFile = new File(vmmHome, "etc" + File.separator + managedResourcesFileName);
        this.rootDomain = DomainBuilder.createManagedResourcesFromXML(managedResourcesFile);
        if (this.rootDomain == null) {
            logger.fatal((Object)"Failed to load resource file");
            System.exit(1);
        }
        try {
            LocateRegistry.createRegistry(port);
        }
        catch (RemoteException ex) {
            logger.warn((Object)("Cannot launch RMI registry on port " + port + ", creating new one"));
            try {
                LocateRegistry.createRegistry(port);
            }
            catch (RemoteException ex2) {
                logger.fatal((Object)"Cannot create RMI registry", (Throwable)ex);
                System.exit(1);
            }
        }
        try {
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + port + "/server");
            JMXConnectorServer cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, mbs);
            logger.info((Object)("Starting RMI connector server with URL \"" + url + "\""));
            cs.start();
            logger.info((Object)"VMM agent ready");
        }
        catch (Exception ex) {
            logger.fatal((Object)"Failed to starte JMX connector server", (Throwable)ex);
            System.exit(1);
        }
    }

    public void shutdown() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                logger.info((Object)"VMM agent terminated");
                System.exit(0);
            }
        }).run();
    }
}

