/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.domain;

import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.api.ManagedResourceMXBean;

public abstract class ManagedResource
extends NotificationBroadcasterSupport
implements ManagedResourceMXBean {
    static Logger logger = Logger.getLogger(ManagedResource.class);
    protected String path;
    protected ObjectName objectName;
    private long notificationSequence = 0L;

    protected ManagedResource(ObjectName objectName) {
        this.objectName = objectName;
        this.path = objectName.getKeyPropertyList().get("name");
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public String getPath() {
        return this.path;
    }

    protected synchronized void emitNotification(String type, String message, Object userData) {
        this.emitNotification(type, message, userData, System.currentTimeMillis());
    }

    protected synchronized void emitNotification(String type, String message, Object userData, long timeStamp) {
        logger.debug((Object)("Emitting notification [\n\ttype=" + type + "\n\tmsg=" + message + "\n\tsource=" + this.objectName + "\n\tuserdata=" + userData + "]"));
        Notification notification = new Notification(type, (Object)this.objectName, this.notificationSequence++, message);
        notification.setUserData(userData);
        notification.setTimeStamp(timeStamp);
        this.sendNotification(notification);
    }
}

