/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.dummy;

import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.driver.dummy.DummyHost;
import org.ow2.jasmine.vmm.api.BadVMPowerStateException;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.IllegalOperationException;
import org.ow2.jasmine.vmm.api.InsufficientResourcesException;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;

class DummyVirtualMachine
extends ManagedResource
implements VirtualMachineMXBean {
    static Logger logger = Logger.getLogger(DummyVirtualMachine.class);
    private String name;
    private DummyHost host;
    private String uuid;
    private String ipAddress;
    private int numVCPU;
    private int schedulingCap;
    private int schedulingWeight;
    private int diskSizeMB;
    private long memorySizeMB;
    private long memoryUsedMB;
    private VirtualMachineMXBean.PowerState status = VirtualMachineMXBean.PowerState.RUNNING;
    private Date startTime;
    Map<String, String> userData = new HashMap<String, String>();
    int count = 0;

    public DummyVirtualMachine(String name, String uuid, ObjectName objectName, DummyHost host) {
        super(objectName);
        this.name = name;
        this.host = host;
        this.uuid = uuid;
        this.memorySizeMB = 1024L;
        this.startTime = new Date(System.currentTimeMillis());
        try {
            this.ipAddress = InetAddress.getByName("198.7.9.66").getHostAddress();
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to get IP address", (Throwable)ex);
        }
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public long getUpTimeSeconds() {
        return (System.currentTimeMillis() - this.startTime.getTime()) / 1000L;
    }

    public int getNumVCPUs() {
        return this.numVCPU;
    }

    public void setNumVCPUs(int numVCPU) {
        this.numVCPU = numVCPU;
    }

    public int getDiskSizeMB() {
        return this.diskSizeMB;
    }

    public void setDiskSizeMB(int diskSizeMB) {
        this.diskSizeMB = diskSizeMB;
    }

    public long getMemorySizeMB() {
        return this.memorySizeMB;
    }

    public long getMemoryUsedMB() {
        return this.memoryUsedMB;
    }

    public void setMemorySizeMB(long memorySizeMB) {
        this.memorySizeMB = memorySizeMB;
        this.memoryUsedMB = memorySizeMB / 2L;
    }

    public void addUserData(String key, String value) {
        this.userData.put(key, value);
    }

    public String getUserData(String key) {
        return this.userData.get(key);
    }

    public void onVMStatusChanged() {
        logger.info((Object)("VM " + this.getNameLabel() + " state=" + this.getState()));
        this.emitNotification("vm.state", this.getState().toString(), null);
    }

    public boolean canLiveMigrateToHost(HostMXBean targetHost) {
        return targetHost != this.host && this.getMemorySizeMB() <= targetHost.getFreeMemoryMB();
    }

    public void destroy() {
        this.host.onDestroyVM(this);
    }

    public float[] getLoadPerVCPU() {
        return new float[]{8.0f, 10.0f};
    }

    public float getCPULoad() {
        return 0.0f;
    }

    public HostMXBean getHostMBean() {
        return this.host;
    }

    public String getGuestIpAddress() {
        return this.ipAddress;
    }

    public String getMacAddress() {
        return "8E:10:65:AB:CE:26";
    }

    public int getMemory() {
        return 0;
    }

    public String getNameLabel() {
        return this.name;
    }

    public String getPinnedVCPUs() {
        return null;
    }

    public int getSchedulingCap() {
        return this.schedulingCap;
    }

    public int getSchedulingWeight() {
        return this.schedulingWeight;
    }

    public VirtualMachineMXBean.PowerState getState() {
        return this.status;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void reboot() {
    }

    public void resume() {
        if (this.status == VirtualMachineMXBean.PowerState.SUSPENDED) {
            this.status = VirtualMachineMXBean.PowerState.RUNNING;
            this.onVMStatusChanged();
            logger.info((Object)("VM " + this.name + " resumed"));
        }
    }

    public void setMacAddress(String mac) {
    }

    public void setPinnedVCPUs(String pinnedVCPUs) {
    }

    public void setSchedulingCap(int schedulingCap) {
        this.schedulingCap = schedulingCap;
    }

    public void setSchedulingWeight(int schedulingWeight) {
        this.schedulingWeight = schedulingWeight;
    }

    public void shutdown() {
        if (this.status == VirtualMachineMXBean.PowerState.RUNNING) {
            this.status = VirtualMachineMXBean.PowerState.HALTED;
            this.onVMStatusChanged();
            logger.info((Object)("VM " + this.name + " shutdowned"));
        }
    }

    public void start() {
        if (this.status == VirtualMachineMXBean.PowerState.HALTED) {
            this.status = VirtualMachineMXBean.PowerState.RUNNING;
            this.onVMStatusChanged();
            logger.info((Object)("VM " + this.name + " started"));
        }
    }

    public void suspend() throws BadVMPowerStateException {
        if (this.status == VirtualMachineMXBean.PowerState.RUNNING) {
            this.status = VirtualMachineMXBean.PowerState.SUSPENDED;
            this.onVMStatusChanged();
            logger.info((Object)("VM " + this.name + " suspended"));
        }
    }

    public void migrate(HostMXBean targetHost, boolean live) throws IllegalOperationException, VMMException {
        String targetHostName = targetHost.getHostName();
        boolean foundHostInServerPool = false;
        for (HostMXBean h : this.host.getServerPool().getManagedHosts()) {
            if (!h.getHostName().equals(targetHost.getHostName())) continue;
            foundHostInServerPool = true;
            targetHost = h;
            break;
        }
        if (!foundHostInServerPool) {
            throw new IllegalOperationException("Source and target hosts belong to different server pools");
        }
        this.emitNotification("vm.migration.start", targetHostName, this.uuid);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        DummyHost target = (DummyHost)targetHost;
        this.host.postMigrateVM(this, target);
        this.host = target;
        this.emitNotification("vm.migration", targetHostName, this.uuid);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"vm.state", "vm.migration", "log", "vm.error"}, Notification.class.getName(), "VM event")};
    }

    public void makeTemplate(String vmImageID, String name, String description) throws InsufficientResourcesException, IllegalOperationException, VMMException {
    }
}

