/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.domain.policy;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.policy.VMPlacementPolicy;
import org.ow2.jasmine.vmm.agent.main.VirtManagerAgent;

public final class PolicyRegistry {
    private static Logger logger = Logger.getLogger(PolicyRegistry.class);
    private static final String VM_PLACEMENT_MAP_FILENAME = "vm_placement_map.properties";
    private static final String DEFAULT_POLICY_ID = "room-for-growth";
    private static PolicyRegistry instance;
    private final Map<String, String> map = new HashMap<String, String>();

    private PolicyRegistry() {
        Properties properties = new Properties();
        String agentPropFileName = "etc" + File.separator + VM_PLACEMENT_MAP_FILENAME;
        try {
            properties.load(new FileInputStream(new File(VirtManagerAgent.vmmHome, agentPropFileName)));
        }
        catch (IOException ex) {
            logger.warn((Object)"Cannot find vm_placement_map.properties file");
        }
        Enumeration<Object> it = properties.keys();
        while (it.hasMoreElements()) {
            String policyAlias = (String)it.nextElement();
            String policyClass = properties.getProperty(policyAlias);
            this.map.put(policyAlias, policyClass);
            logger.info((Object)("Added alias " + policyAlias + " for " + policyClass));
        }
    }

    public static PolicyRegistry getInstance() {
        if (instance == null) {
            instance = new PolicyRegistry();
        }
        return instance;
    }

    public VMPlacementPolicy newPolicy(String policyId) {
        String policyClassName = this.map.get(policyId);
        VMPlacementPolicy policy = null;
        if (policyClassName != null) {
            try {
                policy = (VMPlacementPolicy)Class.forName(policyClassName).newInstance();
            }
            catch (Exception ex) {
                logger.error((Object)("Failed to instance policy " + policyId), (Throwable)ex);
            }
        } else {
            logger.error((Object)("Unknown driver " + policyId));
        }
        return policy;
    }

    public VMPlacementPolicy newDefaultPolicy() {
        return this.newPolicy(DEFAULT_POLICY_ID);
    }
}

