/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.vmware;

import com.vmware.vim.Event;
import com.vmware.vim.EventFilterSpec;
import com.vmware.vim.EventFilterSpecByEntity;
import com.vmware.vim.EventFilterSpecByTime;
import com.vmware.vim.EventFilterSpecRecursionOption;
import com.vmware.vim.ManagedObjectReference;
import com.vmware.vim.VmBeingHotMigratedEvent;
import com.vmware.vim.VmConnectedEvent;
import com.vmware.vim.VmCreatedEvent;
import com.vmware.vim.VmEvent;
import com.vmware.vim.VmMigratedEvent;
import com.vmware.vim.VmPoweredOffEvent;
import com.vmware.vim.VmPoweredOnEvent;
import com.vmware.vim.VmRemovedEvent;
import com.vmware.vim.VmSuspendedEvent;
import java.util.Calendar;
import org.apache.axis.client.Stub;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareHost;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareServerPool;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareServiceConnection;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;

class VMwareEventCollector {
    static Logger logger = Logger.getLogger(VMwareEventCollector.class);
    private static int PERIOD_MS = 15000;
    private VMwareServiceConnection connection;
    private VMwareServerPool pool;
    private String mountPointPath;

    public VMwareEventCollector(VMwareServerPool pool, VMwareServiceConnection connection, String mountPointPath) {
        this.pool = pool;
        this.connection = connection;
        this.mountPointPath = mountPointPath;
    }

    private ManagedObjectReference createCollector() throws Exception {
        this.connection.connect();
        ManagedObjectReference meRef = this.connection.getService().findByInventoryPath(this.connection.getServiceContent().getSearchIndex(), this.mountPointPath);
        EventFilterSpecByEntity entitySpec = new EventFilterSpecByEntity();
        entitySpec.setEntity(meRef);
        entitySpec.setRecursion(EventFilterSpecRecursionOption.all);
        EventFilterSpec eFSpec = new EventFilterSpec();
        eFSpec.setEntity(entitySpec);
        EventFilterSpecByTime filterSpecByTime = new EventFilterSpecByTime();
        filterSpecByTime.setBeginTime(Calendar.getInstance());
        eFSpec.setTime(filterSpecByTime);
        return this.connection.getService().createCollectorForEvents(this.connection.getServiceContent().getEventManager(), eFSpec);
    }

    public void start() {
        try {
            this.pool.getExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    ManagedObjectReference eHistoryCollect = null;
                    EventFilterSpec eFSpec = new EventFilterSpec();
                    try {
                        VMwareEventCollector.this.connection.connect();
                        ManagedObjectReference meRef = VMwareEventCollector.this.connection.getService().findByInventoryPath(VMwareEventCollector.this.connection.getServiceContent().getSearchIndex(), VMwareEventCollector.this.mountPointPath);
                        EventFilterSpecByEntity entitySpec = new EventFilterSpecByEntity();
                        entitySpec.setEntity(meRef);
                        entitySpec.setRecursion(EventFilterSpecRecursionOption.all);
                        eFSpec.setEntity(entitySpec);
                        EventFilterSpecByTime filterSpecByTime = new EventFilterSpecByTime();
                        filterSpecByTime.setBeginTime(Calendar.getInstance());
                        eFSpec.setTime(filterSpecByTime);
                    }
                    catch (Exception ex) {
                        logger.error((Object)"Failed to start event collector", (Throwable)ex);
                        return;
                    }
                    while (true) {
                        try {
                            while (true) {
                                if (eHistoryCollect == null) {
                                    eHistoryCollect = VMwareEventCollector.this.createCollector();
                                }
                                ((Stub)VMwareEventCollector.this.connection.getService()).setTimeout(36000000);
                                Event[] eventCollection = VMwareEventCollector.this.connection.getService().readNextEvents(eHistoryCollect, 100);
                                if (eventCollection != null) {
                                    for (Event event : eventCollection) {
                                        VMwareHost host;
                                        long eventTime = event.getCreatedTime().getTimeInMillis();
                                        if (!(event instanceof VmEvent)) continue;
                                        if (((VmEvent)event).isTemplate()) {
                                            logger.debug((Object)("Received event for VM template " + event.getVm().getName()));
                                            ((VMwareServerPool.VMwareVMTemplateDataStore)VMwareEventCollector.this.pool.getVMImageStore()).sync();
                                            continue;
                                        }
                                        if (event instanceof VmPoweredOffEvent) {
                                            host = VMwareEventCollector.this.pool.getHostByName(event.getHost().getName());
                                            if (host == null) continue;
                                            host.onPowerStateChangedVM(event.getVm().getVm(), event.getVm().getName(), VirtualMachineMXBean.PowerState.HALTED, eventTime);
                                            continue;
                                        }
                                        if (event instanceof VmPoweredOnEvent) {
                                            host = VMwareEventCollector.this.pool.getHostByName(event.getHost().getName());
                                            if (host == null) continue;
                                            host.onPowerStateChangedVM(event.getVm().getVm(), event.getVm().getName(), VirtualMachineMXBean.PowerState.RUNNING, eventTime);
                                            continue;
                                        }
                                        if (event instanceof VmSuspendedEvent) {
                                            host = VMwareEventCollector.this.pool.getHostByName(event.getHost().getName());
                                            if (host == null) continue;
                                            host.onPowerStateChangedVM(event.getVm().getVm(), event.getVm().getName(), VirtualMachineMXBean.PowerState.SUSPENDED, eventTime);
                                            continue;
                                        }
                                        if (event instanceof VmCreatedEvent) {
                                            host = VMwareEventCollector.this.pool.getHostByName(event.getHost().getName());
                                            logger.debug((Object)("CreatedEvent " + event.getVm().getName()));
                                            continue;
                                        }
                                        if (event instanceof VmConnectedEvent) {
                                            host = VMwareEventCollector.this.pool.getHostByName(event.getHost().getName());
                                            logger.debug((Object)("ConnectedEvent " + event.getVm().getName()));
                                            ((VMwareServerPool.VMwareVMTemplateDataStore)VMwareEventCollector.this.pool.getVMImageStore()).sync();
                                            continue;
                                        }
                                        if (event instanceof VmRemovedEvent) {
                                            host = VMwareEventCollector.this.pool.getHostByName(event.getHost().getName());
                                            continue;
                                        }
                                        if (event instanceof VmBeingHotMigratedEvent) {
                                            VmBeingHotMigratedEvent beingMigratedEvent = (VmBeingHotMigratedEvent)event;
                                            continue;
                                        }
                                        if (!(event instanceof VmMigratedEvent)) continue;
                                        VmMigratedEvent migratedEvent = (VmMigratedEvent)event;
                                    }
                                }
                                Thread.sleep(PERIOD_MS);
                            }
                        }
                        catch (Exception ex) {
                            logger.error((Object)"In VMware event collector: ", (Throwable)ex);
                            continue;
                        }
                        break;
                    }
                }
            });
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to initialize event collector", (Throwable)ex);
        }
    }
}

