/*
 * Decompiled with CFR 0.152.
 */
package com.xensource.xenapi;

import com.xensource.xenapi.XenAPIObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class Marshalling {
    public static Object toXMLRPC(Object o) {
        if (o instanceof String || o instanceof Boolean || o instanceof Float || o instanceof Date) {
            return o;
        }
        if (o instanceof Long) {
            return o.toString();
        }
        if (o instanceof Map) {
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            Map m = (Map)o;
            for (Object k : m.keySet()) {
                result.put(Marshalling.toXMLRPC(k), Marshalling.toXMLRPC(m.get(k)));
            }
            return result;
        }
        if (o instanceof Set) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object e : (Set)o) {
                result.add(Marshalling.toXMLRPC(e));
            }
            return result;
        }
        if (o instanceof XenAPIObject) {
            return ((XenAPIObject)o).toWireString();
        }
        if (o == null) {
            return "";
        }
        if (o instanceof Enum) {
            String s = ((Enum)o).name();
            if (s.equalsIgnoreCase("RO") || s.equalsIgnoreCase("RW")) {
                return s;
            }
            return ((Enum)o).name().toLowerCase();
        }
        throw new RuntimeException("=============don't know how to marshall:({[" + o + "]})");
    }
}

