/*
 * Decompiled with CFR 0.152.
 */
package com.xensource.xenapi;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Marshalling;
import com.xensource.xenapi.Network;
import com.xensource.xenapi.PIF;
import com.xensource.xenapi.Task;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.XenAPIObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bond
extends XenAPIObject {
    protected final String ref;
    private static final Map<String, SoftReference<Bond>> cache = new HashMap<String, SoftReference<Bond>>();

    private Bond(String ref) {
        this.ref = ref;
    }

    @Override
    public String toWireString() {
        return this.ref;
    }

    protected static synchronized Bond getInstFromRef(String ref) {
        Bond instance;
        if (cache.containsKey(ref) && (instance = cache.get(ref).get()) != null) {
            return instance;
        }
        instance = new Bond(ref);
        cache.put(ref, new SoftReference<Bond>(instance));
        return instance;
    }

    public Record getRecord(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Bond.get_record";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toBondRecord(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static Bond getByUuid(Connection c, String uuid) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Bond.get_by_uuid";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(uuid)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toBond(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getUuid(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Bond.get_uuid";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public PIF getMaster(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Bond.get_master";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toPIF(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Set<PIF> getSlaves(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Bond.get_slaves";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfPIF(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, String> getOtherConfig(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Bond.get_other_config";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void setOtherConfig(Connection c, Map<String, String> otherConfig) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Bond.set_other_config";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(otherConfig)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void addToOtherConfig(Connection c, String key, String value) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Bond.add_to_other_config";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key), Marshalling.toXMLRPC(value)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void removeFromOtherConfig(Connection c, String key) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Bond.remove_from_other_config";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public static Task createAsync(Connection c, Network network, Set<PIF> members, String MAC) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.Bond.create";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(network), Marshalling.toXMLRPC(members), Marshalling.toXMLRPC(MAC)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static Bond create(Connection c, Network network, Set<PIF> members, String MAC) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Bond.create";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(network), Marshalling.toXMLRPC(members), Marshalling.toXMLRPC(MAC)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toBond(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Task destroyAsync(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.Bond.destroy";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void destroy(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Bond.destroy";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public static Set<Bond> getAll(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Bond.get_all";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfBond(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static Map<Bond, Record> getAllRecords(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Bond.get_all_records";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfBondBondRecord(result);
        }
        throw new Types.BadServerResponse(response);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Record
    implements Types.Record {
        public String uuid;
        public PIF master;
        public Set<PIF> slaves;
        public Map<String, String> otherConfig;

        public String toString() {
            StringWriter writer = new StringWriter();
            PrintWriter print = new PrintWriter(writer);
            print.printf("%1$20s: %2$s\n", "uuid", this.uuid);
            print.printf("%1$20s: %2$s\n", "master", this.master);
            print.printf("%1$20s: %2$s\n", "slaves", this.slaves);
            print.printf("%1$20s: %2$s\n", "otherConfig", this.otherConfig);
            return writer.toString();
        }

        @Override
        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("uuid", this.uuid);
            map.put("master", this.master);
            map.put("slaves", this.slaves);
            map.put("other_config", this.otherConfig);
            return map;
        }
    }
}

