/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.vmware;

import com.vmware.vim.ArrayOfManagedObjectReference;
import com.vmware.vim.DynamicProperty;
import com.vmware.vim.HostCpuInfo;
import com.vmware.vim.HostCpuPackage;
import com.vmware.vim.HostHardwareInfo;
import com.vmware.vim.ManagedObjectReference;
import com.vmware.vim.ObjectContent;
import com.vmware.vim.VirtualMachineCloneSpec;
import com.vmware.vim.VirtualMachineConfigSpec;
import com.vmware.vim.VirtualMachineRelocateSpec;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.ObjectName;
import org.apache.axis.AxisFault;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwarePerfMonitor;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareServerPool;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareServiceConnection;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareVirtualMachine;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.InsufficientResourcesException;
import org.ow2.jasmine.vmm.api.InvalidVMConfigException;
import org.ow2.jasmine.vmm.api.ServerPoolMXBean;
import org.ow2.jasmine.vmm.api.VMConfigSpec;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;
import org.w3c.dom.Element;

class VMwareHost
extends ManagedResource
implements HostMXBean {
    static Logger logger = Logger.getLogger(VMwareHost.class);
    private VMwareServerPool pool;
    private VMwareServiceConnection defaultConnection;
    private VMwareServerPool.ConnectionPool connectionPool;
    private String hostName;
    private int numCPU = -1;
    private ManagedObjectReference mor;
    private HashMap<String, VMwareVirtualMachine> vmRefs = new HashMap();
    private VMwarePerfMonitor perfMon = null;
    private HashMap<String, BigInteger> hostMetricValues = null;
    private HashMap<String, HashMap<String, BigInteger>> metricValuesPerVM = null;
    private String[][] counterNames = null;
    private ManagedObjectReference myResourcePool;
    HashMap<String, String> hypervisorInfo = null;
    HashMap<String, String> cpuInfo = null;
    private Timer perfTimer = null;
    private Set<HostMXBean.PerfMetric> currentMonitoredMetrics;
    private long currentMonitoringPeriod;

    public VMwareHost(VMwareServerPool pool, ManagedObjectReference mor, ObjectName objectName, String hostName) {
        super(objectName);
        this.pool = pool;
        this.defaultConnection = pool.getConnectionPool().getConnection();
        this.connectionPool = pool.getConnectionPool();
        this.mor = mor;
        this.objectName = objectName;
        this.hostName = hostName;
        this.counterNames = new String[][]{{"cpu", "usage", "average"}, {"mem", "usage", "average"}, {"mem", "active", "average"}, {"mem", "granted", "average"}, {"mem", "state", "latest"}, {"disk", "usage", "average"}, {"net", "transmitted", "average"}, {"net", "received", "average"}, {"sys", "uptime", "latest"}};
    }

    public ManagedObjectReference getMOR() {
        return this.mor;
    }

    @Override
    public ServerPoolMXBean getServerPool() {
        return this.pool;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    public VMwareServiceConnection getDefaultConnection() {
        return this.defaultConnection;
    }

    public VMwareServerPool.ConnectionPool getConnectionPool() {
        return this.pool.getConnectionPool();
    }

    @Override
    public Map<String, String> getHypervisorInfo() {
        if (this.hypervisorInfo == null) {
            this.hypervisorInfo = new HashMap();
            this.hypervisorInfo.put("name", "ESX");
            this.hypervisorInfo.put("vendor", "VMware");
            this.hypervisorInfo.put("version", "3.0.2");
        }
        return this.hypervisorInfo;
    }

    @Override
    public int getNumCPU() {
        if (this.numCPU == -1) {
            this.getCPUInfo();
        }
        return this.numCPU;
    }

    @Override
    public Map<String, String> getCPUInfo() {
        if (this.cpuInfo == null) {
            this.cpuInfo = new HashMap();
            try {
                DynamicProperty[] cpuArry = this.getDynamicProarray(this.mor, "hardware");
                HostHardwareInfo hinfo = (HostHardwareInfo)cpuArry[0].getVal();
                HostCpuInfo tinfo = hinfo.getCpuInfo();
                HostCpuPackage cinfo = hinfo.getCpuPkg(0);
                this.cpuInfo.put("speed", Long.toString(tinfo.getHz() / 1000000L));
                this.numCPU = tinfo.getNumCpuCores();
                this.cpuInfo.put("vendor", cinfo.getVendor());
            }
            catch (Exception ex) {
                logger.debug((Object)("Host " + this.hostName), (Throwable)ex);
            }
        }
        return this.cpuInfo;
    }

    private VMwareVirtualMachine addVm(ManagedObjectReference vmRef, String vmName) {
        ObjectName vmMBeanObjectName = MBeanObjectNamer.makeVirtualMachineName(this.pool.getPath() + "/" + vmName, VMwareVirtualMachine.getUuid(this.defaultConnection, vmRef));
        VMwareVirtualMachine vm = new VMwareVirtualMachine(vmMBeanObjectName, this.pool, vmRef, this, vmName);
        try {
            AgentCommon.getMBeanServer().registerMBean(vm, vmMBeanObjectName);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.vmRefs.put(vmName, vm);
        logger.info((Object)("Added VirtualMachine " + vmName + " " + vmMBeanObjectName));
        return vm;
    }

    @Override
    public List<VirtualMachineMXBean> getResidentVMs() {
        ArrayList<VirtualMachineMXBean> result = new ArrayList<VirtualMachineMXBean>();
        try {
            ArrayOfManagedObjectReference vms = (ArrayOfManagedObjectReference)this.getDynamicProarray(this.mor, "vm")[0].getVal();
            for (ManagedObjectReference vmMor : vms.getManagedObjectReference()) {
                DynamicProperty[] properties;
                boolean isTemplate = (Boolean)this.getDynamicProarray(vmMor, "summary.config.template")[0].getVal();
                if (isTemplate || (properties = this.getDynamicProarray(vmMor, "config.name")) == null || properties.length < 1) continue;
                String vmName = (String)properties[0].getVal();
                VMwareVirtualMachine vm = this.vmRefs.get(vmName);
                if (vm == null) {
                    vm = this.addVm(vmMor, vmName);
                }
                result.add(vm);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to retrieve resident VM of host " + this.hostName), (Throwable)ex);
        }
        return result;
    }

    synchronized void onPowerStateChangedVM(ManagedObjectReference vmRef, String vmName, VirtualMachineMXBean.PowerState state, long time) {
        VMwareVirtualMachine vm = this.vmRefs.get(vmName);
        if (vm != null) {
            vm.onPowerStateChangedVM(state, time);
        }
    }

    @Override
    public long getTotalMemoryMB() {
        long total = 0L;
        try {
            DynamicProperty[] cpuArry = this.getDynamicProarray(this.mor, "hardware");
            total = ((HostHardwareInfo)cpuArry[0].getVal()).getMemorySize();
        }
        catch (Exception ex) {
            logger.debug((Object)("Host " + this.hostName), (Throwable)ex);
        }
        return total / 0x100000L;
    }

    @Override
    public long getFreeMemoryMB() {
        if (this.hostMetricValues != null) {
            return this.hostMetricValues.get("mem.granted").longValue();
        }
        try {
            int overallMemoryUsage = (Integer)this.getDynamicProarray(this.mor, "summary.quickStats.overallMemoryUsage")[0].getVal();
            return this.getTotalMemoryMB() - (long)overallMemoryUsage;
        }
        catch (Exception ex) {
            logger.error((Object)"Cannot retrieve attribute summary.quickStats.overallMemoryUsage", (Throwable)ex);
            return -1L;
        }
    }

    @Override
    public float[] getLoadPerCPU() {
        logger.info((Object)"[VMWareHost.getLoadPerCPU] : Not Implemented");
        return null;
    }

    @Override
    public float getCPULoad() {
        if (this.hostMetricValues != null) {
            return this.hostMetricValues.get("cpu.usage").floatValue() / 10000.0f;
        }
        return 0.0f;
    }

    @Override
    public VirtualMachineImageStoreMXBean getVMImageStore() {
        return this.pool.getVMImageStore();
    }

    @Override
    public void configurePerfMonitor(Set<HostMXBean.PerfMetric> metricsOfInterest, long periodMillis) {
        this.stopPerfMonitor();
        if (periodMillis < 20000L) {
            periodMillis = 20000L;
        }
        if (metricsOfInterest.contains((Object)HostMXBean.PerfMetric.VM_CPU_LOAD)) {
            this.currentMonitoringPeriod = periodMillis;
            this.currentMonitoredMetrics = metricsOfInterest;
            this.startPerfMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startPerfMonitor() {
        if (this.perfTimer == null) {
            this.perfTimer = new Timer(true);
            VMwareServiceConnection vMwareServiceConnection = this.defaultConnection;
            synchronized (vMwareServiceConnection) {
                this.perfMon = new VMwarePerfMonitor(this.defaultConnection, this);
            }
            this.perfMon.configure(this.counterNames);
            this.perfTimer.schedule((TimerTask)this.perfMon, 0L, 20000L);
        }
    }

    public synchronized void stopPerfMonitor() {
        if (this.perfTimer != null) {
            this.perfTimer.cancel();
            this.hostMetricValues = null;
            this.metricValuesPerVM = null;
            for (VMwareVirtualMachine vm : this.vmRefs.values()) {
                vm.updateMetrics(null);
            }
            this.perfTimer = null;
        }
    }

    public void updateMetrics(HashMap<String, BigInteger> hM, HashMap<String, HashMap<String, BigInteger>> vmM) {
        this.hostMetricValues = hM;
        this.metricValuesPerVM = vmM;
        HashMap<String, Float> cpuLoads = new HashMap<String, Float>();
        for (VMwareVirtualMachine vm : this.vmRefs.values()) {
            String vmName = vm.getNameLabel();
            if (!vmM.containsKey(vmName)) continue;
            vm.updateMetrics(vmM.get(vmName));
            cpuLoads.put(vmName, Float.valueOf(vm.getCPULoad() / (float)this.getNumCPU()));
        }
        this.emitNotification("host.perfreport", "CPU load", cpuLoads);
    }

    @Override
    public Map<String, Float> getVMCPULoads() {
        HashMap<String, Float> cpuLoads = new HashMap<String, Float>();
        long hostMhz = Long.parseLong(this.getCPUInfo().get("speed"));
        try {
            for (VMwareVirtualMachine vm : this.vmRefs.values()) {
                if (vm.getHostMBean() != this || vm.getState() != VirtualMachineMXBean.PowerState.RUNNING || ((Boolean)this.getDynamicProarray(vm.getRef(), "summary.config.template")[0].getVal()).booleanValue()) continue;
                int loadMhz = (Integer)this.getDynamicProarray(vm.getRef(), "summary.quickStats.overallCpuUsage")[0].getVal();
                float loadPercentage = (float)loadMhz / (float)hostMhz;
                if (loadPercentage > 1.0f) {
                    loadPercentage = 1.0f;
                }
                cpuLoads.put(vm.getNameLabel(), Float.valueOf(loadPercentage));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to retrieve CPU loads", (Throwable)ex);
        }
        return cpuLoads;
    }

    public ManagedObjectReference getVCResourcePool() {
        if (this.myResourcePool == null) {
            try {
                DynamicProperty[] dProps = this.getDynamicProarray(this.mor, "parent");
                ManagedObjectReference computeResource = (ManagedObjectReference)dProps[0].getVal();
                dProps = this.getDynamicProarray(computeResource, "resourcePool");
                this.myResourcePool = (ManagedObjectReference)dProps[0].getVal();
                logger.debug((Object)("Found resourcePool of host " + this.hostName));
            }
            catch (Exception e) {
                logger.error((Object)("Failed to get Resource Pool of host " + this.hostName), (Throwable)e);
            }
        }
        return this.myResourcePool;
    }

    private ManagedObjectReference findVMTemplateMOR(String name) {
        try {
            ArrayOfManagedObjectReference vms = (ArrayOfManagedObjectReference)this.getDynamicProarray(this.mor, "vm")[0].getVal();
            for (ManagedObjectReference vmMor : vms.getManagedObjectReference()) {
                String vmName;
                DynamicProperty[] properties;
                boolean isTemplate = (Boolean)this.getDynamicProarray(vmMor, "summary.config.template")[0].getVal();
                if (!isTemplate || (properties = this.getDynamicProarray(vmMor, "config.name")) == null || properties.length < 1 || !(vmName = (String)properties[0].getVal()).equals(name)) continue;
                return vmMor;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineMXBean createVM(VMConfigSpec vmSpecIn, boolean sync) throws InsufficientResourcesException, InvalidVMConfigException, VMMException {
        final VMConfigSpec vmSpec = new VMConfigSpec(vmSpecIn);
        logger.info((Object)("Creating new VM [name=" + vmSpec.getName() + ",memorySizeMB=" + vmSpec.getMemorySizeMB() + ",diskSize=" + vmSpec.getDiskSizeMB() + ",numVCPU=" + vmSpec.getNumVCPU() + ", ID=" + vmSpec.getVmImageUUID() + "]"));
        if (this.pool.getVMImageStore().lookUpByUUID(vmSpec.getVmImageUUID()) == null) {
            logger.debug((Object)("Invalid VM Image UUID " + vmSpec.getVmImageUUID()));
            throw new InvalidVMConfigException("Invalid VM Image UUID");
        }
        ManagedObjectReference templateVMRef = this.findVMTemplateMOR(vmSpec.getVmImageUUID());
        if (templateVMRef == null) {
            logger.debug((Object)("Template " + vmSpec.getVmImageUUID() + " not found"));
            return null;
        }
        final VMwareServiceConnection connection = this.connectionPool.getConnection();
        if (connection == null) {
            logger.debug((Object)"Out of connection");
            throw new VMMException("Too many VM creation requests, try again later");
        }
        VirtualMachineCloneSpec cloneSpec = new VirtualMachineCloneSpec();
        VirtualMachineRelocateSpec relocSpec = new VirtualMachineRelocateSpec();
        relocSpec.setPool(this.getVCResourcePool());
        relocSpec.setDatastore(this.pool.getDatastoreRef());
        cloneSpec.setLocation(relocSpec);
        cloneSpec.setPowerOn(false);
        cloneSpec.setTemplate(false);
        String clonedName = vmSpec.getName();
        try {
            VMwareServiceConnection vMwareServiceConnection = connection;
            synchronized (vMwareServiceConnection) {
                final ManagedObjectReference cloneTask = connection.getService().cloneVM_Task(templateVMRef, this.pool.getVmFolderRef(), clonedName, cloneSpec);
                if (!sync) {
                    this.pool.getExecutorService().execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                VMwareHost.this.createVM2(vmSpec, connection, cloneTask);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                    return null;
                }
                return this.createVM2(vmSpec, connection, cloneTask);
            }
        }
        catch (Exception e) {
            connection.release();
            if (e instanceof AxisFault) {
                Element[] errors;
                logger.debug((Object)"AxisFault Exception...");
                AxisFault fault = (AxisFault)e;
                Element[] arr$ = errors = fault.getFaultDetails();
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    Element error = arr$[i$];
                    if (error.toString().indexOf("DuplicateName") != -1) {
                        logger.debug((Object)"Virtual Machine with the same name already exists");
                        throw new InvalidVMConfigException("Virtual Machine with the same name already exists");
                    }
                    if (error.toString().indexOf("InvalidArgument") != -1) {
                        logger.debug((Object)"Specification is invalid");
                        throw new InvalidVMConfigException();
                    }
                    if (error.toString().indexOf("InvalidName") != -1) {
                        logger.debug((Object)"Virtual Machine name is empty or too long");
                        throw new InvalidVMConfigException("Virtual Machine name is empty or too long");
                    }
                    if (error.toString().indexOf("RuntimeFault") != -1) {
                        logger.debug((Object)error.toString());
                        throw new VMMException();
                    }
                    logger.debug((Object)error.toString());
                    throw new VMMException();
                }
            } else {
                logger.error((Object)"CloneVMTask Exception...", (Throwable)e);
                throw new VMMException(e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualMachineMXBean createVM2(VMConfigSpec vmSpec, VMwareServiceConnection connection, ManagedObjectReference cloneTask) throws InsufficientResourcesException, InvalidVMConfigException, VMMException {
        VMwareVirtualMachine newVM;
        ManagedObjectReference vmMor = null;
        ObjectName name = null;
        String uuid = null;
        try {
            logger.debug((Object)"CloneVMTask launched, waiting for result...");
            String status = null;
            VMwareServiceConnection vMwareServiceConnection = connection;
            synchronized (vMwareServiceConnection) {
                status = connection.waitForTask(cloneTask);
            }
            logger.debug((Object)("CloneVMTask, status=" + status));
            if (status.equalsIgnoreCase("failure")) {
                String msg = "Failure -: Virtual Machine cannot be cloned";
                logger.error((Object)msg);
                throw new VMMException(msg);
            }
            if (status.equalsIgnoreCase("success")) {
                logger.debug((Object)"Virtual Machine cloned  successfully.");
                vmMor = (ManagedObjectReference)this.getDynamicProarray(cloneTask, "info.result")[0].getVal();
                uuid = VMwareVirtualMachine.getUuid(this.defaultConnection, vmMor);
            }
        }
        catch (Exception e) {
            throw new VMMException(e);
        }
        finally {
            connection.release();
        }
        try {
            name = MBeanObjectNamer.makeVirtualMachineName(this.pool.getPath() + "/" + vmSpec.getName(), uuid);
            newVM = new VMwareVirtualMachine(name, this.pool, vmMor, this, vmSpec.getName());
            this.vmRefs.put(vmSpec.getName(), newVM);
            AgentCommon.getMBeanServer().registerMBean(newVM, name);
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to register new VM MBean " + name), (Throwable)ex);
            return null;
        }
        this.setResourceCapacity(vmMor, vmSpec);
        newVM.start();
        logger.debug((Object)("[Host " + this.hostName + "] VM started"));
        this.emitNotification("vm.add", "Created", name);
        return newVM;
    }

    void onVMDestroy(VMwareVirtualMachine vm) {
        this.vmRefs.remove(vm.getNameLabel());
        this.emitNotification("vm.del", "Destroyed", vm.getObjectName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResourceCapacity(ManagedObjectReference vmMor, VMConfigSpec vmSpec) {
        VirtualMachineConfigSpec vmConfigSpec = new VirtualMachineConfigSpec();
        try {
            vmConfigSpec.setMemoryMB(Long.valueOf(vmSpec.getMemorySizeMB()));
            vmConfigSpec.setNumCPUs(Integer.valueOf(vmSpec.getNumVCPU()));
            VMwareServiceConnection vMwareServiceConnection = this.defaultConnection;
            synchronized (vMwareServiceConnection) {
                ManagedObjectReference tmor = this.defaultConnection.getService().reconfigVM_Task(vmMor, vmConfigSpec);
                String status = this.defaultConnection.waitForTask(tmor);
                if (status.equalsIgnoreCase("failure")) {
                    String msg = "Failure -: Virtual Machine cannot be cloned";
                    logger.error((Object)msg);
                } else {
                    logger.debug((Object)("VM " + vmSpec.getName() + ": Memory capacity set to " + vmSpec.getMemorySizeMB() + "MB, number of CPU set to " + vmSpec.getNumVCPU()));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to set VM memory and numCPU", (Throwable)e);
        }
    }

    private DynamicProperty[] getDynamicProarray(ManagedObjectReference MOR, String pName) throws Exception {
        ObjectContent[] objContent = this.defaultConnection.getObjectProperties(null, MOR, new String[]{pName});
        ObjectContent contentObj = objContent[0];
        DynamicProperty[] objArr = contentObj.getPropSet();
        return objArr;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"vm.state", "vm.add", "vm.del", "vm.error", "log"}, Notification.class.getName(), "Host event")};
    }
}

