/**
 * JASMINe VMMapi: JASMINe Virtual Machine Management API
 * Copyright (C) 2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ManagedResource.java 3973 2009-06-13 00:11:04Z dangtran $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.vmm.agent.domain;

import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;

import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.api.ManagedResourceMXBean;

/**
 * The ManagedResource class implements the ManagedResourceMXBean interfaces and
 * provides operations common to all types of managed resources. This class
 * should be sub-classed by driver-specific resource classes.
 */
public abstract class ManagedResource extends NotificationBroadcasterSupport implements ManagedResourceMXBean {
    static Logger logger = Logger.getLogger(ManagedResource.class);

    protected String path;

    protected ObjectName objectName;

    private long notificationSequence = 0;

    protected ManagedResource(final ObjectName objectName) {
        this.objectName = objectName;
        this.path = objectName.getKeyPropertyList().get("name");
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public String getPath() {
        return this.path;
    }

    synchronized protected void emitNotification(final String type, final String message, final Object userData) {
        this.emitNotification(type, message, userData, System.currentTimeMillis());
    }

    synchronized protected void emitNotification(final String type, final String message, final Object userData,
        final long timeStamp) {
        ManagedResource.logger.debug("Emitting notification [\n\ttype=" + type + "\n\tmsg=" + message + "\n\tsource="
            + this.objectName + "\n\tuserdata=" + userData + "]");
        Notification notification = new Notification(type, this.objectName, this.notificationSequence++, message);
        notification.setUserData(userData);
        notification.setTimeStamp(timeStamp);
        this.sendNotification(notification);
    }

}
