/**
 * JASMINe VMMapi: JASMINe Virtual Machine Management API
 * Copyright (C) 2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: RoomForGrowthVMPlacementPolicy.java 3973 2009-06-13 00:11:04Z dangtran $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.vmm.agent.domain.policy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.ServerPoolMXBean;
import org.ow2.jasmine.vmm.api.VMConfigSpec;

/**
 * RoomForGrowthVMPlacementPolicy is a VM placement policy which attempts to
 * spread virtual machines on the hosts of server pool so as to leave maximmum
 * room for growth
 */
public class RoomForGrowthVMPlacementPolicy implements VMPlacementPolicy {
    static Logger logger = Logger.getLogger(RoomForGrowthVMPlacementPolicy.class);

    public RoomForGrowthVMPlacementPolicy() {
    }

    /*
     * (non-Javadoc)
     * @see
     * org.ow2.jasmine.vmm.agent.domain.policy.VMPlacementPolicy#placeVM(org
     * .ow2.jasmine.vmm.api.ServerPoolMXBean,
     * org.ow2.jasmine.vmm.api.VMConfigSpec)
     */
    public HostMXBean placeVM(final ServerPoolMXBean serverPool, final VMConfigSpec vmSpec) {
        List<HostMXBean> hosts = serverPool.getManagedHosts();

        List<HostMXBean> candidateHostList = new ArrayList<HostMXBean>();
        for (HostMXBean host : hosts) {
            if (host.getFreeMemoryMB() > vmSpec.getMemorySizeMB()) {
                if (host.getVMImageStore().getFreeSpaceMB() > vmSpec.getDiskSizeMB()) {
                    candidateHostList.add(host);
                }
            }
        }
        Collections.sort(candidateHostList, new Comparator<HostMXBean>() {
            public int compare(final HostMXBean h1, final HostMXBean h2) {
                long freeMem1 = h1.getFreeMemoryMB();
                long freeMem2 = h2.getFreeMemoryMB();
                return (int) (freeMem2 - freeMem1);
            }
        });

        for (HostMXBean host : candidateHostList) {
            RoomForGrowthVMPlacementPolicy.logger.debug("\t" + host.getHostName() + " freeMemMB=" + host.getFreeMemoryMB()
                + "MB");
        }

        RoomForGrowthVMPlacementPolicy.logger.debug("Room-for-growth policy selected host: "
            + (candidateHostList.size() > 0 ? candidateHostList.get(0).getHostName() : "none"));
        return candidateHostList.size() > 0 ? candidateHostList.get(0) : null;
    }

}
