/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.vmware;

import com.vmware.vim.ArrayOfManagedObjectReference;
import com.vmware.vim.ArrayOfVirtualDevice;
import com.vmware.vim.ConfigTarget;
import com.vmware.vim.DynamicProperty;
import com.vmware.vim.HostCpuInfo;
import com.vmware.vim.HostCpuPackage;
import com.vmware.vim.HostHardwareInfo;
import com.vmware.vim.ManagedObjectReference;
import com.vmware.vim.ObjectContent;
import com.vmware.vim.VirtualCdrom;
import com.vmware.vim.VirtualCdromIsoBackingInfo;
import com.vmware.vim.VirtualDevice;
import com.vmware.vim.VirtualDeviceBackingInfo;
import com.vmware.vim.VirtualDeviceConfigSpec;
import com.vmware.vim.VirtualDeviceConfigSpecFileOperation;
import com.vmware.vim.VirtualDeviceConfigSpecOperation;
import com.vmware.vim.VirtualDisk;
import com.vmware.vim.VirtualDiskFlatVer2BackingInfo;
import com.vmware.vim.VirtualEthernetCardNetworkBackingInfo;
import com.vmware.vim.VirtualFloppy;
import com.vmware.vim.VirtualFloppyImageBackingInfo;
import com.vmware.vim.VirtualIDEController;
import com.vmware.vim.VirtualLsiLogicController;
import com.vmware.vim.VirtualMachineCloneSpec;
import com.vmware.vim.VirtualMachineConfigOption;
import com.vmware.vim.VirtualMachineConfigSpec;
import com.vmware.vim.VirtualMachineFileInfo;
import com.vmware.vim.VirtualMachineNetworkInfo;
import com.vmware.vim.VirtualMachineRelocateSpec;
import com.vmware.vim.VirtualPCNet32;
import com.vmware.vim.VirtualSCSISharing;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.ObjectName;
import org.apache.axis.AxisFault;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.driver.util.RemoteExec;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwarePerfMonitor;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareServerPool;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareServiceConnection;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareVirtualMachine;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.InsufficientResourcesException;
import org.ow2.jasmine.vmm.api.InvalidVMConfigException;
import org.ow2.jasmine.vmm.api.ServerPoolMXBean;
import org.ow2.jasmine.vmm.api.VMConfigSpec;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineImageMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;
import org.ow2.jasmine.vmm.api.VnicIPSettings;
import org.w3c.dom.Element;

class VMwareHost
extends ManagedResource
implements HostMXBean {
    static Logger logger = Logger.getLogger(VMwareHost.class);
    private VMwareServerPool pool;
    private VMwareServerPool.ConnectionPool connectionPool;
    private String hostName;
    private int numCPU = -1;
    private ManagedObjectReference mor;
    private HashMap<String, VMwareVirtualMachine> vmRefs = new HashMap();
    private VMwarePerfMonitor perfMon = null;
    private HashMap<String, BigInteger> hostMetricValues = null;
    private HashMap<String, HashMap<String, BigInteger>> metricValuesPerVM = null;
    private String[][] counterNames = null;
    private ManagedObjectReference myResourcePool;
    private String defaultNetworkName;
    private VirtualDevice[] hostDefaultDevices;
    private RemoteExec.SshAuthInfo authInfo;
    HashMap<String, String> hypervisorInfo = null;
    HashMap<String, String> cpuInfo = null;
    private Timer perfTimer = null;
    private Set<HostMXBean.PerfMetric> currentMonitoredMetrics;
    private long currentMonitoringPeriod;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VMwareHost(VMwareServerPool pool, ManagedObjectReference mor, ObjectName objectName, String hostName, RemoteExec.SshAuthInfo authInfo) {
        super(objectName);
        this.pool = pool;
        this.connectionPool = pool.getConnectionPool();
        this.mor = mor;
        this.objectName = objectName;
        this.hostName = hostName;
        this.authInfo = authInfo;
        this.counterNames = new String[][]{{"cpu", "usage", "average"}, {"mem", "usage", "average"}, {"mem", "active", "average"}, {"mem", "granted", "average"}, {"mem", "state", "latest"}, {"disk", "usage", "average"}, {"net", "transmitted", "average"}, {"net", "received", "average"}, {"sys", "uptime", "latest"}};
        VMwareServiceConnection connection = this.connectionPool.getConnection();
        try {
            VirtualMachineConfigOption vmConfigOption = null;
            ConfigTarget configTarget = null;
            ManagedObjectReference hostParentCompResRef = (ManagedObjectReference)this.getDynamicProarray(connection, mor, "parent")[0].getVal();
            ManagedObjectReference envBrowseMor = (ManagedObjectReference)this.getDynamicProarray(connection, hostParentCompResRef, "environmentBrowser")[0].getVal();
            vmConfigOption = connection.getService().queryConfigOption(envBrowseMor, null, mor);
            configTarget = connection.getService().queryConfigTarget(envBrowseMor, mor);
            if (configTarget.getNetwork() != null) {
                for (VirtualMachineNetworkInfo netInfo : configTarget.getNetwork()) {
                    if (!netInfo.getNetwork().isAccessible()) continue;
                    this.defaultNetworkName = netInfo.getNetwork().getName();
                    logger.debug((Object)("Default network for host " + hostName + ": " + this.defaultNetworkName));
                    break;
                }
            }
            if (vmConfigOption != null) {
                this.hostDefaultDevices = vmConfigOption.getDefaultDevice();
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to retrieve host " + hostName + " network name and device set"), (Throwable)ex);
        }
        finally {
            connection.release();
        }
    }

    public ManagedObjectReference getMOR() {
        return this.mor;
    }

    public ServerPoolMXBean getServerPool() {
        return this.pool;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public VMwareServerPool.ConnectionPool getConnectionPool() {
        return this.pool.getConnectionPool();
    }

    public Map<String, String> getHypervisorInfo() {
        if (this.hypervisorInfo == null) {
            this.hypervisorInfo = new HashMap();
            this.hypervisorInfo.put("name", "ESX");
            this.hypervisorInfo.put("vendor", "VMware");
            this.hypervisorInfo.put("version", "3.0.2");
        }
        return this.hypervisorInfo;
    }

    public int getNumCPU() {
        if (this.numCPU == -1) {
            this.getCPUInfo();
        }
        return this.numCPU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getCPUInfo() {
        if (this.cpuInfo == null) {
            this.cpuInfo = new HashMap();
            VMwareServiceConnection connection = this.connectionPool.getConnection();
            try {
                DynamicProperty[] cpuArry = this.getDynamicProarray(connection, this.mor, "hardware");
                HostHardwareInfo hinfo = (HostHardwareInfo)cpuArry[0].getVal();
                HostCpuInfo tinfo = hinfo.getCpuInfo();
                HostCpuPackage cinfo = hinfo.getCpuPkg(0);
                this.cpuInfo.put("speed", Long.toString(tinfo.getHz() / 1000000L));
                this.numCPU = tinfo.getNumCpuCores();
                this.cpuInfo.put("vendor", cinfo.getVendor());
            }
            catch (Exception ex) {
                logger.debug((Object)("Host " + this.hostName), (Throwable)ex);
            }
            finally {
                connection.release();
            }
        }
        return this.cpuInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VMwareVirtualMachine addVm(ManagedObjectReference vmRef, String vmName) {
        VMwareServiceConnection connection = this.connectionPool.getConnection();
        try {
            ObjectName vmMBeanObjectName = MBeanObjectNamer.makeVirtualMachineName(this.pool.getPath() + "/" + vmName, VMwareVirtualMachine.getUuid(connection, vmRef));
            VMwareVirtualMachine vm = new VMwareVirtualMachine(vmMBeanObjectName, this.pool, vmRef, this, vmName);
            AgentCommon.getMBeanServer().registerMBean(vm, vmMBeanObjectName);
            this.vmRefs.put(vmName, vm);
            logger.info((Object)("Added VirtualMachine " + vmName + " " + vmMBeanObjectName));
            VMwareVirtualMachine vMwareVirtualMachine = vm;
            return vMwareVirtualMachine;
        }
        catch (Exception ex) {
            logger.error((Object)"addVm", (Throwable)ex);
            VMwareVirtualMachine vMwareVirtualMachine = null;
            return vMwareVirtualMachine;
        }
        finally {
            connection.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VirtualMachineMXBean> getResidentVMs() {
        ArrayList<VirtualMachineMXBean> result = new ArrayList<VirtualMachineMXBean>();
        VMwareServiceConnection connection = this.connectionPool.getConnection();
        try {
            ArrayOfManagedObjectReference vms = (ArrayOfManagedObjectReference)this.getDynamicProarray(connection, this.mor, "vm")[0].getVal();
            for (ManagedObjectReference vmMor : vms.getManagedObjectReference()) {
                DynamicProperty[] properties;
                boolean isTemplate = (Boolean)this.getDynamicProarray(connection, vmMor, "summary.config.template")[0].getVal();
                if (isTemplate || (properties = this.getDynamicProarray(connection, vmMor, "config.name")) == null || properties.length < 1) continue;
                String vmName = (String)properties[0].getVal();
                VMwareVirtualMachine vm = this.vmRefs.get(vmName);
                if (vm == null) {
                    vm = this.addVm(vmMor, vmName);
                }
                result.add(vm);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to retrieve resident VM of host " + this.hostName), (Throwable)ex);
        }
        finally {
            connection.release();
        }
        return result;
    }

    synchronized void onPowerStateChangedVM(ManagedObjectReference vmRef, String vmName, VirtualMachineMXBean.PowerState state, long time) {
        VMwareVirtualMachine vm = this.vmRefs.get(vmName);
        if (vm != null) {
            vm.onPowerStateChangedVM(state, time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalMemoryMB() {
        long total = 0L;
        VMwareServiceConnection connection = this.connectionPool.getConnection();
        try {
            DynamicProperty[] cpuArry = this.getDynamicProarray(connection, this.mor, "hardware");
            total = ((HostHardwareInfo)cpuArry[0].getVal()).getMemorySize();
        }
        catch (Exception ex) {
            logger.debug((Object)("Host " + this.hostName), (Throwable)ex);
        }
        finally {
            connection.release();
        }
        return total / 0x100000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFreeMemoryMB() {
        if (this.hostMetricValues != null) {
            return this.hostMetricValues.get("mem.granted").longValue();
        }
        VMwareServiceConnection connection = this.connectionPool.getConnection();
        try {
            int overallMemoryUsage = (Integer)this.getDynamicProarray(connection, this.mor, "summary.quickStats.overallMemoryUsage")[0].getVal();
            long l = this.getTotalMemoryMB() - (long)overallMemoryUsage;
            return l;
        }
        catch (Exception ex) {
            logger.error((Object)"Cannot retrieve attribute summary.quickStats.overallMemoryUsage", (Throwable)ex);
            long l = -1L;
            return l;
        }
        finally {
            connection.release();
        }
    }

    public float[] getLoadPerCPU() {
        logger.info((Object)"[VMWareHost.getLoadPerCPU] : Not Implemented");
        return null;
    }

    public float getCPULoad() {
        if (this.hostMetricValues != null) {
            return this.hostMetricValues.get("cpu.usage").floatValue() / 10000.0f;
        }
        return 0.0f;
    }

    public VirtualMachineImageStoreMXBean getVMImageStore() {
        return this.pool.getVMImageStore();
    }

    public void configurePerfMonitor(Set<HostMXBean.PerfMetric> metricsOfInterest, long periodMillis) {
        this.stopPerfMonitor();
        if (periodMillis < 20000L) {
            periodMillis = 20000L;
        }
        if (metricsOfInterest.contains(HostMXBean.PerfMetric.VM_CPU_LOAD)) {
            this.currentMonitoringPeriod = periodMillis;
            this.currentMonitoredMetrics = metricsOfInterest;
            this.startPerfMonitor();
        }
    }

    public synchronized void startPerfMonitor() {
        if (this.perfTimer == null) {
            this.perfTimer = new Timer(true);
            this.perfMon = new VMwarePerfMonitor(this.connectionPool, this);
            this.perfMon.configure(this.counterNames);
            this.perfTimer.schedule((TimerTask)this.perfMon, 0L, 20000L);
        }
    }

    public synchronized void stopPerfMonitor() {
        if (this.perfTimer != null) {
            this.perfTimer.cancel();
            this.hostMetricValues = null;
            this.metricValuesPerVM = null;
            for (VMwareVirtualMachine vm : this.vmRefs.values()) {
                vm.updateMetrics(null);
            }
            this.perfTimer = null;
        }
    }

    public void updateMetrics(HashMap<String, BigInteger> hM, HashMap<String, HashMap<String, BigInteger>> vmM) {
        this.hostMetricValues = hM;
        this.metricValuesPerVM = vmM;
        HashMap<String, Float> cpuLoads = new HashMap<String, Float>();
        for (VMwareVirtualMachine vm : this.vmRefs.values()) {
            String vmName = vm.getNameLabel();
            if (!vmM.containsKey(vmName)) continue;
            vm.updateMetrics(vmM.get(vmName));
            cpuLoads.put(vmName, Float.valueOf(vm.getCPULoad() / (float)this.getNumCPU()));
        }
        this.emitNotification("host.perfreport", "CPU load", cpuLoads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Float> getVMCPULoads() {
        HashMap<String, Float> cpuLoads = new HashMap<String, Float>();
        long hostMhz = Long.parseLong(this.getCPUInfo().get("speed"));
        VMwareServiceConnection connection = this.connectionPool.getConnection();
        try {
            for (VMwareVirtualMachine vm : this.vmRefs.values()) {
                if (vm.getHostMBean() != this || vm.getState() != VirtualMachineMXBean.PowerState.RUNNING || ((Boolean)this.getDynamicProarray(connection, vm.getRef(), "summary.config.template")[0].getVal()).booleanValue()) continue;
                int loadMhz = (Integer)this.getDynamicProarray(connection, vm.getRef(), "summary.quickStats.overallCpuUsage")[0].getVal();
                float loadPercentage = (float)loadMhz / (float)hostMhz;
                if (loadPercentage > 1.0f) {
                    loadPercentage = 1.0f;
                }
                cpuLoads.put(vm.getNameLabel(), Float.valueOf(loadPercentage));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to retrieve CPU loads", (Throwable)ex);
        }
        finally {
            connection.release();
        }
        return cpuLoads;
    }

    public ManagedObjectReference getVCResourcePool(VMwareServiceConnection connection) {
        if (this.myResourcePool == null) {
            try {
                DynamicProperty[] dProps = this.getDynamicProarray(connection, this.mor, "parent");
                ManagedObjectReference computeResource = (ManagedObjectReference)dProps[0].getVal();
                dProps = this.getDynamicProarray(connection, computeResource, "resourcePool");
                this.myResourcePool = (ManagedObjectReference)dProps[0].getVal();
                logger.debug((Object)("Found resourcePool of host " + this.hostName));
            }
            catch (Exception e) {
                logger.error((Object)("Failed to get Resource Pool of host " + this.hostName), (Throwable)e);
            }
        }
        return this.myResourcePool;
    }

    private ManagedObjectReference findVMTemplateMOR(VMwareServiceConnection connection, String name) {
        try {
            ArrayList vms = connection.getDecendentMoRefs(((VMwareServerPool)this.getServerPool()).getVmTemplateFolderRef(), "VirtualMachine");
            for (ManagedObjectReference vmMor : vms) {
                DynamicProperty[] properties = this.getDynamicProarray(connection, vmMor, "config.name");
                if (properties == null || properties.length < 1) continue;
                String vmName = (String)properties[0].getVal();
                logger.debug((Object)("vmName=" + vmName));
                if (!vmName.equals(name)) continue;
                return vmMor;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualMachineMXBean createVMFromISO(VMConfigSpec vmSpec, VMwareServerPool.VMwareVirtualMachineISOTemplate image, boolean sync) throws InsufficientResourcesException, InvalidVMConfigException, VMMException {
        VMwareVirtualMachine newVM;
        String uuid;
        Object dnsServer2;
        VnicIPSettings guestIPSettings;
        String sshPublicKey;
        logger.debug((Object)("createVMFromISO: name=" + vmSpec.getName()));
        VMwareServiceConnection connection = this.connectionPool.getConnection();
        if (connection == null) {
            logger.debug((Object)"Out of connection");
            throw new VMMException("Too many VM creation requests, try again later");
        }
        String dataStoreVolume = "[" + this.pool.getDatastoreName() + "]";
        String floppyImagePathName = null;
        ManagedObjectReference vmMor = null;
        StringBuffer command = new StringBuffer(image.getMakeFloppyShellScript());
        command.append(" -diskMB " + vmSpec.getDiskSizeMB());
        if (vmSpec.getGuestOsCustomizationParams() != null && (sshPublicKey = (String)vmSpec.getGuestOsCustomizationParams().get("sshPublicKey")) != null) {
            command.append(" -key \"" + sshPublicKey + "\"");
        }
        if ((guestIPSettings = (VnicIPSettings)vmSpec.getVnicIpSettingsList().get(0)) != null) {
            if (guestIPSettings.getIpAssignmentMode() == VnicIPSettings.IpAssignmentMode.FIXED) {
                command.append(" -ip " + guestIPSettings.getIpAddress());
                command.append(" -domain " + vmSpec.getGuestOsDomain());
                command.append(" -gateway " + guestIPSettings.getGateway());
                command.append(" -hostname " + vmSpec.getGuestOsHostName());
                command.append(" -subnetmask " + guestIPSettings.getSubnetMask());
                if (vmSpec.getGuestOsDnsServerList() != null) {
                    for (Object dnsServer2 : vmSpec.getGuestOsDnsServerList()) {
                        command.append(" -dnsserver " + (String)dnsServer2);
                    }
                }
            } else if (guestIPSettings.getIpAssignmentMode() == VnicIPSettings.IpAssignmentMode.DHCP) {
                command.append(" -dhcp");
            }
        }
        logger.debug((Object)("Launching makeKickStartFloppy script:\n" + command));
        try {
            RemoteExec.Result result = RemoteExec.commandAsRoot(this.getHostName(), this.authInfo, command.toString());
            if (result.exitCode != 0) {
                logger.error((Object)("Failed to create kickstart floppy " + result.error));
                throw new VMMException("Kickstart floppy creation failure " + result.error);
            }
            floppyImagePathName = result.output;
            logger.debug((Object)("Kickstart floppy image file: " + floppyImagePathName));
        }
        catch (Exception ex) {
            logger.error((Object)"SSH connection failure", (Throwable)ex);
            throw new VMMException("SS connection failure", (Throwable)ex);
        }
        String networkName = (String)vmSpec.getGuestOsCustomizationParams().get("networkName");
        if (networkName == null) {
            networkName = this.defaultNetworkName;
        }
        dnsServer2 = connection;
        synchronized (dnsServer2) {
            try {
                VirtualMachineConfigSpec vmConfigSpec = new VirtualMachineConfigSpec();
                VirtualMachineFileInfo fileInfo = new VirtualMachineFileInfo();
                fileInfo.setVmPathName(dataStoreVolume);
                VirtualDevice ideCtlr = null;
                for (VirtualDevice vd : this.hostDefaultDevices) {
                    if (!(vd instanceof VirtualIDEController)) continue;
                    ideCtlr = vd;
                    break;
                }
                if (ideCtlr == null) {
                    logger.error((Object)"Cannot find IDE controller");
                    throw new VMMException("Unable to retrieve IDE controller");
                }
                int diskCtlrKey = 1;
                VirtualDeviceConfigSpec scsiDeviceSpec = new VirtualDeviceConfigSpec();
                scsiDeviceSpec.setOperation(VirtualDeviceConfigSpecOperation.add);
                VirtualLsiLogicController scsiCtrl = new VirtualLsiLogicController();
                scsiCtrl.setKey(diskCtlrKey);
                scsiCtrl.setBusNumber(0);
                scsiCtrl.setSharedBus(VirtualSCSISharing.noSharing);
                scsiDeviceSpec.setDevice((VirtualDevice)scsiCtrl);
                VirtualDeviceConfigSpec diskSpec = new VirtualDeviceConfigSpec();
                diskSpec.setFileOperation(VirtualDeviceConfigSpecFileOperation.create);
                diskSpec.setOperation(VirtualDeviceConfigSpecOperation.add);
                VirtualDisk disk = new VirtualDisk();
                VirtualDiskFlatVer2BackingInfo diskfileBacking = new VirtualDiskFlatVer2BackingInfo();
                diskfileBacking.setFileName(dataStoreVolume);
                diskfileBacking.setDiskMode("persistent");
                disk.setKey(0);
                disk.setControllerKey(Integer.valueOf(diskCtlrKey));
                disk.setUnitNumber(Integer.valueOf(0));
                disk.setBacking((VirtualDeviceBackingInfo)diskfileBacking);
                disk.setCapacityInKB((long)(vmSpec.getDiskSizeMB() * 1024));
                diskSpec.setDevice((VirtualDevice)disk);
                VirtualDeviceConfigSpec cdromDeviceSpec = new VirtualDeviceConfigSpec();
                cdromDeviceSpec.setOperation(VirtualDeviceConfigSpecOperation.add);
                VirtualCdrom virtualCdrom = new VirtualCdrom();
                VirtualCdromIsoBackingInfo cdromBacking = new VirtualCdromIsoBackingInfo();
                cdromBacking.setDatastore(this.pool.getDatastoreRef());
                cdromBacking.setFileName(dataStoreVolume + image.getIsoFileName());
                virtualCdrom.setBacking((VirtualDeviceBackingInfo)cdromBacking);
                virtualCdrom.setUnitNumber(Integer.valueOf(0));
                virtualCdrom.setControllerKey(Integer.valueOf(ideCtlr.getKey()));
                cdromDeviceSpec.setDevice((VirtualDevice)virtualCdrom);
                VirtualDeviceConfigSpec floppySpec = new VirtualDeviceConfigSpec();
                floppySpec.setOperation(VirtualDeviceConfigSpecOperation.add);
                VirtualFloppy floppy = new VirtualFloppy();
                VirtualFloppyImageBackingInfo flpBacking = new VirtualFloppyImageBackingInfo();
                flpBacking.setFileName(dataStoreVolume + floppyImagePathName);
                floppy.setBacking((VirtualDeviceBackingInfo)flpBacking);
                floppy.setKey(3);
                floppySpec.setDevice((VirtualDevice)floppy);
                VirtualDeviceConfigSpec nicSpec = new VirtualDeviceConfigSpec();
                nicSpec.setOperation(VirtualDeviceConfigSpecOperation.add);
                VirtualPCNet32 nic = new VirtualPCNet32();
                VirtualEthernetCardNetworkBackingInfo nicBacking = new VirtualEthernetCardNetworkBackingInfo();
                logger.debug((Object)("Setting VM network to " + networkName));
                nicBacking.setDeviceName(networkName);
                nic.setBacking((VirtualDeviceBackingInfo)nicBacking);
                nic.setAddressType("generated");
                nic.setKey(4);
                nicSpec.setDevice((VirtualDevice)nic);
                VirtualDeviceConfigSpec[] deviceConfigSpecs = new VirtualDeviceConfigSpec[]{scsiDeviceSpec, floppySpec, diskSpec, cdromDeviceSpec, nicSpec};
                vmConfigSpec.setDeviceChange(deviceConfigSpecs);
                vmConfigSpec.setMemoryMB(Long.valueOf(vmSpec.getMemorySizeMB()));
                vmConfigSpec.setName(vmSpec.getName());
                vmConfigSpec.setNumCPUs(Integer.valueOf(vmSpec.getNumVCPU()));
                vmConfigSpec.setFiles(fileInfo);
                vmConfigSpec.setGuestId(image.getGuestId());
                logger.debug((Object)"Creating VM...");
                String status = null;
                ManagedObjectReference task = null;
                try {
                    task = connection.getService().createVM_Task(this.pool.getVmFolderRef(), vmConfigSpec, this.getVCResourcePool(connection), this.mor);
                    status = connection.waitForTask(task);
                }
                catch (Exception ex) {
                    logger.error((Object)"CreateVM failure", (Throwable)ex);
                    throw new VMMException("VM creation failure");
                }
                logger.debug((Object)("Status=" + status));
                if (status.equalsIgnoreCase("failure")) {
                    logger.error((Object)"CreateVM failure");
                    throw new VMMException("VM creation failure");
                }
                try {
                    vmMor = (ManagedObjectReference)this.getDynamicProarray(connection, task, "info.result")[0].getVal();
                    uuid = VMwareVirtualMachine.getUuid(connection, vmMor);
                }
                catch (Exception ex) {
                    logger.error((Object)"Cannot retrieve VM MOR");
                    throw new VMMException("VM creation failure");
                }
                logger.debug((Object)"Powering on VM...");
                try {
                    task = connection.getService().powerOnVM_Task(vmMor, null);
                    status = connection.waitForTask(task);
                }
                catch (Exception ex) {
                    logger.error((Object)"PowerOnVM failure");
                    throw new VMMException("VM creation failure");
                }
                if (status.equalsIgnoreCase("failure")) {
                    logger.error((Object)"PowerOnVM failure");
                    throw new VMMException("VM creation failure");
                }
                logger.debug((Object)"Waiting 5 minutes to allow the guest OS to kickstart...");
                try {
                    Thread.sleep(300000L);
                    logger.debug((Object)"Getting IP address...");
                    int tryNumber = 50;
                    String ipAddress = null;
                    while (tryNumber-- > 0) {
                        DynamicProperty[] props = this.getDynamicProarray(connection, vmMor, "guest.ipAddress");
                        if (props != null && props.length > 0) {
                            ipAddress = (String)props[0].getVal();
                            logger.debug((Object)("IP address of VM is " + ipAddress));
                            break;
                        }
                        Thread.sleep(20000L);
                        logger.debug((Object)"Waiting for IP address");
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to retrieve IP address", (Throwable)ex);
                }
                logger.debug((Object)"Powering off VM in order to remove Cdrom & floppy devices...");
                try {
                    task = connection.getService().powerOffVM_Task(vmMor);
                    status = connection.waitForTask(task);
                    if (status.equalsIgnoreCase("failure")) {
                        logger.error((Object)"PowerOffVM failure");
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to power off VM", (Throwable)ex);
                }
                virtualCdrom = null;
                floppy = null;
                try {
                    VirtualDevice[] devices;
                    for (VirtualDevice device : devices = ((ArrayOfVirtualDevice)this.getDynamicProarray(connection, vmMor, "config.hardware.device")[0].getVal()).getVirtualDevice()) {
                        if (device instanceof VirtualCdrom) {
                            virtualCdrom = (VirtualCdrom)device;
                            logger.debug((Object)"Found Cdrom device");
                            continue;
                        }
                        if (!(device instanceof VirtualFloppy)) continue;
                        floppy = (VirtualFloppy)device;
                        logger.debug((Object)"Found floppy device");
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to retrieve VM CDROM and floppy devices", (Throwable)ex);
                }
                vmConfigSpec = new VirtualMachineConfigSpec();
                deviceConfigSpecs = new VirtualDeviceConfigSpec[2];
                deviceConfigSpecs[0] = new VirtualDeviceConfigSpec();
                deviceConfigSpecs[0].setOperation(VirtualDeviceConfigSpecOperation.remove);
                deviceConfigSpecs[0].setDevice((VirtualDevice)virtualCdrom);
                deviceConfigSpecs[1] = new VirtualDeviceConfigSpec();
                deviceConfigSpecs[1].setOperation(VirtualDeviceConfigSpecOperation.remove);
                deviceConfigSpecs[1].setDevice((VirtualDevice)floppy);
                vmConfigSpec.setDeviceChange(deviceConfigSpecs);
                logger.debug((Object)"Reconfiguring VM...");
                try {
                    task = connection.getService().reconfigVM_Task(vmMor, vmConfigSpec);
                    status = connection.waitForTask(task);
                    if (status.equalsIgnoreCase("failure")) {
                        logger.error((Object)"ReconfigureVM failure");
                    }
                    logger.debug((Object)"Done");
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to reconfigure VM", (Throwable)ex);
                }
                logger.debug((Object)"Powering on VM...");
                try {
                    task = connection.getService().powerOnVM_Task(vmMor, null);
                    status = connection.waitForTask(task);
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to power off VM", (Throwable)ex);
                    throw new VMMException("Cannot power on VM", (Throwable)ex);
                }
                if (status.equalsIgnoreCase("failure")) {
                    logger.error((Object)"PowerOnVM failure");
                    throw new VMMException("Cannot power on VM");
                }
                logger.debug((Object)"VM ready");
            }
            finally {
                connection.release();
            }
        }
        ObjectName name = null;
        try {
            name = MBeanObjectNamer.makeVirtualMachineName(this.pool.getPath() + "/" + vmSpec.getName(), uuid);
            newVM = new VMwareVirtualMachine(name, this.pool, vmMor, this, vmSpec.getName());
            this.vmRefs.put(vmSpec.getName(), newVM);
            AgentCommon.getMBeanServer().registerMBean(newVM, name);
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to register new VM MBean " + name), (Throwable)ex);
            return null;
        }
        this.emitNotification("vm.add", "Created", name);
        return newVM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualMachineMXBean createVM(VMConfigSpec vmSpecIn, boolean sync) throws InsufficientResourcesException, InvalidVMConfigException, VMMException {
        final VMConfigSpec vmSpec = new VMConfigSpec(vmSpecIn);
        logger.info((Object)("Creating new VM [name=" + vmSpec.getName() + ",memorySizeMB=" + vmSpec.getMemorySizeMB() + ",diskSize=" + vmSpec.getDiskSizeMB() + ",numVCPU=" + vmSpec.getNumVCPU() + ", ID=" + vmSpec.getVmImageUUID() + "]"));
        VirtualMachineImageMXBean image = null;
        image = this.pool.getVMImageStore().lookUpByUUID(vmSpec.getVmImageUUID());
        if (image == null) {
            logger.debug((Object)("Invalid VM Image UUID " + vmSpec.getVmImageUUID()));
            throw new InvalidVMConfigException("Invalid VM Image UUID");
        }
        if (image instanceof VMwareServerPool.VMwareVirtualMachineISOTemplate) {
            return this.createVMFromISO(vmSpec, (VMwareServerPool.VMwareVirtualMachineISOTemplate)image, sync);
        }
        final VMwareServiceConnection connection = this.connectionPool.getConnection();
        if (connection == null) {
            logger.debug((Object)"Out of connection");
            throw new VMMException("Too many VM creation requests, try again later");
        }
        ManagedObjectReference templateVMRef = this.findVMTemplateMOR(connection, vmSpec.getVmImageUUID());
        if (templateVMRef == null) {
            logger.debug((Object)("Template " + vmSpec.getVmImageUUID() + " not found"));
            return null;
        }
        try {
            VirtualMachineCloneSpec cloneSpec = new VirtualMachineCloneSpec();
            VirtualMachineRelocateSpec relocSpec = new VirtualMachineRelocateSpec();
            relocSpec.setPool(this.getVCResourcePool(connection));
            relocSpec.setDatastore(this.pool.getDatastoreRef());
            cloneSpec.setLocation(relocSpec);
            cloneSpec.setPowerOn(false);
            cloneSpec.setTemplate(false);
            String clonedName = vmSpec.getName();
            VMwareServiceConnection vMwareServiceConnection = connection;
            synchronized (vMwareServiceConnection) {
                final ManagedObjectReference cloneTask = connection.getService().cloneVM_Task(templateVMRef, this.pool.getVmFolderRef(), clonedName, cloneSpec);
                if (!sync) {
                    this.pool.getExecutorService().execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                VMwareHost.this.createVM2(vmSpec, connection, cloneTask);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                    return null;
                }
                return this.createVM2(vmSpec, connection, cloneTask);
            }
        }
        catch (Exception e) {
            connection.release();
            if (e instanceof AxisFault) {
                Element[] errors;
                logger.debug((Object)"AxisFault Exception...");
                AxisFault fault = (AxisFault)e;
                Element[] arr$ = errors = fault.getFaultDetails();
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    Element error = arr$[i$];
                    if (error.toString().indexOf("DuplicateName") != -1) {
                        logger.debug((Object)"Virtual Machine with the same name already exists");
                        throw new InvalidVMConfigException("Virtual Machine with the same name already exists");
                    }
                    if (error.toString().indexOf("InvalidArgument") != -1) {
                        logger.debug((Object)"Specification is invalid");
                        throw new InvalidVMConfigException();
                    }
                    if (error.toString().indexOf("InvalidName") != -1) {
                        logger.debug((Object)"Virtual Machine name is empty or too long");
                        throw new InvalidVMConfigException("Virtual Machine name is empty or too long");
                    }
                    if (error.toString().indexOf("RuntimeFault") != -1) {
                        logger.debug((Object)error.toString());
                        throw new VMMException();
                    }
                    logger.debug((Object)error.toString());
                    throw new VMMException();
                }
            } else {
                logger.error((Object)"CloneVMTask Exception...", (Throwable)e);
                throw new VMMException((Throwable)e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualMachineMXBean createVM2(VMConfigSpec vmSpec, VMwareServiceConnection connection, ManagedObjectReference cloneTask) throws InsufficientResourcesException, InvalidVMConfigException, VMMException {
        VMwareVirtualMachine newVM;
        ManagedObjectReference vmMor = null;
        ObjectName name = null;
        String uuid = null;
        try {
            logger.debug((Object)"CloneVMTask launched, waiting for result...");
            String status = null;
            VMwareServiceConnection vMwareServiceConnection = connection;
            synchronized (vMwareServiceConnection) {
                status = connection.waitForTask(cloneTask);
            }
            logger.debug((Object)("CloneVMTask, status=" + status));
            if (status.equalsIgnoreCase("failure")) {
                String msg = "Failure -: Virtual Machine cannot be cloned";
                logger.error((Object)msg);
                throw new VMMException(msg);
            }
            if (status.equalsIgnoreCase("success")) {
                logger.debug((Object)"Virtual Machine cloned  successfully.");
                vmMor = (ManagedObjectReference)this.getDynamicProarray(connection, cloneTask, "info.result")[0].getVal();
                uuid = VMwareVirtualMachine.getUuid(connection, vmMor);
            }
            this.setResourceCapacity(connection, vmMor, vmSpec);
        }
        catch (Exception e) {
            throw new VMMException((Throwable)e);
        }
        finally {
            connection.release();
        }
        try {
            name = MBeanObjectNamer.makeVirtualMachineName(this.pool.getPath() + "/" + vmSpec.getName(), uuid);
            newVM = new VMwareVirtualMachine(name, this.pool, vmMor, this, vmSpec.getName());
            this.vmRefs.put(vmSpec.getName(), newVM);
            AgentCommon.getMBeanServer().registerMBean(newVM, name);
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to register new VM MBean " + name), (Throwable)ex);
            return null;
        }
        newVM.start();
        logger.debug((Object)("[Host " + this.hostName + "] VM started"));
        this.emitNotification("vm.add", "Created", name);
        return newVM;
    }

    void onVMDestroy(VMwareVirtualMachine vm) {
        this.vmRefs.remove(vm.getNameLabel());
        this.emitNotification("vm.del", "Destroyed", vm.getObjectName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResourceCapacity(VMwareServiceConnection connection, ManagedObjectReference vmMor, VMConfigSpec vmSpec) {
        VirtualMachineConfigSpec vmConfigSpec = new VirtualMachineConfigSpec();
        try {
            vmConfigSpec.setMemoryMB(Long.valueOf(vmSpec.getMemorySizeMB()));
            vmConfigSpec.setNumCPUs(Integer.valueOf(vmSpec.getNumVCPU()));
            VMwareServiceConnection vMwareServiceConnection = connection;
            synchronized (vMwareServiceConnection) {
                ManagedObjectReference tmor = connection.getService().reconfigVM_Task(vmMor, vmConfigSpec);
                String status = connection.waitForTask(tmor);
                if (status.equalsIgnoreCase("failure")) {
                    String msg = "Failure -: Virtual Machine cannot be cloned";
                    logger.error((Object)msg);
                } else {
                    logger.debug((Object)("VM " + vmSpec.getName() + ": Memory capacity set to " + vmSpec.getMemorySizeMB() + "MB, number of CPU set to " + vmSpec.getNumVCPU()));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to set VM memory and numCPU", (Throwable)e);
        }
    }

    private DynamicProperty[] getDynamicProarray(VMwareServiceConnection connection, ManagedObjectReference MOR, String pName) throws Exception {
        ObjectContent[] objContent = connection.getObjectProperties(null, MOR, new String[]{pName});
        ObjectContent contentObj = objContent[0];
        DynamicProperty[] objArr = contentObj.getPropSet();
        return objArr;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"vm.state", "vm.add", "vm.del", "vm.error", "log"}, Notification.class.getName(), "Host event")};
    }
}

