/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.xen;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.VIF;
import com.xensource.xenapi.VM;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.driver.util.RemoteExec;
import org.ow2.jasmine.vmm.agent.driver.xen.XenHost;
import org.ow2.jasmine.vmm.agent.driver.xen.XenSSH;
import org.ow2.jasmine.vmm.agent.driver.xen.XenVMImageStore;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.IllegalOperationException;
import org.ow2.jasmine.vmm.api.InsufficientResourcesException;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;

public class XenVirtualMachine
extends ManagedResource
implements VirtualMachineMXBean {
    static Logger logger = Logger.getLogger(XenVirtualMachine.class);
    private XenHost host;
    private Connection connection;
    private VM vm;
    private String uuid;
    private String name;
    private int domID;
    private String ipAddress;
    private String macAddress;
    private String imageID;
    private Date startTime;
    private float cpuConsumption = 0.0f;
    private VirtualMachineMXBean.PowerState cachedPowerState;
    private long lastCPULoadTime = 0L;
    private float lastCPULoad;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XenVirtualMachine(ObjectName objectName, XenHost host, Connection connection, VM vm, Map<String, String> userData) {
        super(objectName);
        try {
            this.host = host;
            this.connection = connection;
            this.vm = vm;
            Connection connection2 = connection;
            synchronized (connection2) {
                this.uuid = vm.getUuid(connection);
                this.name = vm.getNameLabel(connection);
                this.domID = vm.getDomid(connection).intValue();
                if (userData != null) {
                    for (String key : userData.keySet()) {
                        this.addUserData(key, userData.get(key));
                    }
                    this.imageID = userData.get("imageID");
                }
                if (this.imageID == null) {
                    this.imageID = this.getUserData("imageID");
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Failedto init VM", (Throwable)ex);
        }
    }

    public boolean canLiveMigrateToHost(HostMXBean targetHost) {
        XenHost xenHost = null;
        for (HostMXBean h : this.host.getServerPool().getManagedHosts()) {
            if (!h.getObjectName().equals(targetHost.getObjectName())) continue;
            xenHost = (XenHost)h;
            break;
        }
        return xenHost != null && xenHost != this.host && this.getMemorySizeMB() < xenHost.getFreeMemoryMB();
    }

    public String getUuid() {
        return this.uuid;
    }

    public HostMXBean getHostMBean() {
        return this.host;
    }

    public long getDomID() {
        return this.domID;
    }

    public Date getStartTime() {
        if (this.startTime == null) {
            try {
                this.startTime = this.vm.getMetrics(this.connection).getStartTime(this.connection);
                GregorianCalendar calendar = new GregorianCalendar();
                this.startTime = new Date(this.startTime.getTime() + (long)calendar.get(16) + (long)calendar.get(15));
            }
            catch (Exception ex) {
                logger.error((Object)("Failed to getStartTime of VM " + this.name), (Throwable)ex);
            }
        }
        return this.startTime;
    }

    public long getUpTimeSeconds() {
        return (System.currentTimeMillis() - this.getStartTime().getTime()) / 1000L;
    }

    public void updateCPUConsumption(long time, float newCPULoad) {
        if (this.lastCPULoadTime > 0L) {
            float val = (float)(time - this.lastCPULoadTime) * (newCPULoad + this.lastCPULoad) / 120000.0f;
            this.cpuConsumption += (val *= (float)((long)this.host.getNumCPU() * this.host.getCPUFrequencyMhz()) / 1000.0f);
        }
        this.lastCPULoad = newCPULoad;
        this.lastCPULoadTime = time;
    }

    public float getCPULoad() {
        return this.lastCPULoad;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] getLoadPerVCPU() {
        float[] vals = new float[8];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = -1.0f;
        }
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                Map map = this.vm.getMetrics(this.connection).getVCPUsUtilisation(this.connection);
                for (Map.Entry entry : map.entrySet()) {
                    vals[((Long)entry.getKey()).intValue()] = (float)((Double)entry.getValue() * 100.0);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to get VM metrics", (Throwable)ex);
            }
        }
        return vals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMemorySizeMB() {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                return this.vm.getMemoryDynamicMax(this.connection) / 0x100000L;
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to get VM MemoryDynamicMax", (Throwable)ex);
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMemorySizeMB(long size) {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.vm.setMemoryDynamicMax(this.connection, Long.valueOf(size * 1014L * 1024L));
                this.vm.setMemoryDynamicMin(this.connection, Long.valueOf(size * 1024L * 1024L));
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to set VM MemoryDynamicMin/max", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMemoryUsedMB() {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                return this.vm.getMetrics(this.connection).getMemoryActual(this.connection).intValue() / 0x100000;
            }
            catch (Exception ex) {
                logger.error((Object)("Failed to get memory metrics form VM " + this.name), (Throwable)ex);
            }
        }
        return 0L;
    }

    public String getNameLabel() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserData(String key, String value) {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                RemoteExec.Result result = null;
                String command = "xenstore-write /vm/" + this.uuid + "/" + key + " " + value + " 2>&1";
                logger.debug((Object)("VM " + this.name + " addUserData: " + command));
                result = RemoteExec.commandAsRoot(this.host.getHostName(), this.host.getSshAuthInfo(), command);
                if (result.exitCode != 0) {
                    logger.debug((Object)("VM " + this.name + " addUserData failed: " + result.output));
                    logger.error((Object)(command + " returns " + result.exitCode));
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Failed to set add user data to VM " + this.name), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserData(String key) {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                RemoteExec.Result result = null;
                String command = "xenstore-read /vm/" + this.uuid + "/" + key;
                result = RemoteExec.commandAsRoot(this.host.getHostName(), this.host.getSshAuthInfo(), command);
                if (result.exitCode != 0) {
                    return "";
                }
                return result.output;
            }
            catch (Exception ex) {
                logger.error((Object)"VM getUserData failure: ", (Throwable)ex);
                return "";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumVCPUs() {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                return this.vm.getMetrics(this.connection).getVCPUsNumber(this.connection).intValue();
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to get VM metrics", (Throwable)ex);
            }
        }
        return -1;
    }

    public String getPinnedVCPUs() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSchedulingCap() {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                Map vcpuParams = this.vm.getVCPUsParams(this.connection);
                if (vcpuParams.get("cap") != null) {
                    return Integer.parseInt((String)vcpuParams.get("cap"));
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to get VM VCPU params", (Throwable)ex);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSchedulingWeight() {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                Map vcpuParams = this.vm.getVCPUsParams(this.connection);
                if (vcpuParams.get("weight") != null) {
                    return Integer.parseInt((String)vcpuParams.get("weight"));
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to get VM VCPU params", (Throwable)ex);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualMachineMXBean.PowerState getState() {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                Types.VmPowerState state = this.vm.getPowerState(this.connection);
                if (state == Types.VmPowerState.HALTED) {
                    this.cachedPowerState = VirtualMachineMXBean.PowerState.HALTED;
                    return this.cachedPowerState;
                }
                if (state == Types.VmPowerState.RUNNING) {
                    this.cachedPowerState = VirtualMachineMXBean.PowerState.RUNNING;
                    return this.cachedPowerState;
                }
                if (state == Types.VmPowerState.PAUSED) {
                    this.cachedPowerState = VirtualMachineMXBean.PowerState.PAUSED;
                    return this.cachedPowerState;
                }
                if (state == Types.VmPowerState.SUSPENDED) {
                    this.cachedPowerState = VirtualMachineMXBean.PowerState.SUSPENDED;
                    return this.cachedPowerState;
                }
                this.cachedPowerState = VirtualMachineMXBean.PowerState.UNKNOWN;
                return this.cachedPowerState;
            }
            catch (Exception exception) {
            }
        }
        this.cachedPowerState = VirtualMachineMXBean.PowerState.UNKNOWN;
        return this.cachedPowerState;
    }

    public String getGuestIpAddress() {
        try {
            if (this.getState() != VirtualMachineMXBean.PowerState.RUNNING) {
                return "unknown";
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.ipAddress == null) {
            int nbAttempts = 10;
            while (nbAttempts-- > 0) {
                this.ipAddress = this.host.getIPAddress(this.getMacAddress());
                if (this.ipAddress != null && !this.ipAddress.equals("")) break;
                try {
                    TimeUnit.SECONDS.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.ipAddress == null ? "unknown" : this.ipAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMacAddress() {
        try {
            if (this.getState() != VirtualMachineMXBean.PowerState.RUNNING) {
                return "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.macAddress == null) {
            Connection connection = this.connection;
            synchronized (connection) {
                try {
                    Set vifs = this.vm.getVIFs(this.connection);
                    for (VIF vif : vifs) {
                        String vifName = vif.getDevice(this.connection);
                        if (!vifName.equals("eth0")) continue;
                        this.macAddress = vif.getMAC(this.connection);
                        logger.debug((Object)("VM " + this.name + " Mac address=" + this.macAddress));
                        break;
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)("Failed to MAC address of VM " + this.name), (Throwable)ex);
                }
            }
        }
        if (this.macAddress == null) {
            logger.error((Object)("Unable to get MAC address of VM " + this.name));
        }
        return this.macAddress;
    }

    public void setMemory(int memory) {
        throw new UnsupportedOperationException();
    }

    public void setNumVCPUs(int numVCPUs) {
        throw new UnsupportedOperationException();
    }

    public void setPinnedVCPUs(String pinnedVCPUs) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSchedulingCap(int schedulingCap) {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                long domID = this.vm.getDomid(this.connection);
                RemoteExec.Result result = null;
                String command = "xm sched-credit -d " + domID + " -c " + schedulingCap;
                result = RemoteExec.commandAsRoot(this.host.getHostName(), this.host.getSshAuthInfo(), command);
                if (result.exitCode != 0) {
                    logger.error((Object)(command + " returns " + result.exitCode));
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Failed to set sched cap of VM " + this.name), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSchedulingWeight(int schedulingWeight) {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                long domID = this.vm.getDomid(this.connection);
                RemoteExec.Result result = null;
                String command = "xm sched-credit -d " + domID + " -w " + schedulingWeight;
                result = RemoteExec.commandAsRoot(this.host.getHostName(), this.host.getSshAuthInfo(), command);
                if (result.exitCode != 0) {
                    logger.error((Object)(command + " returns " + result.exitCode));
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Failed to set sched weigth of VM " + this.name), (Throwable)ex);
            }
        }
    }

    public void suspend() {
        try {
            RemoteExec.Result result = XenSSH.suspendVM(this.host, this.getNameLabel());
            if (result.exitCode != 0) {
                logger.error((Object)("Command suspendVM failed: " + result.error));
                return;
            }
            logger.debug((Object)result.output);
            this.onVMStateChanged();
        }
        catch (Exception ex) {
            logger.error((Object)"ssh failure", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrate(HostMXBean targetHost, boolean live) throws IllegalOperationException, VMMException {
        RemoteExec.Result result;
        if (!live) {
            throw new IllegalOperationException("Not implemented");
        }
        String targetHostName = targetHost.getHostName();
        logger.info((Object)("Attempting live migration of VM " + this.name + " to host " + targetHostName));
        boolean foundHostInServerPool = false;
        for (HostMXBean h : this.host.getServerPool().getManagedHosts()) {
            if (!h.getHostName().equals(targetHost.getHostName())) continue;
            foundHostInServerPool = true;
            targetHost = h;
            break;
        }
        if (!foundHostInServerPool) {
            throw new IllegalOperationException("Source and target hosts belong to different server pools");
        }
        XenHost targetXenHost = (XenHost)targetHost;
        String imageID = this.getUserData("imageID");
        logger.info((Object)("VM " + this.name + " live migration to host " + targetHostName + "..."));
        this.emitNotification("vm.migration.start", targetHostName, null);
        try {
            result = XenSSH.migrateVM(this.host, this.name, targetHostName);
        }
        catch (Exception ex) {
            logger.error((Object)"migrate: ", (Throwable)ex);
            this.emitNotification("vm.migration.abort", targetHostName, null);
            throw new VMMException("MigrateVM: SSH connection error", (Throwable)ex);
        }
        if (result.exitCode != 0) {
            this.emitNotification("vm.migration.abort", targetHostName, null);
            throw new VMMException("Command migrateVM failed: " + result.error);
        }
        try {
            result = XenSSH.postMigrateVM(this.host, this.name, targetHostName);
        }
        catch (Exception ex) {
            logger.error((Object)"PostMigrateVM: ", (Throwable)ex);
        }
        if (result.exitCode != 0) {
            logger.error((Object)("PostMigrateVM: " + result.error));
        }
        logger.info((Object)("VM " + this.name + " live migration done"));
        this.host.postMigrateVM(this, targetXenHost);
        this.host = targetXenHost;
        this.addUserData("imageID", imageID);
        Connection connection = this.connection = targetXenHost.getXenAPIConnection();
        synchronized (connection) {
            int attempts = 3;
            while (true) {
                try {
                    this.vm = VM.getByUuid((Connection)this.connection, (String)this.uuid);
                }
                catch (Exception ex) {
                    if (--attempts > 0) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    logger.error((Object)"Cannot get VM XenAPI handle after migration: ", (Throwable)ex);
                }
                break;
            }
        }
        this.emitNotification("vm.migration", targetHostName, this.uuid);
    }

    public void shutdown() {
        try {
            RemoteExec.Result result = XenSSH.shutdownVM(this.host, this.getNameLabel());
            if (result.exitCode != 0) {
                logger.error((Object)("Command shutdownVM failed: " + result.error));
                return;
            }
            logger.debug((Object)result.output);
            this.onVMStateChanged();
        }
        catch (Exception ex) {
            logger.error((Object)"ssh failure", (Throwable)ex);
        }
    }

    public void start() {
        try {
            RemoteExec.Result result = XenSSH.startVM(this.host, this.getNameLabel());
            if (result.exitCode != 0) {
                logger.error((Object)("Command start failed: " + result.error));
                return;
            }
            logger.debug((Object)result.output);
            this.onVMStateChanged();
        }
        catch (Exception ex) {
            logger.error((Object)"ssh failure", (Throwable)ex);
        }
    }

    void onVMStateChanged() {
        VirtualMachineMXBean.PowerState state = this.getState();
        if (state != VirtualMachineMXBean.PowerState.PAUSED) {
            this.emitNotification("vm.state", state.toString(), null);
            logger.debug((Object)("VM " + this.getNameLabel() + " new power state: " + state.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reboot() {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.vm.cleanReboot(this.connection);
                logger.info((Object)("VM " + this.name + " rebooted"));
            }
            catch (Exception ex) {
                logger.error((Object)("Failed to reboot VM " + this.name), (Throwable)ex);
            }
        }
    }

    public void resume() {
        try {
            RemoteExec.Result result = XenSSH.resumeVM(this.host, this.getNameLabel());
            if (result.exitCode != 0) {
                logger.error((Object)("ResumeVM failed: " + result.error));
                return;
            }
            logger.debug((Object)result.output);
            this.onVMStateChanged();
        }
        catch (Exception ex) {
            logger.error((Object)"ssh failure", (Throwable)ex);
        }
    }

    public void destroy() {
        try {
            RemoteExec.Result result = XenSSH.destroyVM(this.host, this.getNameLabel());
            if (result.exitCode != 0) {
                logger.error((Object)("DestroyVM failed: " + result.error));
            } else {
                logger.debug((Object)result.output);
                logger.info((Object)("VM " + this.name + " destroyed"));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"ssh failure", (Throwable)ex);
        }
        try {
            this.host.onVMDestroy(this);
            AgentCommon.getMBeanServer().unregisterMBean(this.objectName);
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to unregister VM MBean", (Throwable)ex);
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"vm.state", "vm.migration.abort", "vm.migration.start", "vm.migration", "log", "vm.error"}, Notification.class.getName(), "VM event")};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeTemplate(String vmImageID, String name, String description) throws InsufficientResourcesException, IllegalOperationException, VMMException {
        this.shutdown();
        try {
            ((XenVMImageStore)this.host.getServerPool().getVMImageStore()).newTemplateFromVMImage(this.getNameLabel(), vmImageID, name, description);
        }
        finally {
            this.start();
        }
    }
}

