/*
 * Decompiled with CFR 0.152.
 */
package com.xensource.xenapi;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Console;
import com.xensource.xenapi.Crashdump;
import com.xensource.xenapi.Host;
import com.xensource.xenapi.Marshalling;
import com.xensource.xenapi.SR;
import com.xensource.xenapi.Task;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.VBD;
import com.xensource.xenapi.VDI;
import com.xensource.xenapi.VIF;
import com.xensource.xenapi.VMGuestMetrics;
import com.xensource.xenapi.VMMetrics;
import com.xensource.xenapi.VTPM;
import com.xensource.xenapi.XenAPIObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VM
extends XenAPIObject {
    protected final String ref;
    private static final Map<String, SoftReference<VM>> cache = new HashMap<String, SoftReference<VM>>();

    private VM(String ref) {
        this.ref = ref;
    }

    @Override
    public String toWireString() {
        return this.ref;
    }

    protected static synchronized VM getInstFromRef(String ref) {
        VM instance;
        if (cache.containsKey(ref) && (instance = cache.get(ref).get()) != null) {
            return instance;
        }
        instance = new VM(ref);
        cache.put(ref, new SoftReference<VM>(instance));
        return instance;
    }

    public Record getRecord(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_record";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toVMRecord(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static VM getByUuid(Connection c, String uuid) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_by_uuid";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(uuid)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toVM(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static Task createAsync(Connection c, Record record) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.VM.create";
        String session = c.getSessionReference();
        Map<String, Object> record_map = record.toMap();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(record_map)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static VM create(Connection c, Record record) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.create";
        String session = c.getSessionReference();
        Map<String, Object> record_map = record.toMap();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(record_map)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toVM(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Task destroyAsync(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.VM.destroy";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void destroy(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.destroy";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public static Set<VM> getByNameLabel(Connection c, String label) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_by_name_label";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(label)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfVM(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getUuid(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_uuid";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Set<Types.VmOperations> getAllowedOperations(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_allowed_operations";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfVmOperations(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, Types.VmOperations> getCurrentOperations(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_current_operations";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringVmOperations(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Types.VmPowerState getPowerState(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_power_state";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toVmPowerState(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getNameLabel(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_name_label";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getNameDescription(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_name_description";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Long getUserVersion(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_user_version";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toLong(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Boolean getIsATemplate(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_is_a_template";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toBoolean(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public VDI getSuspendVDI(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_suspend_VDI";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toVDI(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Host getResidentOn(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_resident_on";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toHost(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Host getAffinity(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_affinity";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toHost(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Long getMemoryStaticMax(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_memory_static_max";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toLong(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Long getMemoryDynamicMax(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_memory_dynamic_max";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toLong(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Long getMemoryDynamicMin(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_memory_dynamic_min";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toLong(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Long getMemoryStaticMin(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_memory_static_min";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toLong(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, String> getVCPUsParams(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_VCPUs_params";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Long getVCPUsMax(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_VCPUs_max";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toLong(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Long getVCPUsAtStartup(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_VCPUs_at_startup";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toLong(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Types.OnNormalExit getActionsAfterShutdown(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_actions_after_shutdown";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toOnNormalExit(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Types.OnNormalExit getActionsAfterReboot(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_actions_after_reboot";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toOnNormalExit(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Types.OnCrashBehaviour getActionsAfterCrash(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_actions_after_crash";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toOnCrashBehaviour(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Set<Console> getConsoles(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_consoles";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfConsole(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Set<VIF> getVIFs(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_VIFs";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfVIF(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Set<VBD> getVBDs(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_VBDs";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfVBD(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Set<Crashdump> getCrashDumps(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_crash_dumps";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfCrashdump(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Set<VTPM> getVTPMs(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_VTPMs";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfVTPM(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getPVBootloader(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_PV_bootloader";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getPVKernel(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_PV_kernel";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getPVRamdisk(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_PV_ramdisk";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getPVArgs(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_PV_args";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getPVBootloaderArgs(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_PV_bootloader_args";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getPVLegacyArgs(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_PV_legacy_args";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getHVMBootPolicy(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_HVM_boot_policy";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, String> getHVMBootParams(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_HVM_boot_params";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Double getHVMShadowMultiplier(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_HVM_shadow_multiplier";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toDouble(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, String> getPlatform(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_platform";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getPCIBus(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_PCI_bus";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, String> getOtherConfig(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_other_config";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Long getDomid(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_domid";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toLong(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getDomarch(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_domarch";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, String> getLastBootCPUFlags(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_last_boot_CPU_flags";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Boolean getIsControlDomain(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_is_control_domain";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toBoolean(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public VMMetrics getMetrics(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_metrics";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toVMMetrics(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public VMGuestMetrics getGuestMetrics(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_guest_metrics";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toVMGuestMetrics(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getRecommendations(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_recommendations";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, String> getXenstoreData(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_xenstore_data";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void setNameLabel(Connection c, String label) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_name_label";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(label)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setNameDescription(Connection c, String description) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_name_description";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(description)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setUserVersion(Connection c, Long userVersion) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_user_version";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(userVersion)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setIsATemplate(Connection c, Boolean isATemplate) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_is_a_template";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(isATemplate)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setAffinity(Connection c, Host affinity) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_affinity";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(affinity)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setMemoryStaticMax(Connection c, Long staticMax) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_memory_static_max";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(staticMax)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setMemoryDynamicMax(Connection c, Long dynamicMax) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_memory_dynamic_max";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(dynamicMax)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setMemoryDynamicMin(Connection c, Long dynamicMin) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_memory_dynamic_min";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(dynamicMin)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setMemoryStaticMin(Connection c, Long staticMin) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_memory_static_min";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(staticMin)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setVCPUsParams(Connection c, Map<String, String> params) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_VCPUs_params";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(params)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void addToVCPUsParams(Connection c, String key, String value) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.add_to_VCPUs_params";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key), Marshalling.toXMLRPC(value)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void removeFromVCPUsParams(Connection c, String key) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.remove_from_VCPUs_params";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setVCPUsMax(Connection c, Long max) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_VCPUs_max";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(max)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setVCPUsAtStartup(Connection c, Long atStartup) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_VCPUs_at_startup";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(atStartup)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setActionsAfterShutdown(Connection c, Types.OnNormalExit afterShutdown) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_actions_after_shutdown";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)afterShutdown)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setActionsAfterReboot(Connection c, Types.OnNormalExit afterReboot) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_actions_after_reboot";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)afterReboot)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setActionsAfterCrash(Connection c, Types.OnCrashBehaviour afterCrash) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_actions_after_crash";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)afterCrash)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setPVBootloader(Connection c, String bootloader) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_PV_bootloader";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(bootloader)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setPVKernel(Connection c, String kernel) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_PV_kernel";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(kernel)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setPVRamdisk(Connection c, String ramdisk) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_PV_ramdisk";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(ramdisk)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setPVArgs(Connection c, String args) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_PV_args";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(args)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setPVBootloaderArgs(Connection c, String bootloaderArgs) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_PV_bootloader_args";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(bootloaderArgs)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setPVLegacyArgs(Connection c, String legacyArgs) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_PV_legacy_args";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(legacyArgs)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setHVMBootPolicy(Connection c, String bootPolicy) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_HVM_boot_policy";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(bootPolicy)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setHVMBootParams(Connection c, Map<String, String> bootParams) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_HVM_boot_params";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(bootParams)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void addToHVMBootParams(Connection c, String key, String value) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.add_to_HVM_boot_params";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key), Marshalling.toXMLRPC(value)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void removeFromHVMBootParams(Connection c, String key) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.remove_from_HVM_boot_params";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setHVMShadowMultiplier(Connection c, Double shadowMultiplier) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_HVM_shadow_multiplier";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(shadowMultiplier)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setPlatform(Connection c, Map<String, String> platform) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_platform";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(platform)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void addToPlatform(Connection c, String key, String value) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.add_to_platform";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key), Marshalling.toXMLRPC(value)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void removeFromPlatform(Connection c, String key) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.remove_from_platform";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setPCIBus(Connection c, String PCIBus) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_PCI_bus";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(PCIBus)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setOtherConfig(Connection c, Map<String, String> otherConfig) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_other_config";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(otherConfig)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void addToOtherConfig(Connection c, String key, String value) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.add_to_other_config";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key), Marshalling.toXMLRPC(value)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void removeFromOtherConfig(Connection c, String key) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.remove_from_other_config";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setRecommendations(Connection c, String recommendations) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_recommendations";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(recommendations)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void setXenstoreData(Connection c, Map<String, String> xenstoreData) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_xenstore_data";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(xenstoreData)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void addToXenstoreData(Connection c, String key, String value) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.add_to_xenstore_data";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key), Marshalling.toXMLRPC(value)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public void removeFromXenstoreData(Connection c, String key) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.remove_from_xenstore_data";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public Task createCloneAsync(Connection c, String newName) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.SrFull, Types.OperationNotAllowed {
        String method_call = "Async.VM.clone";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(newName)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("SR_FULL")) {
                throw new Types.SrFull((String)error[1], (String)error[2]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public VM createClone(Connection c, String newName) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.SrFull, Types.OperationNotAllowed {
        String method_call = "VM.clone";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(newName)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toVM(result);
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("SR_FULL")) {
                throw new Types.SrFull((String)error[1], (String)error[2]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public Task copyAsync(Connection c, String newName, SR sr) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.SrFull, Types.OperationNotAllowed {
        String method_call = "Async.VM.copy";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(newName), Marshalling.toXMLRPC(sr)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("SR_FULL")) {
                throw new Types.SrFull((String)error[1], (String)error[2]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public VM copy(Connection c, String newName, SR sr) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.SrFull, Types.OperationNotAllowed {
        String method_call = "VM.copy";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(newName), Marshalling.toXMLRPC(sr)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toVM(result);
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("SR_FULL")) {
                throw new Types.SrFull((String)error[1], (String)error[2]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public Task provisionAsync(Connection c) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.SrFull, Types.OperationNotAllowed {
        String method_call = "Async.VM.provision";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("SR_FULL")) {
                throw new Types.SrFull((String)error[1], (String)error[2]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public void provision(Connection c) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.SrFull, Types.OperationNotAllowed {
        String method_call = "VM.provision";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("SR_FULL")) {
                throw new Types.SrFull((String)error[1], (String)error[2]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public Task startAsync(Connection c, Boolean startPaused, Boolean force) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.VmHvmRequired, Types.VmIsTemplate, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.BootloaderFailed, Types.UnknownBootloader, Types.NoHostsAvailable, Types.LicenceRestriction {
        String method_call = "Async.VM.start";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(startPaused), Marshalling.toXMLRPC(force)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("VM_HVM_REQUIRED")) {
                throw new Types.VmHvmRequired((String)error[1]);
            }
            if (error[0].equals("VM_IS_TEMPLATE")) {
                throw new Types.VmIsTemplate((String)error[1]);
            }
            if (error[0].equals("OTHER_OPERATION_IN_PROGRESS")) {
                throw new Types.OtherOperationInProgress((String)error[1], (String)error[2]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
            if (error[0].equals("BOOTLOADER_FAILED")) {
                throw new Types.BootloaderFailed((String)error[1], (String)error[2]);
            }
            if (error[0].equals("UNKNOWN_BOOTLOADER")) {
                throw new Types.UnknownBootloader((String)error[1], (String)error[2]);
            }
            if (error[0].equals("NO_HOSTS_AVAILABLE")) {
                throw new Types.NoHostsAvailable();
            }
            if (error[0].equals("LICENCE_RESTRICTION")) {
                throw new Types.LicenceRestriction();
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public void start(Connection c, Boolean startPaused, Boolean force) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.VmHvmRequired, Types.VmIsTemplate, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.BootloaderFailed, Types.UnknownBootloader, Types.NoHostsAvailable, Types.LicenceRestriction {
        String method_call = "VM.start";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(startPaused)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("VM_HVM_REQUIRED")) {
                throw new Types.VmHvmRequired((String)error[1]);
            }
            if (error[0].equals("VM_IS_TEMPLATE")) {
                throw new Types.VmIsTemplate((String)error[1]);
            }
            if (error[0].equals("OTHER_OPERATION_IN_PROGRESS")) {
                throw new Types.OtherOperationInProgress((String)error[1], (String)error[2]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
            if (error[0].equals("BOOTLOADER_FAILED")) {
                throw new Types.BootloaderFailed((String)error[1], (String)error[2]);
            }
            if (error[0].equals("UNKNOWN_BOOTLOADER")) {
                throw new Types.UnknownBootloader((String)error[1], (String)error[2]);
            }
            if (error[0].equals("NO_HOSTS_AVAILABLE")) {
                throw new Types.NoHostsAvailable();
            }
            if (error[0].equals("LICENCE_RESTRICTION")) {
                throw new Types.LicenceRestriction();
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public Task startOnAsync(Connection c, Host host, Boolean startPaused, Boolean force) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.VmIsTemplate, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.BootloaderFailed, Types.UnknownBootloader {
        String method_call = "Async.VM.start_on";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(host), Marshalling.toXMLRPC(startPaused), Marshalling.toXMLRPC(force)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("VM_IS_TEMPLATE")) {
                throw new Types.VmIsTemplate((String)error[1]);
            }
            if (error[0].equals("OTHER_OPERATION_IN_PROGRESS")) {
                throw new Types.OtherOperationInProgress((String)error[1], (String)error[2]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
            if (error[0].equals("BOOTLOADER_FAILED")) {
                throw new Types.BootloaderFailed((String)error[1], (String)error[2]);
            }
            if (error[0].equals("UNKNOWN_BOOTLOADER")) {
                throw new Types.UnknownBootloader((String)error[1], (String)error[2]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public void startOn(Connection c, Host host, Boolean startPaused, Boolean force) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.VmIsTemplate, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.BootloaderFailed, Types.UnknownBootloader {
        String method_call = "VM.start_on";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(host), Marshalling.toXMLRPC(startPaused), Marshalling.toXMLRPC(force)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("VM_IS_TEMPLATE")) {
                throw new Types.VmIsTemplate((String)error[1]);
            }
            if (error[0].equals("OTHER_OPERATION_IN_PROGRESS")) {
                throw new Types.OtherOperationInProgress((String)error[1], (String)error[2]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
            if (error[0].equals("BOOTLOADER_FAILED")) {
                throw new Types.BootloaderFailed((String)error[1], (String)error[2]);
            }
            if (error[0].equals("UNKNOWN_BOOTLOADER")) {
                throw new Types.UnknownBootloader((String)error[1], (String)error[2]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public Task pauseAsync(Connection c) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.VmIsTemplate {
        String method_call = "Async.VM.pause";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("OTHER_OPERATION_IN_PROGRESS")) {
                throw new Types.OtherOperationInProgress((String)error[1], (String)error[2]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
            if (error[0].equals("VM_IS_TEMPLATE")) {
                throw new Types.VmIsTemplate((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public void pause(Connection c) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.VmIsTemplate {
        String method_call = "VM.pause";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("OTHER_OPERATION_IN_PROGRESS")) {
                throw new Types.OtherOperationInProgress((String)error[1], (String)error[2]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
            if (error[0].equals("VM_IS_TEMPLATE")) {
                throw new Types.VmIsTemplate((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public Task unpauseAsync(Connection c) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.OperationNotAllowed, Types.VmIsTemplate {
        String method_call = "Async.VM.unpause";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
            if (error[0].equals("VM_IS_TEMPLATE")) {
                throw new Types.VmIsTemplate((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public void unpause(Connection c) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.OperationNotAllowed, Types.VmIsTemplate {
        String method_call = "VM.unpause";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
            if (error[0].equals("VM_IS_TEMPLATE")) {
                throw new Types.VmIsTemplate((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public Task cleanShutdownAsync(Connection c) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.VmIsTemplate {
        String method_call = "Async.VM.clean_shutdown";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("OTHER_OPERATION_IN_PROGRESS")) {
                throw new Types.OtherOperationInProgress((String)error[1], (String)error[2]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
            if (error[0].equals("VM_IS_TEMPLATE")) {
                throw new Types.VmIsTemplate((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public void cleanShutdown(Connection c) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.VmIsTemplate {
        String method_call = "VM.clean_shutdown";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("OTHER_OPERATION_IN_PROGRESS")) {
                throw new Types.OtherOperationInProgress((String)error[1], (String)error[2]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
            if (error[0].equals("VM_IS_TEMPLATE")) {
                throw new Types.VmIsTemplate((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public Task cleanRebootAsync(Connection c) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.VmIsTemplate {
        String method_call = "Async.VM.clean_reboot";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("OTHER_OPERATION_IN_PROGRESS")) {
                throw new Types.OtherOperationInProgress((String)error[1], (String)error[2]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
            if (error[0].equals("VM_IS_TEMPLATE")) {
                throw new Types.VmIsTemplate((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public void cleanReboot(Connection c) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.VmIsTemplate {
        String method_call = "VM.clean_reboot";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("OTHER_OPERATION_IN_PROGRESS")) {
                throw new Types.OtherOperationInProgress((String)error[1], (String)error[2]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
            if (error[0].equals("VM_IS_TEMPLATE")) {
                throw new Types.VmIsTemplate((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public Task hardShutdownAsync(Connection c) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.VmIsTemplate {
        String method_call = "Async.VM.hard_shutdown";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("OTHER_OPERATION_IN_PROGRESS")) {
                throw new Types.OtherOperationInProgress((String)error[1], (String)error[2]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
            if (error[0].equals("VM_IS_TEMPLATE")) {
                throw new Types.VmIsTemplate((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public void hardShutdown(Connection c) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.VmIsTemplate {
        String method_call = "VM.hard_shutdown";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("OTHER_OPERATION_IN_PROGRESS")) {
                throw new Types.OtherOperationInProgress((String)error[1], (String)error[2]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
            if (error[0].equals("VM_IS_TEMPLATE")) {
                throw new Types.VmIsTemplate((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public Task powerStateResetAsync(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.VM.power_state_reset";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void powerStateReset(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.power_state_reset";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public Task hardRebootAsync(Connection c) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.VmIsTemplate {
        String method_call = "Async.VM.hard_reboot";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("OTHER_OPERATION_IN_PROGRESS")) {
                throw new Types.OtherOperationInProgress((String)error[1], (String)error[2]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
            if (error[0].equals("VM_IS_TEMPLATE")) {
                throw new Types.VmIsTemplate((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public void hardReboot(Connection c) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.VmIsTemplate {
        String method_call = "VM.hard_reboot";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("OTHER_OPERATION_IN_PROGRESS")) {
                throw new Types.OtherOperationInProgress((String)error[1], (String)error[2]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
            if (error[0].equals("VM_IS_TEMPLATE")) {
                throw new Types.VmIsTemplate((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public Task suspendAsync(Connection c) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.VmIsTemplate {
        String method_call = "Async.VM.suspend";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("OTHER_OPERATION_IN_PROGRESS")) {
                throw new Types.OtherOperationInProgress((String)error[1], (String)error[2]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
            if (error[0].equals("VM_IS_TEMPLATE")) {
                throw new Types.VmIsTemplate((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public void suspend(Connection c) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.VmIsTemplate {
        String method_call = "VM.suspend";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("OTHER_OPERATION_IN_PROGRESS")) {
                throw new Types.OtherOperationInProgress((String)error[1], (String)error[2]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
            if (error[0].equals("VM_IS_TEMPLATE")) {
                throw new Types.VmIsTemplate((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public Task resumeAsync(Connection c, Boolean startPaused, Boolean force) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.OperationNotAllowed, Types.VmIsTemplate {
        String method_call = "Async.VM.resume";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(startPaused), Marshalling.toXMLRPC(force)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
            if (error[0].equals("VM_IS_TEMPLATE")) {
                throw new Types.VmIsTemplate((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public void resume(Connection c, Boolean startPaused, Boolean force) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.OperationNotAllowed, Types.VmIsTemplate {
        String method_call = "VM.resume";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(startPaused)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
            if (error[0].equals("VM_IS_TEMPLATE")) {
                throw new Types.VmIsTemplate((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public Task resumeOnAsync(Connection c, Host host, Boolean startPaused, Boolean force) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.OperationNotAllowed, Types.VmIsTemplate {
        String method_call = "Async.VM.resume_on";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(host), Marshalling.toXMLRPC(startPaused), Marshalling.toXMLRPC(force)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
            if (error[0].equals("VM_IS_TEMPLATE")) {
                throw new Types.VmIsTemplate((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public void resumeOn(Connection c, Host host, Boolean startPaused, Boolean force) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.OperationNotAllowed, Types.VmIsTemplate {
        String method_call = "VM.resume_on";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(host), Marshalling.toXMLRPC(startPaused), Marshalling.toXMLRPC(force)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
            if (error[0].equals("VM_IS_TEMPLATE")) {
                throw new Types.VmIsTemplate((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public Task poolMigrateAsync(Connection c, Host host, Map<String, String> options) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.VmIsTemplate, Types.OperationNotAllowed, Types.VmMigrateFailed, Types.VmMissingPvDrivers {
        String method_call = "Async.VM.pool_migrate";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(host), Marshalling.toXMLRPC(options)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("OTHER_OPERATION_IN_PROGRESS")) {
                throw new Types.OtherOperationInProgress((String)error[1], (String)error[2]);
            }
            if (error[0].equals("VM_IS_TEMPLATE")) {
                throw new Types.VmIsTemplate((String)error[1]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
            if (error[0].equals("VM_MIGRATE_FAILED")) {
                throw new Types.VmMigrateFailed((String)error[1], (String)error[2], (String)error[3], (String)error[4]);
            }
            if (error[0].equals("VM_MISSING_PV_DRIVERS")) {
                throw new Types.VmMissingPvDrivers((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public void migrate(Connection c, String dest, Boolean live, Map<String, String> options) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.VmIsTemplate, Types.OperationNotAllowed, Types.VmMigrateFailed, Types.VmMissingPvDrivers {
        String method_call = "VM.migrate";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(dest), Marshalling.toXMLRPC(live), Marshalling.toXMLRPC(options)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("OTHER_OPERATION_IN_PROGRESS")) {
                throw new Types.OtherOperationInProgress((String)error[1], (String)error[2]);
            }
            if (error[0].equals("VM_IS_TEMPLATE")) {
                throw new Types.VmIsTemplate((String)error[1]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
            if (error[0].equals("VM_MIGRATE_FAILED")) {
                throw new Types.VmMigrateFailed((String)error[1], (String)error[2], (String)error[3], (String)error[4]);
            }
            if (error[0].equals("VM_MISSING_PV_DRIVERS")) {
                throw new Types.VmMissingPvDrivers((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public void poolMigrate(Connection c, Host host, Map<String, String> options) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.VmIsTemplate, Types.OperationNotAllowed, Types.VmMigrateFailed, Types.VmMissingPvDrivers {
        String method_call = "VM.pool_migrate";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(host), Marshalling.toXMLRPC(options)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("VM_BAD_POWER_STATE")) {
                throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
            }
            if (error[0].equals("OTHER_OPERATION_IN_PROGRESS")) {
                throw new Types.OtherOperationInProgress((String)error[1], (String)error[2]);
            }
            if (error[0].equals("VM_IS_TEMPLATE")) {
                throw new Types.VmIsTemplate((String)error[1]);
            }
            if (error[0].equals("OPERATION_NOT_ALLOWED")) {
                throw new Types.OperationNotAllowed((String)error[1]);
            }
            if (error[0].equals("VM_MIGRATE_FAILED")) {
                throw new Types.VmMigrateFailed((String)error[1], (String)error[2], (String)error[3], (String)error[4]);
            }
            if (error[0].equals("VM_MISSING_PV_DRIVERS")) {
                throw new Types.VmMissingPvDrivers((String)error[1]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public Task setVCPUsNumberLiveAsync(Connection c, Long nvcpu) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.VM.set_VCPUs_number_live";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(nvcpu)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void setVCPUsNumberLive(Connection c, Long nvcpu) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_VCPUs_number_live";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(nvcpu)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public Task addToVCPUsParamsLiveAsync(Connection c, String key, String value) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.VM.add_to_VCPUs_params_live";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key), Marshalling.toXMLRPC(value)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void addToVCPUsParamsLive(Connection c, String key, String value) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.add_to_VCPUs_params_live";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key), Marshalling.toXMLRPC(value)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public Task setMemoryTargetLiveAsync(Connection c, Long target) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.VM.set_memory_target_live";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(target)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void setMemoryTargetLive(Connection c, Long target) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_memory_target_live";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(target)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public Task setShadowMultiplierLiveAsync(Connection c, Double multiplier) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.VM.set_shadow_multiplier_live";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(multiplier)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void setShadowMultiplierLive(Connection c, Double multiplier) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.set_shadow_multiplier_live";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(multiplier)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public Task sendSysrqAsync(Connection c, String key) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState {
        Object[] error;
        String method_call = "Async.VM.send_sysrq";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        if (response.get("Status").equals("Failure") && (error = (Object[])response.get("ErrorDescription"))[0].equals("VM_BAD_POWER_STATE")) {
            throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
        }
        throw new Types.BadServerResponse(response);
    }

    public void sendSysrq(Connection c, String key) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState {
        Object[] error;
        String method_call = "VM.send_sysrq";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(key)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        if (response.get("Status").equals("Failure") && (error = (Object[])response.get("ErrorDescription"))[0].equals("VM_BAD_POWER_STATE")) {
            throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
        }
        throw new Types.BadServerResponse(response);
    }

    public Task sendTriggerAsync(Connection c, String trigger) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState {
        Object[] error;
        String method_call = "Async.VM.send_trigger";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(trigger)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        if (response.get("Status").equals("Failure") && (error = (Object[])response.get("ErrorDescription"))[0].equals("VM_BAD_POWER_STATE")) {
            throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
        }
        throw new Types.BadServerResponse(response);
    }

    public void sendTrigger(Connection c, String trigger) throws Types.BadServerResponse, XmlRpcException, Types.VmBadPowerState {
        Object[] error;
        String method_call = "VM.send_trigger";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(trigger)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        if (response.get("Status").equals("Failure") && (error = (Object[])response.get("ErrorDescription"))[0].equals("VM_BAD_POWER_STATE")) {
            throw new Types.VmBadPowerState((String)error[1], (String)error[2], (String)error[3]);
        }
        throw new Types.BadServerResponse(response);
    }

    public Task maximiseMemoryAsync(Connection c, Long total, Boolean approximate) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.VM.maximise_memory";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(total), Marshalling.toXMLRPC(approximate)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Long maximiseMemory(Connection c, Long total, Boolean approximate) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.maximise_memory";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(total), Marshalling.toXMLRPC(approximate)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toLong(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Record getBootRecord(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_boot_record";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toVMRecord(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Task assertOperationValidAsync(Connection c, Types.VmOperations op) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.VM.assert_operation_valid";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)op)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void assertOperationValid(Connection c, Types.VmOperations op) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.assert_operation_valid";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)op)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public Task updateAllowedOperationsAsync(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.VM.update_allowed_operations";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public void updateAllowedOperations(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.update_allowed_operations";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        throw new Types.BadServerResponse(response);
    }

    public Set<String> getAllowedVBDDevices(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_allowed_VBD_devices";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Set<String> getAllowedVIFDevices(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_allowed_VIF_devices";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Task getPossibleHostsAsync(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "Async.VM.get_possible_hosts";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Set<Host> getPossibleHosts(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_possible_hosts";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfHost(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Task assertCanBootHereAsync(Connection c, Host host) throws Types.BadServerResponse, XmlRpcException, Types.HostNotEnoughFreeMemory, Types.VmRequiresSr {
        String method_call = "Async.VM.assert_can_boot_here";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(host)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toTask(result);
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("HOST_NOT_ENOUGH_FREE_MEMORY")) {
                throw new Types.HostNotEnoughFreeMemory();
            }
            if (error[0].equals("VM_REQUIRES_SR")) {
                throw new Types.VmRequiresSr((String)error[1], (String)error[2]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public void assertCanBootHere(Connection c, Host host) throws Types.BadServerResponse, XmlRpcException, Types.HostNotEnoughFreeMemory, Types.VmRequiresSr {
        String method_call = "VM.assert_can_boot_here";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(host)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return;
        }
        if (response.get("Status").equals("Failure")) {
            Object[] error = (Object[])response.get("ErrorDescription");
            if (error[0].equals("HOST_NOT_ENOUGH_FREE_MEMORY")) {
                throw new Types.HostNotEnoughFreeMemory();
            }
            if (error[0].equals("VM_REQUIRES_SR")) {
                throw new Types.VmRequiresSr((String)error[1], (String)error[2]);
            }
        }
        throw new Types.BadServerResponse(response);
    }

    public static Set<VM> getAll(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_all";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfVM(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static Map<VM, Record> getAllRecords(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM.get_all_records";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfVMVMRecord(result);
        }
        throw new Types.BadServerResponse(response);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Record
    implements Types.Record {
        public String uuid;
        public Set<Types.VmOperations> allowedOperations;
        public Map<String, Types.VmOperations> currentOperations;
        public Types.VmPowerState powerState;
        public String nameLabel;
        public String nameDescription;
        public Long userVersion;
        public Boolean isATemplate;
        public VDI suspendVDI;
        public Host residentOn;
        public Host affinity;
        public Long memoryStaticMax;
        public Long memoryDynamicMax;
        public Long memoryDynamicMin;
        public Long memoryStaticMin;
        public Map<String, String> VCPUsParams;
        public Long VCPUsMax;
        public Long VCPUsAtStartup;
        public Types.OnNormalExit actionsAfterShutdown;
        public Types.OnNormalExit actionsAfterReboot;
        public Types.OnCrashBehaviour actionsAfterCrash;
        public Set<Console> consoles;
        public Set<VIF> VIFs;
        public Set<VBD> VBDs;
        public Set<Crashdump> crashDumps;
        public Set<VTPM> VTPMs;
        public String PVBootloader;
        public String PVKernel;
        public String PVRamdisk;
        public String PVArgs;
        public String PVBootloaderArgs;
        public String PVLegacyArgs;
        public String HVMBootPolicy;
        public Map<String, String> HVMBootParams;
        public Double HVMShadowMultiplier;
        public Map<String, String> platform;
        public String PCIBus;
        public Map<String, String> otherConfig;
        public Long domid;
        public String domarch;
        public Map<String, String> lastBootCPUFlags;
        public Boolean isControlDomain;
        public VMMetrics metrics;
        public VMGuestMetrics guestMetrics;
        public String recommendations;
        public Map<String, String> xenstoreData;

        public String toString() {
            StringWriter writer = new StringWriter();
            PrintWriter print = new PrintWriter(writer);
            print.printf("%1$20s: %2$s\n", "uuid", this.uuid);
            print.printf("%1$20s: %2$s\n", "allowedOperations", this.allowedOperations);
            print.printf("%1$20s: %2$s\n", "currentOperations", this.currentOperations);
            print.printf("%1$20s: %2$s\n", new Object[]{"powerState", this.powerState});
            print.printf("%1$20s: %2$s\n", "nameLabel", this.nameLabel);
            print.printf("%1$20s: %2$s\n", "nameDescription", this.nameDescription);
            print.printf("%1$20s: %2$s\n", "userVersion", this.userVersion);
            print.printf("%1$20s: %2$s\n", "isATemplate", this.isATemplate);
            print.printf("%1$20s: %2$s\n", "suspendVDI", this.suspendVDI);
            print.printf("%1$20s: %2$s\n", "residentOn", this.residentOn);
            print.printf("%1$20s: %2$s\n", "affinity", this.affinity);
            print.printf("%1$20s: %2$s\n", "memoryStaticMax", this.memoryStaticMax);
            print.printf("%1$20s: %2$s\n", "memoryDynamicMax", this.memoryDynamicMax);
            print.printf("%1$20s: %2$s\n", "memoryDynamicMin", this.memoryDynamicMin);
            print.printf("%1$20s: %2$s\n", "memoryStaticMin", this.memoryStaticMin);
            print.printf("%1$20s: %2$s\n", "VCPUsParams", this.VCPUsParams);
            print.printf("%1$20s: %2$s\n", "VCPUsMax", this.VCPUsMax);
            print.printf("%1$20s: %2$s\n", "VCPUsAtStartup", this.VCPUsAtStartup);
            print.printf("%1$20s: %2$s\n", new Object[]{"actionsAfterShutdown", this.actionsAfterShutdown});
            print.printf("%1$20s: %2$s\n", new Object[]{"actionsAfterReboot", this.actionsAfterReboot});
            print.printf("%1$20s: %2$s\n", new Object[]{"actionsAfterCrash", this.actionsAfterCrash});
            print.printf("%1$20s: %2$s\n", "consoles", this.consoles);
            print.printf("%1$20s: %2$s\n", "VIFs", this.VIFs);
            print.printf("%1$20s: %2$s\n", "VBDs", this.VBDs);
            print.printf("%1$20s: %2$s\n", "crashDumps", this.crashDumps);
            print.printf("%1$20s: %2$s\n", "VTPMs", this.VTPMs);
            print.printf("%1$20s: %2$s\n", "PVBootloader", this.PVBootloader);
            print.printf("%1$20s: %2$s\n", "PVKernel", this.PVKernel);
            print.printf("%1$20s: %2$s\n", "PVRamdisk", this.PVRamdisk);
            print.printf("%1$20s: %2$s\n", "PVArgs", this.PVArgs);
            print.printf("%1$20s: %2$s\n", "PVBootloaderArgs", this.PVBootloaderArgs);
            print.printf("%1$20s: %2$s\n", "PVLegacyArgs", this.PVLegacyArgs);
            print.printf("%1$20s: %2$s\n", "HVMBootPolicy", this.HVMBootPolicy);
            print.printf("%1$20s: %2$s\n", "HVMBootParams", this.HVMBootParams);
            print.printf("%1$20s: %2$s\n", "HVMShadowMultiplier", this.HVMShadowMultiplier);
            print.printf("%1$20s: %2$s\n", "platform", this.platform);
            print.printf("%1$20s: %2$s\n", "PCIBus", this.PCIBus);
            print.printf("%1$20s: %2$s\n", "otherConfig", this.otherConfig);
            print.printf("%1$20s: %2$s\n", "domid", this.domid);
            print.printf("%1$20s: %2$s\n", "domarch", this.domarch);
            print.printf("%1$20s: %2$s\n", "lastBootCPUFlags", this.lastBootCPUFlags);
            print.printf("%1$20s: %2$s\n", "isControlDomain", this.isControlDomain);
            print.printf("%1$20s: %2$s\n", "metrics", this.metrics);
            print.printf("%1$20s: %2$s\n", "guestMetrics", this.guestMetrics);
            print.printf("%1$20s: %2$s\n", "recommendations", this.recommendations);
            print.printf("%1$20s: %2$s\n", "xenstoreData", this.xenstoreData);
            return writer.toString();
        }

        @Override
        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("uuid", this.uuid);
            map.put("allowed_operations", this.allowedOperations);
            map.put("current_operations", this.currentOperations);
            map.put("power_state", (Object)this.powerState);
            map.put("name_label", this.nameLabel);
            map.put("name_description", this.nameDescription);
            map.put("user_version", this.userVersion);
            map.put("is_a_template", this.isATemplate);
            map.put("suspend_VDI", this.suspendVDI);
            map.put("resident_on", this.residentOn);
            map.put("affinity", this.affinity);
            map.put("memory_static_max", this.memoryStaticMax);
            map.put("memory_dynamic_max", this.memoryDynamicMax);
            map.put("memory_dynamic_min", this.memoryDynamicMin);
            map.put("memory_static_min", this.memoryStaticMin);
            map.put("VCPUs_params", this.VCPUsParams);
            map.put("VCPUs_max", this.VCPUsMax);
            map.put("VCPUs_at_startup", this.VCPUsAtStartup);
            map.put("actions_after_shutdown", (Object)this.actionsAfterShutdown);
            map.put("actions_after_reboot", (Object)this.actionsAfterReboot);
            map.put("actions_after_crash", (Object)this.actionsAfterCrash);
            map.put("consoles", this.consoles);
            map.put("VIFs", this.VIFs);
            map.put("VBDs", this.VBDs);
            map.put("crash_dumps", this.crashDumps);
            map.put("VTPMs", this.VTPMs);
            map.put("PV_bootloader", this.PVBootloader);
            map.put("PV_kernel", this.PVKernel);
            map.put("PV_ramdisk", this.PVRamdisk);
            map.put("PV_args", this.PVArgs);
            map.put("PV_bootloader_args", this.PVBootloaderArgs);
            map.put("PV_legacy_args", this.PVLegacyArgs);
            map.put("HVM_boot_policy", this.HVMBootPolicy);
            map.put("HVM_boot_params", this.HVMBootParams);
            map.put("HVM_shadow_multiplier", this.HVMShadowMultiplier);
            map.put("platform", this.platform);
            map.put("PCI_bus", this.PCIBus);
            map.put("other_config", this.otherConfig);
            map.put("domid", this.domid);
            map.put("domarch", this.domarch);
            map.put("last_boot_CPU_flags", this.lastBootCPUFlags);
            map.put("is_control_domain", this.isControlDomain);
            map.put("metrics", this.metrics);
            map.put("guest_metrics", this.guestMetrics);
            map.put("recommendations", this.recommendations);
            map.put("xenstore_data", this.xenstoreData);
            return map;
        }
    }
}

