/*
 * Decompiled with CFR 0.152.
 */
package com.xensource.xenapi;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Marshalling;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.XenAPIObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.SoftReference;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMGuestMetrics
extends XenAPIObject {
    protected final String ref;
    private static final Map<String, SoftReference<VMGuestMetrics>> cache = new HashMap<String, SoftReference<VMGuestMetrics>>();

    private VMGuestMetrics(String ref) {
        this.ref = ref;
    }

    @Override
    public String toWireString() {
        return this.ref;
    }

    protected static synchronized VMGuestMetrics getInstFromRef(String ref) {
        VMGuestMetrics instance;
        if (cache.containsKey(ref) && (instance = cache.get(ref).get()) != null) {
            return instance;
        }
        instance = new VMGuestMetrics(ref);
        cache.put(ref, new SoftReference<VMGuestMetrics>(instance));
        return instance;
    }

    public Record getRecord(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_guest_metrics.get_record";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toVMGuestMetricsRecord(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static VMGuestMetrics getByUuid(Connection c, String uuid) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_guest_metrics.get_by_uuid";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(uuid)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toVMGuestMetrics(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public String getUuid(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_guest_metrics.get_uuid";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, String> getOsVersion(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_guest_metrics.get_os_version";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, String> getPVDriversVersion(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_guest_metrics.get_PV_drivers_version";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Boolean getPVDriversUpToDate(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_guest_metrics.get_PV_drivers_up_to_date";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toBoolean(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, String> getMemory(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_guest_metrics.get_memory";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, String> getDisks(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_guest_metrics.get_disks";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, String> getNetworks(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_guest_metrics.get_networks";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Map<String, String> getOther(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_guest_metrics.get_other";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfStringString(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public Date getLastUpdated(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_guest_metrics.get_last_updated";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(this.ref)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toDate(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static Set<VMGuestMetrics> getAll(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_guest_metrics.get_all";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toSetOfVMGuestMetrics(result);
        }
        throw new Types.BadServerResponse(response);
    }

    public static Map<VMGuestMetrics, Record> getAllRecords(Connection c) throws Types.BadServerResponse, XmlRpcException {
        String method_call = "VM_guest_metrics.get_all_records";
        String session = c.getSessionReference();
        Object[] method_params = new Object[]{Marshalling.toXMLRPC(session)};
        Map response = c.dispatch(method_call, method_params);
        if (response.get("Status").equals("Success")) {
            Object result = response.get("Value");
            return Types.toMapOfVMGuestMetricsVMGuestMetricsRecord(result);
        }
        throw new Types.BadServerResponse(response);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Record
    implements Types.Record {
        public String uuid;
        public Map<String, String> osVersion;
        public Map<String, String> PVDriversVersion;
        public Boolean PVDriversUpToDate;
        public Map<String, String> memory;
        public Map<String, String> disks;
        public Map<String, String> networks;
        public Map<String, String> other;
        public Date lastUpdated;

        public String toString() {
            StringWriter writer = new StringWriter();
            PrintWriter print = new PrintWriter(writer);
            print.printf("%1$20s: %2$s\n", "uuid", this.uuid);
            print.printf("%1$20s: %2$s\n", "osVersion", this.osVersion);
            print.printf("%1$20s: %2$s\n", "PVDriversVersion", this.PVDriversVersion);
            print.printf("%1$20s: %2$s\n", "PVDriversUpToDate", this.PVDriversUpToDate);
            print.printf("%1$20s: %2$s\n", "memory", this.memory);
            print.printf("%1$20s: %2$s\n", "disks", this.disks);
            print.printf("%1$20s: %2$s\n", "networks", this.networks);
            print.printf("%1$20s: %2$s\n", "other", this.other);
            print.printf("%1$20s: %2$s\n", "lastUpdated", this.lastUpdated);
            return writer.toString();
        }

        @Override
        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("uuid", this.uuid);
            map.put("os_version", this.osVersion);
            map.put("PV_drivers_version", this.PVDriversVersion);
            map.put("PV_drivers_up_to_date", this.PVDriversUpToDate);
            map.put("memory", this.memory);
            map.put("disks", this.disks);
            map.put("networks", this.networks);
            map.put("other", this.other);
            map.put("last_updated", this.lastUpdated);
            return map;
        }
    }
}

