/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.domain;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.domain.ServerPool;
import org.ow2.jasmine.vmm.api.DomainMXBean;
import org.ow2.jasmine.vmm.api.InsufficientResourcesException;
import org.ow2.jasmine.vmm.api.InvalidVMConfigException;
import org.ow2.jasmine.vmm.api.ServerPoolMXBean;
import org.ow2.jasmine.vmm.api.VMConfigSpec;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;

public final class Domain
extends ManagedResource
implements DomainMXBean {
    private static Logger logger = Logger.getLogger(Domain.class);
    private String name;
    private final List<DomainMXBean> subDomains = new ArrayList<DomainMXBean>();
    private final List<ServerPoolMXBean> serverPools = new ArrayList<ServerPoolMXBean>();

    public Domain(String name, ObjectName objectName) {
        super(objectName);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<DomainMXBean> getSubDomains() {
        return this.subDomains;
    }

    public void addSubDomain(Domain d) {
        this.subDomains.add(d);
    }

    @Override
    public String getAttribute(String key) {
        return null;
    }

    public void addServerPool(ServerPool pool) {
        this.serverPools.add(pool);
    }

    @Override
    public List<ServerPoolMXBean> getServerPools() {
        return this.serverPools;
    }

    @Override
    public VirtualMachineMXBean provisionVM(VMConfigSpec vmSpec, Map<String, String> constraints, boolean sync) throws InsufficientResourcesException, InvalidVMConfigException {
        VirtualMachineMXBean vm = null;
        logger.info((Object)("Domain " + this.name + ": provisioning VM(name=" + vmSpec.getName() + ",imageID=" + vmSpec.getVmImageUUID() + ")..."));
        ArrayList<VMMException> raisedExceptions = new ArrayList<VMMException>();
        for (ServerPoolMXBean serverPool : this.serverPools) {
            try {
                vm = serverPool.provisionVM(vmSpec, constraints, sync);
                return vm;
            }
            catch (VMMException ex) {
                raisedExceptions.add(ex);
            }
        }
        for (DomainMXBean subDomain : this.subDomains) {
            try {
                vm = subDomain.provisionVM(vmSpec, constraints, sync);
                return vm;
            }
            catch (VMMException ex) {
                raisedExceptions.add(ex);
            }
        }
        for (VMMException ex : raisedExceptions) {
            if (!(ex instanceof InsufficientResourcesException)) continue;
            throw (InsufficientResourcesException)ex;
        }
        for (VMMException ex : raisedExceptions) {
            if (!(ex instanceof InvalidVMConfigException)) continue;
            throw (InvalidVMConfigException)ex;
        }
        return null;
    }
}

