/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.driver.Driver;
import org.ow2.jasmine.vmm.agent.main.VirtManagerAgent;

public class DriverFactory {
    protected static Logger logger = Logger.getLogger(DriverFactory.class);
    private static final String DRIVERMAP_FILENAME = "drivermap.properties";
    private static DriverFactory instance;
    private Map<String, String> map = new HashMap<String, String>();

    public static DriverFactory getInstance() {
        if (instance == null) {
            instance = new DriverFactory();
        }
        return instance;
    }

    private DriverFactory() {
        Properties properties = new Properties();
        String agentPropFileName = "etc" + File.separator + DRIVERMAP_FILENAME;
        try {
            properties.load(new FileInputStream(new File(VirtManagerAgent.vmmHome, agentPropFileName)));
        }
        catch (IOException ex) {
            logger.warn((Object)"Cannot find drivermap.properties file");
        }
        Enumeration<Object> it = properties.keys();
        while (it.hasMoreElements()) {
            String driverAlias = (String)it.nextElement();
            String driverClass = properties.getProperty(driverAlias);
            this.map.put(driverAlias, driverClass);
            logger.info((Object)("Added alias " + driverAlias + " for " + driverClass));
        }
        if (!this.map.containsKey("xen")) {
            this.map.put("xen", "org.ow2.jasmine.vmmapi.driver.xen.XenDriver");
        }
        if (!this.map.containsKey("vmware-vi")) {
            this.map.put("vmware-vi", "org.ow2.jasmine.vmmapi.driver.vmware.VMwareDriver");
        }
        if (!this.map.containsKey("dummy")) {
            this.map.put("dummy", "org.ow2.jasmine.vmmapi.driver.dummy.DummyDriver");
        }
    }

    public Driver newDriver(String driverName) {
        String driverClassName = this.map.get(driverName);
        Driver driver = null;
        if (driverClassName != null) {
            try {
                driver = (Driver)Class.forName(driverClassName).newInstance();
            }
            catch (Exception ex) {
                logger.error((Object)("Failed to instance driver " + driverName), (Throwable)ex);
            }
        } else {
            logger.error((Object)("Unknown driver " + driverName));
        }
        return driver;
    }
}

