/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.xen;

import java.util.UUID;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.driver.util.RemoteExec;
import org.ow2.jasmine.vmm.agent.driver.xen.XenHost;
import org.ow2.jasmine.vmm.api.VMConfigSpec;

public class XenSSH {
    static Logger logger = Logger.getLogger(XenSSH.class);

    public static RemoteExec.Result createVM(XenHost host, String vmName, VMConfigSpec vmSpec, String templateFileName) throws RemoteExec.SshException {
        String command = "createVM -d " + vmSpec.getDiskSizeMB() + " -t " + templateFileName + " -m " + vmSpec.getMemorySizeMB() + " -c " + vmSpec.getNumVCPU() + " -u " + UUID.randomUUID().toString() + " " + vmName;
        logger.debug((Object)("launching command " + command));
        return RemoteExec.commandAsRoot(host.getHostName(), host.getSshAuthInfo(), command);
    }

    public static RemoteExec.Result suspendVM(XenHost host, String vmName) throws RemoteExec.SshException {
        String command = "suspendVM " + vmName;
        logger.debug((Object)("Launching command " + command));
        return RemoteExec.commandAsRoot(host.getHostName(), host.getSshAuthInfo(), command);
    }

    public static RemoteExec.Result resumeVM(XenHost host, String vmName) throws RemoteExec.SshException {
        String command = "resumeVM " + vmName;
        logger.debug((Object)("Launching command " + command));
        return RemoteExec.commandAsRoot(host.getHostName(), host.getSshAuthInfo(), command);
    }

    public static RemoteExec.Result startVM(XenHost host, String vmName) throws RemoteExec.SshException {
        String command = "startVM " + vmName;
        logger.debug((Object)("Launching command " + command));
        return RemoteExec.commandAsRoot(host.getHostName(), host.getSshAuthInfo(), command);
    }

    public static RemoteExec.Result shutdownVM(XenHost host, String vmName) throws RemoteExec.SshException {
        String command = "shutdownVM " + vmName;
        logger.debug((Object)("Launching command " + command));
        return RemoteExec.commandAsRoot(host.getHostName(), host.getSshAuthInfo(), command);
    }

    public static RemoteExec.Result destroyVM(XenHost host, String vmName) throws RemoteExec.SshException {
        String command = "destroyVM " + vmName;
        logger.debug((Object)("Launching command " + command));
        return RemoteExec.commandAsRoot(host.getHostName(), host.getSshAuthInfo(), command);
    }

    public static RemoteExec.Result migrateVM(XenHost sourceHost, String vmName, String targetHostName) throws RemoteExec.SshException {
        String command = "migrateVM " + vmName + " " + targetHostName;
        logger.debug((Object)("Launching command " + command));
        return RemoteExec.commandAsRoot(sourceHost.getHostName(), sourceHost.getSshAuthInfo(), command);
    }

    public static RemoteExec.Result postMigrateVM(XenHost sourceHost, String vmName, String targetHostName) throws RemoteExec.SshException {
        String command = "postMigrateVM " + vmName + " " + targetHostName;
        logger.debug((Object)("Launching command " + command));
        return RemoteExec.commandAsRoot(sourceHost.getHostName(), sourceHost.getSshAuthInfo(), command);
    }
}

