/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.main;

import java.lang.reflect.Proxy;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.ow2.jasmine.vmm.api.DomainMXBean;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.ServerPoolMXBean;
import org.ow2.jasmine.vmm.api.VMMAgentMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineImageMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;

public class AgentControl {
    private static final int DEFAULT_PORT = 9999;
    private static final String DEFAULT_HOST = "localhost";

    public static void main(String[] args) {
        String s;
        int i;
        int port = 9999;
        String host = DEFAULT_HOST;
        for (i = 0; i < args.length && (s = args[i]).startsWith("-"); ++i) {
            if (s.equals("-port")) {
                if (i < args.length - 1) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                AgentControl.printUsageAndExit();
                continue;
            }
            if (!s.equals("-host")) continue;
            if (i < args.length - 1) {
                host = args[++i];
                continue;
            }
            AgentControl.printUsageAndExit();
        }
        if (i != args.length - 1) {
            AgentControl.printUsageAndExit();
        }
        String command = args[i];
        try {
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + host + ":" + port + "/server");
            JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
            MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
            ObjectName agentObjectName = new ObjectName("org.ow2.jasmine.vmmapi:type=Agent");
            VMMAgentMXBean agentMBean = JMX.newMXBeanProxy(mbsc, agentObjectName, VMMAgentMXBean.class);
            if (command.equals("list")) {
                DomainMXBean domain = agentMBean.getRootDomain();
                AgentControl.dumpDomain(domain);
            } else if (command.equals("shutdown")) {
                agentMBean.shutdown();
            } else {
                AgentControl.printUsageAndExit();
            }
            jmxc.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void dumpDomain(DomainMXBean domain) throws Exception {
        System.out.println("Domain " + domain.getName() + "(" + domain.getObjectName() + ")");
        for (ServerPoolMXBean rp : domain.getServerPools()) {
            System.out.println("\tPool " + rp.getName() + " (" + rp.getObjectName() + ")");
            VirtualMachineImageStoreMXBean imageStore = rp.getVMImageStore();
            System.out.println("\t\tVMImageStore " + imageStore.getName());
            for (VirtualMachineImageMXBean image : imageStore.listVMImageTemplates()) {
                System.out.println("\t\t\tImage UUID=" + image.getUUID() + " name=" + image.getName());
            }
            System.out.println("\t\tHosts:");
            for (HostMXBean host : rp.getManagedHosts()) {
                System.out.println("\t\t\tHost " + host.getHostName() + " (" + AgentControl.proxyToObjectName(host) + ")");
                for (VirtualMachineMXBean vm : host.getResidentVMs()) {
                    try {
                        System.out.println("\t\t\t\tVM " + vm.getNameLabel() + " (" + AgentControl.proxyToObjectName(vm) + ")");
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        for (DomainMXBean subDomain : domain.getSubDomains()) {
            AgentControl.dumpDomain(subDomain);
        }
    }

    private static ObjectName proxyToObjectName(Object proxy) {
        MBeanServerInvocationHandler ih = (MBeanServerInvocationHandler)Proxy.getInvocationHandler(proxy);
        return ih.getObjectName();
    }

    private static void printUsageAndExit() {
        System.out.println("Usage: java org.ow2.jasmine.vmm.agent.main.AgentControl [-port <port>] [-host <host>] <command>");
        System.out.println("       <command> : shutdown | list");
        System.exit(1);
    }
}

