/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.domain;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.domain.policy.PolicyRegistry;
import org.ow2.jasmine.vmm.agent.domain.policy.VMPlacementPolicy;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.InsufficientResourcesException;
import org.ow2.jasmine.vmm.api.InvalidVMConfigException;
import org.ow2.jasmine.vmm.api.ServerPoolMXBean;
import org.ow2.jasmine.vmm.api.VMConfigSpec;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;

public abstract class ServerPool
extends ManagedResource
implements ServerPoolMXBean {
    protected static Logger logger = Logger.getLogger(ServerPool.class);
    protected String name;
    protected final List<HostMXBean> hosts = new ArrayList<HostMXBean>();
    protected VMPlacementPolicy placementPolicy;

    public ServerPool(String name, ObjectName objectName) {
        super(objectName);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract HostMXBean newHost(String var1, Map<String, String> var2);

    protected void addHost(HostMXBean host) {
        this.hosts.add(host);
        logger.info((Object)("Added host " + host.getHostName()));
    }

    public void setProvisioningPolicy(String policyId) {
        if (policyId != null) {
            this.placementPolicy = PolicyRegistry.getInstance().newPolicy(policyId);
            logger.info((Object)("Domain " + this.name + ": policy set to " + policyId));
        } else {
            this.placementPolicy = PolicyRegistry.getInstance().newDefaultPolicy();
        }
    }

    public VirtualMachineMXBean provisionVM(VMConfigSpec vmSpec, Map<String, String> constraints, boolean sync) throws InsufficientResourcesException, InvalidVMConfigException, VMMException {
        if (this.getVMImageStore().lookUpByUUID(vmSpec.getVmImageUUID()) == null) {
            throw new InvalidVMConfigException("Illegal VMImage UUID " + vmSpec.getVmImageUUID());
        }
        HostMXBean candidateHost = this.placementPolicy.placeVM(this, vmSpec);
        if (candidateHost == null) {
            throw new InsufficientResourcesException();
        }
        return candidateHost.createVM(vmSpec, sync);
    }

    public abstract VirtualMachineImageStoreMXBean getVMImageStore();

    public List<HostMXBean> getManagedHosts() {
        return this.hosts;
    }
}

