/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.dummy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.driver.dummy.DummyServerPool;
import org.ow2.jasmine.vmm.agent.driver.dummy.DummyVirtualMachine;
import org.ow2.jasmine.vmm.agent.driver.util.ResourceUsageHelper;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.InsufficientResourcesException;
import org.ow2.jasmine.vmm.api.InvalidVMConfigException;
import org.ow2.jasmine.vmm.api.ResourceUsage;
import org.ow2.jasmine.vmm.api.ServerPoolMXBean;
import org.ow2.jasmine.vmm.api.VMConfigSpec;
import org.ow2.jasmine.vmm.api.VMCustomizationSpec;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;

class DummyHost
extends ManagedResource
implements HostMXBean {
    static Logger logger = Logger.getLogger(DummyHost.class);
    private List<DummyVirtualMachine> vms = new CopyOnWriteArrayList<DummyVirtualMachine>();
    private static ExecutorService executorService = Executors.newFixedThreadPool(3);
    private Timer perfTimer;
    private String hostName;
    private final ObjectName objectName;
    private int numCPU = 4;
    private int freeMemoryMB = 4096;
    private DummyServerPool pool;
    HashMap<String, String> hypervisorInfo;
    HashMap<String, String> cpuInfo;
    private Set<HostMXBean.PerfMetric> currentMonitoredMetrics;
    private long currentMonitoringPeriod = 1000L;

    public DummyHost(DummyServerPool pool, String hostName, ObjectName objectName) {
        super(objectName);
        this.pool = pool;
        this.hostName = hostName;
        this.objectName = objectName;
        this.startPerfMonitor();
    }

    public ServerPoolMXBean getServerPool() {
        return this.pool;
    }

    private void addVM(DummyVirtualMachine vm) {
        this.vms.add(vm);
    }

    private void removeVM(DummyVirtualMachine vm) {
        this.vms.remove(vm);
    }

    void postMigrateVM(DummyVirtualMachine vm, DummyHost newHost) {
        this.removeVM(vm);
        newHost.addVM(vm);
        this.freeMemoryMB = (int)((long)this.freeMemoryMB + vm.getMemorySizeMB());
        newHost.freeMemoryMB = (int)((long)newHost.freeMemoryMB - vm.getMemorySizeMB());
    }

    public void postDestroyVM(DummyVirtualMachine vm) {
        this.removeVM(vm);
        this.freeMemoryMB = (int)((long)this.freeMemoryMB + vm.getMemorySizeMB());
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    public synchronized void onDestroyVM(DummyVirtualMachine vm) {
        try {
            AgentCommon.getMBeanServer().unregisterMBean(vm.getObjectName());
        }
        catch (Exception ex) {
            logger.error((Object)"Cannot unregister VM MBean", (Throwable)ex);
        }
        this.removeVM(vm);
        this.freeMemoryMB = (int)((long)this.freeMemoryMB + vm.getMemorySizeMB());
        this.emitNotification("vm.del", "Destroyed", vm.getObjectName());
        logger.info((Object)("destroyed VM " + vm.getObjectName()));
    }

    public VirtualMachineMXBean createVM(VMConfigSpec vmSpec, boolean sync) throws InsufficientResourcesException, InvalidVMConfigException, VMMException {
        final VMConfigSpec vmSpec2 = new VMConfigSpec(vmSpec);
        for (DummyVirtualMachine dvm : this.vms) {
            if (!dvm.getNameLabel().equals(vmSpec2.getName())) continue;
            throw new InvalidVMConfigException("VM name already exists");
        }
        if (!sync) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        DummyHost.this.createVM2(vmSpec2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            return null;
        }
        return this.createVM2(vmSpec2);
    }

    private VirtualMachineMXBean createVM2(VMConfigSpec vmSpec) throws InsufficientResourcesException, InvalidVMConfigException, VMMException {
        DummyVirtualMachine vm = null;
        try {
            Thread.sleep(5000L);
            Random random = new Random(System.currentTimeMillis());
            String uuid = Integer.toString(random.nextInt(10000));
            ObjectName vmName = MBeanObjectNamer.makeVirtualMachineName(this.getServerPool().getPath() + "/" + vmSpec.getName(), uuid);
            vm = new DummyVirtualMachine(vmSpec.getName(), uuid, vmName, this);
            this.addVM(vm);
            vm.setDiskSizeMB(vmSpec.getDiskSizeMB());
            vm.setNumVCPUs(vmSpec.getNumVCPU());
            vm.setMemorySizeMB((int)vmSpec.getMemorySizeMB());
            vm.addUserData("imageID", vmSpec.getVmImageUUID());
            AgentCommon.getMBeanServer().registerMBean(vm, vm.getObjectName());
            logger.info((Object)("VM Creation: registered VirtualMachineMBean " + vm.getObjectName()));
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to create VM", (Throwable)ex);
            return null;
        }
        this.emitNotification("vm.add", "Created", vm.getObjectName());
        this.freeMemoryMB = (int)((long)this.freeMemoryMB - vmSpec.getMemorySizeMB());
        ((DummyServerPool.DummyVirtualMachineImageStore)this.pool.getVMImageStore()).updateFreeSpace(-vmSpec.getDiskSizeMB());
        return vm;
    }

    public VirtualMachineMXBean cloneVM(final DummyVirtualMachine sourceVM, final String clonedVMName, final VMCustomizationSpec custSpec, boolean sync) throws InsufficientResourcesException, InvalidVMConfigException, VMMException {
        for (DummyVirtualMachine dvm : this.vms) {
            if (!dvm.getNameLabel().equals(clonedVMName)) continue;
            throw new InvalidVMConfigException("VM name already exists");
        }
        if (!sync) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        DummyHost.this.cloneVM2(sourceVM, clonedVMName, custSpec);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            return null;
        }
        return this.cloneVM2(sourceVM, clonedVMName, custSpec);
    }

    private VirtualMachineMXBean cloneVM2(DummyVirtualMachine sourceVM, String clonedVMName, VMCustomizationSpec custSpec) throws InsufficientResourcesException, InvalidVMConfigException, VMMException {
        DummyVirtualMachine vm = null;
        try {
            Thread.sleep(5000L);
            Random random = new Random(System.currentTimeMillis());
            String uuid = Integer.toString(random.nextInt(10000));
            ObjectName vmName = MBeanObjectNamer.makeVirtualMachineName(this.getServerPool().getPath() + "/" + clonedVMName, uuid);
            vm = new DummyVirtualMachine(clonedVMName, uuid, vmName, this);
            this.addVM(vm);
            vm.setDiskSizeMB(sourceVM.getDiskSizeMB());
            vm.setNumVCPUs(sourceVM.getNumVCPUs());
            vm.setMemorySizeMB((int)sourceVM.getMemorySizeMB());
            AgentCommon.getMBeanServer().registerMBean(vm, vm.getObjectName());
            logger.info((Object)("VM Cloning: registered VirtualMachineMBean " + vm.getObjectName()));
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to clone VM", (Throwable)ex);
            return null;
        }
        this.emitNotification("vm.add", "Created", vm.getObjectName());
        this.freeMemoryMB = (int)((long)this.freeMemoryMB - sourceVM.getMemorySizeMB());
        ((DummyServerPool.DummyVirtualMachineImageStore)this.pool.getVMImageStore()).updateFreeSpace(-sourceVM.getDiskSizeMB());
        return vm;
    }

    public Map<String, String> getHypervisorInfo() {
        if (this.hypervisorInfo == null) {
            this.hypervisorInfo = new HashMap();
            this.hypervisorInfo.put("name", "DummyHypervisor");
            this.hypervisorInfo.put("vendor", "");
            this.hypervisorInfo.put("version", "1.0");
        }
        return this.hypervisorInfo;
    }

    public Map<String, String> getCPUInfo() {
        if (this.cpuInfo == null) {
            this.cpuInfo = new HashMap();
            this.cpuInfo.put("model", "Core 2 Duo");
            this.cpuInfo.put("speed", "2330");
            this.cpuInfo.put("vendor", "Intel");
        }
        return this.cpuInfo;
    }

    public int getNumCPU() {
        return this.numCPU;
    }

    public float[] getLoadPerCPU() {
        return new float[]{0.0f, 0.0f};
    }

    public float getCPULoad() {
        float load = 0.0f;
        for (DummyVirtualMachine vm : this.vms) {
            load += vm.getCPULoad();
        }
        return Math.min(1.0f, load);
    }

    public Map<String, Float> getVMCPULoads() {
        HashMap<String, Float> cpuLoads = new HashMap<String, Float>();
        for (DummyVirtualMachine vm : this.vms) {
            cpuLoads.put(vm.getNameLabel(), Float.valueOf(vm.getResourceUsage().getCpuLoad()));
        }
        return cpuLoads;
    }

    public long getFreeMemoryMB() {
        return this.freeMemoryMB;
    }

    public String getHostName() {
        return this.hostName;
    }

    public List<VirtualMachineMXBean> getResidentVMs() {
        ArrayList<VirtualMachineMXBean> vmList = new ArrayList<VirtualMachineMXBean>();
        for (DummyVirtualMachine vm : this.vms) {
            vmList.add(vm);
        }
        return vmList;
    }

    public long getTotalMemoryMB() {
        return 4096L;
    }

    public VirtualMachineImageStoreMXBean getVMImageStore() {
        return this.pool.getVMImageStore();
    }

    public String getUUID() {
        return null;
    }

    public Map<String, ResourceUsage> getVMResourceUsage() {
        HashMap<String, ResourceUsage> result = new HashMap<String, ResourceUsage>();
        for (DummyVirtualMachine vm : this.vms) {
            result.put(vm.getNameLabel(), vm.getResourceUsage());
        }
        return result;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"vm.state", "vm.add", "vm.del", "log", "vm.error", "host.perfreport"}, Notification.class.getName(), "Host event")};
    }

    public void configurePerfMonitor(Set<HostMXBean.PerfMetric> metricsOfInterest, long periodMillis) {
        this.stopPerfMonitor();
        if (periodMillis < 1000L) {
            periodMillis = 1000L;
        }
        if (metricsOfInterest.contains(HostMXBean.PerfMetric.VM_CPU_LOAD)) {
            this.currentMonitoringPeriod = periodMillis;
            this.currentMonitoredMetrics = metricsOfInterest;
            this.startPerfMonitor();
        }
    }

    private void startPerfMonitor() {
        if (this.perfTimer == null) {
            logger.info((Object)("Host " + this.hostName + ": starting periodic perf monitor task"));
            this.perfTimer = new Timer();
            this.perfTimer.schedule((TimerTask)new PerfTimerTask(), 0L, this.currentMonitoringPeriod);
        }
    }

    private void stopPerfMonitor() {
        if (this.perfTimer != null) {
            logger.info((Object)("Host " + this.hostName + ": stopping periodic perf monitor task"));
            this.perfTimer.cancel();
        }
        this.perfTimer = null;
    }

    private class PerfTimerTask
    extends TimerTask {
        private PerfTimerTask() {
        }

        @Override
        public void run() {
            HashMap<String, CompositeData> result = new HashMap<String, CompositeData>();
            try {
                for (DummyVirtualMachine vm : DummyHost.this.vms) {
                    CompositeData cd = (CompositeData)ResourceUsageHelper.serialize(vm.getResourceUsage());
                    result.put(vm.getNameLabel(), cd);
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                return;
            }
            DummyHost.this.emitNotification("host.perfreport", "Resource Usage", result);
        }
    }
}

