/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.hyperv;

import com.hyper9.jwbem.SWbemLocator;
import com.hyper9.jwbem.SWbemMethod;
import com.hyper9.jwbem.SWbemObject;
import com.hyper9.jwbem.SWbemObjectSet;
import com.hyper9.jwbem.SWbemProperty;
import com.hyper9.jwbem.SWbemServices;
import com.hyper9.jwbem.msvm.MsvmObject;
import com.hyper9.jwbem.msvm.virtualsystem.MsvmComputerSystem;
import com.hyper9.jwbem.msvm.virtualsystem.MsvmVirtualSystemSettingData;
import com.hyper9.jwbem.msvm.virtualsystemmanagement.MsvmVirtualSystemManagementService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.management.InstanceNotFoundException;
import org.apache.log4j.Logger;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIProgId;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.impls.JIObjectFactory;
import org.jinterop.dcom.impls.automation.IJIDispatch;
import org.jinterop.dcom.impls.automation.IJIEnumVariant;
import org.ow2.jasmine.vmm.agent.driver.hyperv.HyperVHost;
import org.ow2.jasmine.vmm.agent.driver.hyperv.HyperVServerPool;
import org.ow2.jasmine.vmm.api.BadVMPowerStateException;

public class HyperVConnection {
    static Logger logger = Logger.getLogger(HyperVConnection.class);
    private String hostname;
    private String username;
    private String password;
    private IJIDispatch services_dispatch;
    private SWbemServices services = null;

    public HyperVConnection(String hostName, String username, String password) {
        this.username = username;
        this.password = password;
        this.hostname = hostName;
        this.connectToHyperv();
        this.connectToWin32();
    }

    public synchronized void connectToHyperv() {
        logger.debug((Object)"connectHyperV");
        SWbemLocator locator = new SWbemLocator();
        try {
            this.services = locator.connect(this.hostname, this.hostname, "ROOT\\Virtualization", this.username, this.password);
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to establish Hyper-V-API connection with host " + this.hostname + " with login " + this.username), (Throwable)ex);
        }
    }

    public synchronized void connectToWin32() {
        logger.debug((Object)"connectToWin32");
        try {
            JISession session = JISession.createSession((String)this.hostname, (String)this.username, (String)this.password);
            session.useSessionSecurity(true);
            JIComServer comStub = new JIComServer(JIProgId.valueOf((String)"WbemScripting.SWbemLocator"), this.hostname, session);
            IJIComObject unknown = comStub.createInstance();
            IJIComObject comObject = unknown.queryInterface("76A6415B-CB41-11d1-8B02-00600806D9B6");
            IJIDispatch idispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)comObject.queryInterface("00020400-0000-0000-c000-000000000046"));
            JIVariant[] results = idispatch.callMethodA("ConnectServer", new Object[]{new JIString(this.hostname), new JIString("ROOT\\CIMV2"), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), new Integer(0), JIVariant.OPTIONAL_PARAM()});
            this.services_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)results[0].getObjectAsComObject());
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to establish Hyper-V-API connection with host " + this.hostname + " with login " + this.username), (Throwable)ex);
        }
    }

    public synchronized void closeConnection() {
        logger.debug((Object)"close");
        if (this.services_dispatch.getAssociatedSession() != null) {
            try {
                JISession.destroySession((JISession)this.services_dispatch.getAssociatedSession());
            }
            catch (JIException ex) {
                logger.error((Object)"Failed to close Hyper-V-API connection");
            }
        }
        if (this.services.getLocator() != null) {
            this.services.getLocator().disconnect();
        }
    }

    private synchronized void testConnectionHyperv() {
        try {
            String wql = "SELECT * FROM Msvm_VirtualSystemManagementService";
            this.services.execQuery(wql, MsvmObject.class);
        }
        catch (Exception ex) {
            logger.debug((Object)"Re-open the 'ROOT\\Virtualization' connection");
            this.connectToHyperv();
        }
    }

    private synchronized void testConnectionWin32() {
        try {
            String wql = "SELECT * FROM Win32_Processor";
            this.services_dispatch.callMethodA("ExecQuery", new Object[]{new JIString(wql), new JIString("WQL"), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
        }
        catch (Exception ex) {
            logger.debug((Object)"Re-open the 'ROOT\\CIMV2' connection");
            this.connectToWin32();
        }
    }

    public synchronized Set<VM> getAllVM() throws JIException {
        logger.info((Object)"getAllVM");
        HashSet<VM> setVM = new HashSet<VM>();
        String wql = "SELECT * FROM Msvm_ComputerSystem WHERE Caption = 'Virtual machine'";
        this.testConnectionHyperv();
        SWbemObjectSet compSysSet = this.services.execQuery(wql, MsvmComputerSystem.class);
        for (MsvmComputerSystem cs : compSysSet) {
            VM vm = new VM();
            vm.setNameLabel(cs.getElementName());
            vm.setUuid(cs.getName());
            setVM.add(vm);
        }
        return setVM;
    }

    public synchronized boolean startVM(HyperVHost host, String ElementName) throws Exception {
        logger.info((Object)"startVM");
        return this.changeState(2, host, ElementName);
    }

    public synchronized boolean shutdownVM(HyperVHost host, String ElementName) throws Exception {
        logger.info((Object)"shutdownVM");
        return this.changeState(3, host, ElementName);
    }

    public synchronized boolean rebootVM(HyperVHost host, String ElementName) throws Exception {
        logger.info((Object)"rebootVM");
        return this.changeState(10, host, ElementName);
    }

    public synchronized boolean suspendVM(HyperVHost host, String ElementName) throws Exception {
        logger.info((Object)"suspendVM");
        return this.changeState(32769, host, ElementName);
    }

    public synchronized boolean destroyVM(HyperVHost host, String ElementName) throws Exception {
        logger.info((Object)"destroyVM");
        String wql = "SELECT * FROM Msvm_ComputerSystem WHERE ElementName = '" + ElementName + "'";
        this.testConnectionHyperv();
        SWbemObjectSet compSysSet = this.services.execQuery(wql, MsvmComputerSystem.class);
        if (compSysSet.getSize() != 1) {
            logger.debug((Object)("VM " + ElementName + " missing on " + host));
            throw new Exception("VM " + ElementName + " missing on " + host);
        }
        MsvmComputerSystem cs = (MsvmComputerSystem)compSysSet.iterator().next();
        wql = "SELECT * FROM Msvm_VirtualSystemManagementService";
        SWbemObjectSet virtualSystemSet = this.services.execQuery(wql, MsvmVirtualSystemManagementService.class);
        MsvmVirtualSystemManagementService vs = (MsvmVirtualSystemManagementService)virtualSystemSet.iterator().next();
        SWbemMethod destroyVirtualSystemMethod = null;
        for (SWbemMethod m : vs.getMethods()) {
            if (!m.getName().equals("DestroyVirtualSystem")) continue;
            destroyVirtualSystemMethod = m;
        }
        SWbemObject inParams = destroyVirtualSystemMethod.getInParameters();
        inParams.getObjectDispatcher().put("ComputerSystem", new JIVariant(cs.getObjectPath().getPath(), true));
        Object[] methodParams = new Object[]{new JIString("DestroyVirtualSystem"), new JIVariant((IJIComObject)inParams.getObjectDispatcher()), new Integer(0), JIVariant.NULL()};
        JIVariant variant3 = vs.getObjectDispatcher().callMethodA("ExecMethod_", methodParams)[0];
        IJIDispatch wbemProperty_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)variant3.getObjectAsComObject());
        JIVariant returnValue = wbemProperty_dispatch.get("ReturnValue");
        int resultat = returnValue.getObjectAsInt();
        logger.debug((Object)("resultat = " + resultat));
        return resultat == 0;
    }

    private synchronized boolean changeState(int state, HyperVHost host, String ElementName) throws Exception {
        String wql = "SELECT * FROM Msvm_ComputerSystem WHERE ElementName = '" + ElementName + "'";
        this.testConnectionHyperv();
        SWbemObjectSet compSysSet = this.services.execQuery(wql, MsvmComputerSystem.class);
        if (compSysSet.getSize() != 1) {
            logger.debug((Object)("VM " + ElementName + " missing on " + host));
            throw new Exception("VM " + ElementName + " missing on " + host);
        }
        MsvmComputerSystem cs = (MsvmComputerSystem)compSysSet.iterator().next();
        SWbemMethod requestStateChange = null;
        for (SWbemMethod m : cs.getMethods()) {
            if (!m.getName().equals("RequestStateChange")) continue;
            requestStateChange = m;
        }
        SWbemObject inParams = requestStateChange.getInParameters();
        inParams.getObjectDispatcher().put("RequestedState", new JIVariant(state));
        inParams.getObjectDispatcher().put("TimeoutPeriod", JIVariant.NULL());
        Object[] methodParams = new Object[]{new JIString("RequestStateChange"), new JIVariant((IJIComObject)inParams.getObjectDispatcher()), new Integer(0), JIVariant.NULL()};
        JIVariant result = cs.getObjectDispatcher().callMethodA("ExecMethod_", methodParams)[0];
        IJIDispatch dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)result.getObjectAsComObject());
        JIVariant returnValue = dispatch.get("ReturnValue");
        int resultat = returnValue.getObjectAsInt();
        logger.debug((Object)("resultat = " + resultat));
        if (resultat != 0) {
            if (resultat == 32775) {
                throw new BadVMPowerStateException("Bad power state for VM " + ElementName);
            }
            return resultat == 4096;
        }
        return true;
    }

    public synchronized boolean createVM(String vmName, String VHDPath) throws JIException {
        SWbemObjectSet virtualSettingSet;
        MsvmVirtualSystemSettingData virtualSettingData;
        logger.info((Object)"createVM");
        String wql = "SELECT * FROM Msvm_VirtualSystemManagementService";
        this.testConnectionHyperv();
        SWbemObjectSet virtualSystemSet = this.services.execQuery(wql, MsvmVirtualSystemManagementService.class);
        MsvmVirtualSystemManagementService virtualSystem = (MsvmVirtualSystemManagementService)virtualSystemSet.iterator().next();
        JIVariant[] var = this.services.getObjectDispatcher().callMethodA("Get", new Object[]{new JIVariant("Msvm_VirtualSystemGlobalSettingData"), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
        IJIDispatch dispach = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)var[0].getObjectAsComObject());
        JIVariant varnt = dispach.callMethodA("SpawnInstance_");
        IJIDispatch dispath = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)varnt.getObjectAsComObject());
        MsvmObject globalSettingData = new MsvmObject(dispath, this.services);
        globalSettingData.getObjectDispatcher().put("ElementName", new JIVariant(vmName));
        if (!this.defineVirtualSystem(virtualSystem, globalSettingData)) {
            return false;
        }
        wql = "SELECT * FROM Msvm_ComputerSystem WHERE ElementName = '" + vmName + "'";
        SWbemObjectSet compSysSet = this.services.execQuery(wql, MsvmComputerSystem.class);
        MsvmComputerSystem compSys = (MsvmComputerSystem)compSysSet.iterator().next();
        if (!this.associateVHD(vmName, VHDPath, virtualSystem, compSys, virtualSettingData = (MsvmVirtualSystemSettingData)(virtualSettingSet = this.services.execQuery(wql = "SELECT * FROM Msvm_VirtualSystemSettingData WHERE ElementName = '" + vmName + "'", MsvmVirtualSystemSettingData.class)).iterator().next())) {
            return false;
        }
        return this.addNetworkAdapter(vmName, virtualSystem, compSys);
    }

    private synchronized boolean defineVirtualSystem(MsvmVirtualSystemManagementService virtualSystem, MsvmObject globalSettingData) throws JIException {
        SWbemMethod defineVirtualSystem = null;
        for (SWbemMethod m : virtualSystem.getMethods()) {
            if (!m.getName().equals("DefineVirtualSystem")) continue;
            defineVirtualSystem = m;
        }
        JIVariant[] varnt = globalSettingData.getObjectDispatcher().callMethodA("GetText_", new Object[]{new JIVariant(1), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
        String settingDataText = varnt[0].getObjectAsString().getString();
        SWbemObject inParams = defineVirtualSystem.getInParameters();
        inParams.getObjectDispatcher().put("SystemSettingdata", new JIVariant(settingDataText));
        inParams.getObjectDispatcher().put("ResourceSettingData", JIVariant.OPTIONAL_PARAM());
        inParams.getObjectDispatcher().put("SourceSetting", JIVariant.OPTIONAL_PARAM());
        Object[] methodParams = new Object[]{new JIString("DefineVirtualSystem"), new JIVariant((IJIComObject)inParams.getObjectDispatcher()), new Integer(0), JIVariant.NULL()};
        JIVariant result = virtualSystem.getObjectDispatcher().callMethodA("ExecMethod_", methodParams)[0];
        IJIDispatch dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)result.getObjectAsComObject());
        int resultat = dispatch.get("ReturnValue").getObjectAsInt();
        logger.debug((Object)("resultat = " + resultat));
        return resultat == 0;
    }

    private synchronized boolean associateVHD(String vmName, String VHDPath, MsvmVirtualSystemManagementService virtualSystem, MsvmComputerSystem compSys, MsvmVirtualSystemSettingData virtualSettingData) throws JIException {
        logger.info((Object)"associateVHD");
        JIVariant[] varnt = this.services.getObjectDispatcher().callMethodA("AssociatorsOf", new Object[]{new JIVariant(virtualSettingData.getObjectPath().getPath()), JIVariant.OPTIONAL_PARAM(), new JIVariant("Msvm_ResourceAllocationSettingData")});
        IJIDispatch wbemObjectSet_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)varnt[0].getObjectAsComObject());
        JIVariant variant = wbemObjectSet_dispatch.get("_NewEnum");
        IJIComObject object2 = JIObjectFactory.narrowObject((IJIComObject)variant.getObjectAsComObject());
        IJIEnumVariant enumVARIANT = (IJIEnumVariant)JIObjectFactory.narrowObject((IJIComObject)object2.queryInterface("00020404-0000-0000-C000-000000000046"));
        JIVariant Count = wbemObjectSet_dispatch.get("Count");
        int count = Count.getObjectAsInt();
        for (int i = 0; i < count; ++i) {
            Object[] arrayObj;
            Object[] values = enumVARIANT.next(1);
            JIArray array = (JIArray)values[0];
            for (Object element : arrayObj = (Object[])array.getArrayInstance()) {
                JIVariant rasdVariant = (JIVariant)element;
                IJIDispatch rasd_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)rasdVariant.getObjectAsComObject());
                JIVariant addressVariant = rasd_dispatch.get("Address");
                if (addressVariant.getType() == 1 || !addressVariant.getObjectAsString2().equals("0") || !rasd_dispatch.get("ResourceSubType").getObjectAsString2().equals("Microsoft Emulated IDE Controller")) continue;
                MsvmObject IDEController = new MsvmObject(rasd_dispatch, this.services);
                MsvmObject diskRASDDefault = this.newVMRasd("Microsoft Synthetic Disk Drive");
                diskRASDDefault.getObjectDispatcher().put("Parent", new JIVariant(IDEController.getObjectPath().getPath()));
                diskRASDDefault.getObjectDispatcher().put("Address", new JIVariant("0"));
                JIVariant[] varint = diskRASDDefault.getObjectDispatcher().callMethodA("GetText_", new Object[]{new JIVariant(1), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
                String diskRASDDefaultText = varint[0].getObjectAsString().getString();
                SWbemMethod addVirtualSystemResources = null;
                for (SWbemMethod m : virtualSystem.getMethods()) {
                    if (!m.getName().equals("AddVirtualSystemResources")) continue;
                    addVirtualSystemResources = m;
                    break;
                }
                SWbemObject inParams = addVirtualSystemResources.getInParameters();
                inParams.getObjectDispatcher().put("TargetSystem", new JIVariant(compSys.getObjectPath().getPath()));
                inParams.getObjectDispatcher().put("ResourceSettingData", new JIVariant(new JIArray((Object)new JIString[]{new JIString(diskRASDDefaultText)}, true)));
                Object[] methodParams = new Object[]{new JIString("AddVirtualSystemResources"), new JIVariant((IJIComObject)inParams.getObjectDispatcher()), new Integer(0), JIVariant.NULL()};
                JIVariant result = virtualSystem.getObjectDispatcher().callMethodA("ExecMethod_", methodParams)[0];
                IJIDispatch dispach1 = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)result.getObjectAsComObject());
                JIVariant returnValue = dispach1.get("ReturnValue");
                int resultat = returnValue.getObjectAsInt();
                logger.debug((Object)("resultat = " + resultat));
                if (resultat != 0) {
                    return false;
                }
                JIVariant NewResourcesArray = dispach1.get("NewResources");
                JIVariant newResources = ((JIVariant[])NewResourcesArray.getObjectAsArray().getArrayInstance())[0];
                String newDiskDrivePath = newResources.getObjectAsString2();
                MsvmObject VHDRASDDefault = this.newVMRasd("Microsoft Virtual Hard Disk");
                VHDRASDDefault.getObjectDispatcher().put("Parent", new JIVariant(newDiskDrivePath));
                VHDRASDDefault.getObjectDispatcher().put("Connection", new JIVariant(new JIArray((Object)new JIString[]{new JIString(VHDPath)}, true)));
                varint = VHDRASDDefault.getObjectDispatcher().callMethodA("GetText_", new Object[]{new JIVariant(1), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
                String VHDRASDDefaultText = varint[0].getObjectAsString().getString();
                inParams = addVirtualSystemResources.getInParameters();
                inParams.getObjectDispatcher().put("TargetSystem", new JIVariant(compSys.getObjectPath().getPath()));
                inParams.getObjectDispatcher().put("ResourceSettingData", new JIVariant(new JIArray((Object)new JIString[]{new JIString(VHDRASDDefaultText)}, true)));
                methodParams = new Object[]{new JIString("AddVirtualSystemResources"), new JIVariant((IJIComObject)inParams.getObjectDispatcher()), new Integer(0), JIVariant.NULL()};
                result = virtualSystem.getObjectDispatcher().callMethodA("ExecMethod_", methodParams)[0];
                IJIDispatch dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)result.getObjectAsComObject());
                returnValue = dispatch.get("ReturnValue");
                resultat = returnValue.getObjectAsInt();
                logger.debug((Object)("resultat = " + resultat));
                return resultat == 0;
            }
        }
        return true;
    }

    private synchronized boolean addNetworkAdapter(String vmName, MsvmVirtualSystemManagementService virtualSystem, MsvmComputerSystem compSys) throws JIException {
        logger.info((Object)"addNetworkAdapter");
        String wql = "SELECT * FROM Msvm_VirtualSwitchManagementService";
        SWbemObjectSet virtualSwitchMngtSet = this.services.execQuery(wql, MsvmObject.class);
        MsvmObject virtualSwitchMngt = (MsvmObject)virtualSwitchMngtSet.iterator().next();
        wql = "SELECT * FROM Msvm_VirtualSwitch";
        SWbemObjectSet virtualSwitchSet = this.services.execQuery(wql, MsvmObject.class);
        MsvmObject virtualSwitch = (MsvmObject)virtualSwitchSet.iterator().next();
        SWbemMethod createSwitchPort = null;
        for (SWbemMethod m : virtualSwitchMngt.getMethods()) {
            if (!m.getName().equals("CreateSwitchPort")) continue;
            createSwitchPort = m;
            break;
        }
        SWbemObject inParams = createSwitchPort.getInParameters();
        inParams.getObjectDispatcher().put("VirtualSwitch", new JIVariant(virtualSwitch.getObjectPath().getPath(), true));
        UUID uuid = UUID.randomUUID();
        String randomUUIDString = uuid.toString();
        inParams.getObjectDispatcher().put("FriendlyName", new JIVariant(randomUUIDString));
        inParams.getObjectDispatcher().put("Name", new JIVariant(randomUUIDString));
        Object[] methodParams = new Object[]{new JIString("CreateSwitchPort"), new JIVariant((IJIComObject)inParams.getObjectDispatcher()), new Integer(0), JIVariant.NULL()};
        JIVariant result = virtualSwitchMngt.getObjectDispatcher().callMethodA("ExecMethod_", methodParams)[0];
        IJIDispatch wbemObject_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)result.getObjectAsComObject());
        JIVariant returnValue = wbemObject_dispatch.get("ReturnValue");
        int resultat = returnValue.getObjectAsInt();
        logger.debug((Object)("resultat = " + resultat));
        if (resultat != 0) {
            return false;
        }
        String createdSwitch = wbemObject_dispatch.get("CreatedSwitchPort").getObjectAsString2();
        MsvmObject newRASDDefault = null;
        if (HyperVServerPool.LEGACY_NETWORK_ADAPTER) {
            newRASDDefault = this.newVMRasd("Microsoft Emulated Ethernet Port");
            newRASDDefault.getObjectDispatcher().put("ElementName", new JIVariant("Legacy Network Adapter"));
        } else {
            newRASDDefault = this.newVMRasd("Microsoft Synthetic Ethernet Port");
            UUID guid = UUID.randomUUID();
            String randomGUIDString = guid.toString();
            newRASDDefault.getObjectDispatcher().put("VirtualSystemIdentifiers", new JIVariant(new JIArray((Object)new JIVariant[]{new JIVariant("{" + randomGUIDString + "}")}, true)));
            newRASDDefault.getObjectDispatcher().put("ElementName", new JIVariant("VMBus Network Adapter"));
        }
        newRASDDefault.getObjectDispatcher().put("Connection", new JIVariant(new JIArray((Object)new JIVariant[]{new JIVariant(createdSwitch)}, true)));
        JIVariant[] varint = newRASDDefault.getObjectDispatcher().callMethodA("GetText_", new Object[]{new JIVariant(1), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
        String newRASDDefaultText = varint[0].getObjectAsString().getString();
        SWbemMethod addVirtualSystemResources = null;
        for (SWbemMethod m : virtualSystem.getMethods()) {
            if (!m.getName().equals("AddVirtualSystemResources")) continue;
            addVirtualSystemResources = m;
            break;
        }
        inParams = addVirtualSystemResources.getInParameters();
        inParams.getObjectDispatcher().put("TargetSystem", new JIVariant(compSys.getObjectPath().getPath()));
        inParams.getObjectDispatcher().put("ResourceSettingData", new JIVariant(new JIArray((Object)new JIString[]{new JIString(newRASDDefaultText)}, true)));
        methodParams = new Object[]{new JIString("AddVirtualSystemResources"), new JIVariant((IJIComObject)inParams.getObjectDispatcher()), new Integer(0), JIVariant.NULL()};
        result = virtualSystem.getObjectDispatcher().callMethodA("ExecMethod_", methodParams)[0];
        wbemObject_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)result.getObjectAsComObject());
        returnValue = wbemObject_dispatch.get("ReturnValue");
        resultat = returnValue.getObjectAsInt();
        logger.debug((Object)("resultat = " + resultat));
        return resultat == 0;
    }

    private synchronized MsvmObject newVMRasd(String resourceSubType) throws JIException {
        logger.debug((Object)"newVMRasd");
        String wql = "SELECT * FROM Msvm_AllocationCapabilities WHERE ResourceSubtype='" + resourceSubType + "'";
        SWbemObjectSet allocCapSet = this.services.execQuery(wql, MsvmObject.class);
        MsvmObject allocCap = (MsvmObject)allocCapSet.iterator().next();
        String allocCapPath = allocCap.getObjectPath().getPath().replace("\\", "\\\\");
        wql = "SELECT * FROM Msvm_SettingsDefineCapabilities WHERE valueRange=0 AND GroupComponent='" + allocCapPath + "'";
        SWbemObjectSet setDefCapSet = this.services.execQuery(wql, MsvmObject.class);
        MsvmObject setDefCap = (MsvmObject)setDefCapSet.iterator().next();
        String partComponent = setDefCap.getObjectDispatcher().get("PartComponent").getObjectAsString2();
        JIVariant[] var = this.services.getObjectDispatcher().callMethodA("Get", new Object[]{new JIVariant(partComponent), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
        IJIDispatch dispach = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)var[0].getObjectAsComObject());
        return new MsvmObject(dispach, this.services);
    }

    public synchronized int getEnabledState(HyperVHost host, String ElementName) throws Exception {
        logger.info((Object)"getEnabledState");
        String wql = "SELECT * FROM Msvm_ComputerSystem WHERE ElementName = '" + ElementName + "'";
        this.testConnectionHyperv();
        SWbemObjectSet compSysSet = this.services.execQuery(wql, MsvmComputerSystem.class);
        if (compSysSet.getSize() != 1) {
            logger.debug((Object)("VM " + ElementName + " missing on " + host));
            throw new Exception("VM " + ElementName + " missing on " + host);
        }
        MsvmComputerSystem cs = (MsvmComputerSystem)compSysSet.iterator().next();
        int state = cs.getEnabledState();
        logger.debug((Object)("VM " + ElementName + " state result : " + state));
        return state;
    }

    public synchronized boolean setCPUCount(String ElementName, int numVCPU) throws Exception {
        logger.info((Object)"setCPUCount");
        this.testConnectionHyperv();
        String wql = "SELECT * FROM Msvm_ComputerSystem WHERE ElementName = '" + ElementName + "'";
        SWbemObjectSet compSysSet = this.services.execQuery(wql, MsvmComputerSystem.class);
        MsvmComputerSystem compSys = (MsvmComputerSystem)compSysSet.iterator().next();
        int state = compSys.getEnabledState();
        if (state != 3) {
            compSys.requestStateChange(3);
        }
        MsvmObject processorSettingData = this.associatorsOf(ElementName, "Msvm_ProcessorSettingData");
        processorSettingData.getObjectDispatcher().put("VirtualQuantity", new JIVariant(numVCPU));
        JIVariant[] varint = processorSettingData.getObjectDispatcher().callMethodA("GetText_", new Object[]{new JIVariant(1), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
        String processorSettingDataText = varint[0].getObjectAsString().getString();
        boolean result = this.modifySystemResources(compSys, new JIArray((Object)new JIString[]{new JIString(processorSettingDataText)}, true));
        compSys.requestStateChange(state);
        return result;
    }

    public synchronized boolean setMemorySize(String ElementName, long memorySizeMB) throws Exception {
        logger.info((Object)"setMemorySize");
        this.testConnectionHyperv();
        String wql = "SELECT * FROM Msvm_ComputerSystem WHERE ElementName = '" + ElementName + "'";
        SWbemObjectSet compSysSet = this.services.execQuery(wql, MsvmComputerSystem.class);
        MsvmComputerSystem compSys = (MsvmComputerSystem)compSysSet.iterator().next();
        int state = compSys.getEnabledState();
        if (state != 3) {
            compSys.requestStateChange(3);
        }
        MsvmObject memorySettingData = this.associatorsOf(ElementName, "Msvm_MemorySettingData");
        memorySettingData.getObjectDispatcher().put("VirtualQuantity", new JIVariant((float)memorySizeMB));
        JIVariant[] varint = memorySettingData.getObjectDispatcher().callMethodA("GetText_", new Object[]{new JIVariant(1), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
        String memorySettingDataText = varint[0].getObjectAsString().getString();
        boolean result = this.modifySystemResources(compSys, new JIArray((Object)new JIString[]{new JIString(memorySettingDataText)}, true));
        compSys.requestStateChange(state);
        return result;
    }

    public synchronized boolean setSchedulingCap(String ElementName, int schedulingCap) throws Exception {
        logger.info((Object)"setSchedulingCap");
        this.testConnectionHyperv();
        String wql = "SELECT * FROM Msvm_ComputerSystem WHERE ElementName = '" + ElementName + "'";
        SWbemObjectSet compSysSet = this.services.execQuery(wql, MsvmComputerSystem.class);
        MsvmComputerSystem compSys = (MsvmComputerSystem)compSysSet.iterator().next();
        int state = compSys.getEnabledState();
        if (state != 3) {
            compSys.requestStateChange(3);
        }
        MsvmObject processorSettingData = this.associatorsOf(ElementName, "Msvm_ProcessorSettingData");
        processorSettingData.getObjectDispatcher().put("Limit", new JIVariant(schedulingCap));
        JIVariant[] varint = processorSettingData.getObjectDispatcher().callMethodA("GetText_", new Object[]{new JIVariant(1), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
        String processorSettingDataText = varint[0].getObjectAsString().getString();
        boolean result = this.modifySystemResources(compSys, new JIArray((Object)new JIString[]{new JIString(processorSettingDataText)}, true));
        compSys.requestStateChange(state);
        return result;
    }

    public synchronized boolean setSchedulingWeight(String ElementName, int schedulingWeight) throws Exception {
        logger.info((Object)"setSchedulingWeight");
        this.testConnectionHyperv();
        String wql = "SELECT * FROM Msvm_ComputerSystem WHERE ElementName = '" + ElementName + "'";
        SWbemObjectSet compSysSet = this.services.execQuery(wql, MsvmComputerSystem.class);
        MsvmComputerSystem compSys = (MsvmComputerSystem)compSysSet.iterator().next();
        int state = compSys.getEnabledState();
        if (state != 3) {
            compSys.requestStateChange(3);
        }
        MsvmObject processorSettingData = this.associatorsOf(ElementName, "Msvm_ProcessorSettingData");
        processorSettingData.getObjectDispatcher().put("Weight", new JIVariant(schedulingWeight));
        JIVariant[] varint = processorSettingData.getObjectDispatcher().callMethodA("GetText_", new Object[]{new JIVariant(1), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
        String processorSettingDataText = varint[0].getObjectAsString().getString();
        boolean result = this.modifySystemResources(compSys, new JIArray((Object)new JIString[]{new JIString(processorSettingDataText)}, true));
        compSys.requestStateChange(state);
        return result;
    }

    private synchronized MsvmObject associatorsOf(String ElementName, String classeName) throws JIException {
        String wql = "SELECT * FROM Msvm_VirtualSystemSettingData WHERE ElementName = '" + ElementName + "'";
        SWbemObjectSet imgMngmtServSet = this.services.execQuery(wql, MsvmComputerSystem.class);
        MsvmComputerSystem virtualSetting = (MsvmComputerSystem)imgMngmtServSet.iterator().next();
        JIVariant[] varnt = this.services.getObjectDispatcher().callMethodA("AssociatorsOf", new Object[]{new JIVariant(virtualSetting.getObjectPath().getPath()), JIVariant.OPTIONAL_PARAM(), new JIVariant(classeName)});
        IJIDispatch wbemObjectSet_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)varnt[0].getObjectAsComObject());
        JIVariant variant = wbemObjectSet_dispatch.get("_NewEnum");
        IJIComObject object2 = JIObjectFactory.narrowObject((IJIComObject)variant.getObjectAsComObject());
        IJIEnumVariant enumVARIANT = (IJIEnumVariant)JIObjectFactory.narrowObject((IJIComObject)object2.queryInterface("00020404-0000-0000-C000-000000000046"));
        Object[] arrayObj = (Object[])((JIArray)enumVARIANT.next(1)[0]).getArrayInstance();
        IJIDispatch wbemObject_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)((JIVariant)arrayObj[0]).getObjectAsComObject());
        return new MsvmObject(wbemObject_dispatch, this.services);
    }

    private synchronized boolean modifySystemResources(MsvmComputerSystem compSys, JIArray resourceSettingDataArray) throws JIException {
        String wql = "SELECT * FROM Msvm_VirtualSystemManagementService";
        SWbemObjectSet virtualSystemSet = this.services.execQuery(wql, MsvmVirtualSystemManagementService.class);
        MsvmVirtualSystemManagementService virtualSystem = (MsvmVirtualSystemManagementService)virtualSystemSet.iterator().next();
        SWbemMethod modifyVirtualSystemResources = null;
        for (SWbemMethod m : virtualSystem.getMethods()) {
            if (!m.getName().equals("ModifyVirtualSystemResources")) continue;
            modifyVirtualSystemResources = m;
        }
        SWbemObject inParams = modifyVirtualSystemResources.getInParameters();
        inParams.getObjectDispatcher().put("ComputerSystem", new JIVariant(compSys.getObjectPath().getPath()));
        inParams.getObjectDispatcher().put("ResourceSettingData", new JIVariant(resourceSettingDataArray));
        Object[] methodParams = new Object[]{new JIString("ModifyVirtualSystemResources"), new JIVariant((IJIComObject)inParams.getObjectDispatcher()), new Integer(0), JIVariant.NULL()};
        JIVariant result = virtualSystem.getObjectDispatcher().callMethodA("ExecMethod_", methodParams)[0];
        IJIDispatch dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)result.getObjectAsComObject());
        JIVariant returnValue = dispatch.get("ReturnValue");
        int resultat = returnValue.getObjectAsInt();
        logger.debug((Object)("resultat = " + resultat));
        return resultat == 0;
    }

    public synchronized int getSchedulingWeight(String nameLabel) throws JIException {
        logger.info((Object)"getSchedulingWeight");
        this.testConnectionHyperv();
        MsvmObject processorSettingData = this.associatorsOf(nameLabel, "Msvm_ProcessorSettingData");
        int schedulingWeight = processorSettingData.getObjectDispatcher().get("Weight").getObjectAsInt();
        return schedulingWeight;
    }

    public synchronized int getSchedulingCap(String nameLabel) throws JIException {
        logger.info((Object)"getSchedulingCap");
        this.testConnectionHyperv();
        MsvmObject processorSettingData = this.associatorsOf(nameLabel, "Msvm_ProcessorSettingData");
        int schedulingCap = Integer.parseInt(processorSettingData.getObjectDispatcher().get("Limit").getObjectAsString2());
        return schedulingCap;
    }

    public synchronized String getMacAddress(String nameLabel) throws JIException {
        logger.info((Object)"getMacAddress");
        this.testConnectionHyperv();
        MsvmObject settingData = null;
        settingData = HyperVServerPool.LEGACY_NETWORK_ADAPTER ? this.associatorsOf(nameLabel, "Msvm_EmulatedEthernetPortSettingData") : this.associatorsOf(nameLabel, "Msvm_SyntheticEthernetPortSettingData");
        String macAddress = settingData.getObjectDispatcher().get("Address").getObjectAsString2();
        return macAddress;
    }

    public synchronized String getStartTime(HyperVHost host, String ElementName) throws Exception {
        logger.info((Object)"getStartTime");
        String wql = "SELECT * FROM Msvm_ComputerSystem WHERE ElementName = '" + ElementName + "'";
        this.testConnectionHyperv();
        SWbemObjectSet compSysSet = this.services.execQuery(wql, MsvmComputerSystem.class);
        if (compSysSet.getSize() != 1) {
            logger.debug((Object)("VM " + ElementName + " missing on " + host));
            throw new InstanceNotFoundException("VM " + ElementName + " missing on " + host);
        }
        MsvmComputerSystem cs = (MsvmComputerSystem)compSysSet.iterator().next();
        String startTime = ((SWbemProperty)cs.getProperties().getItem("InstallDate")).toString();
        logger.debug((Object)("VM " + ElementName + " StartTime : " + startTime));
        return startTime;
    }

    public synchronized int getNumberOfProcessors(String nameLabel) throws JIException {
        logger.debug((Object)"getNumVCPUs");
        this.testConnectionHyperv();
        JIVariant summary_variant = this.getSummaryInfo(nameLabel)[0];
        IJIDispatch dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)summary_variant.getObjectAsComObject());
        int numberOfProcessors = dispatch.get("NumberOfProcessors").getObjectAsInt();
        return numberOfProcessors;
    }

    public synchronized float getCPULoad(String nameLabel) throws JIException {
        logger.debug((Object)"getCPULoad");
        this.testConnectionHyperv();
        IJIDispatch dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)this.getSummaryInfo(nameLabel)[0].getObjectAsComObject());
        float processorLoad = dispatch.get("ProcessorLoad").getObjectAsInt();
        return processorLoad;
    }

    public synchronized long getMemorySize(String nameLabel) throws Exception {
        logger.debug((Object)"getMemorySize");
        this.testConnectionHyperv();
        MsvmObject memorySettingData = this.associatorsOf(nameLabel, "Msvm_MemorySettingData");
        JIVariant memoryVariant = memorySettingData.getObjectDispatcher().get("VirtualQuantity");
        long memorySize = 0L;
        if (memoryVariant.getType() != 1) {
            memorySize = Long.parseLong(memoryVariant.getObjectAsString2());
        }
        return memorySize;
    }

    public synchronized long getMemoryUsage(String nameLabel) throws JIException {
        logger.debug((Object)"getMemoryUsage");
        this.testConnectionHyperv();
        JIVariant summary_variant = this.getSummaryInfo(nameLabel)[0];
        IJIDispatch dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)summary_variant.getObjectAsComObject());
        JIVariant memoryUsageVariant = dispatch.get("MemoryUsage");
        long memoryUsage = 0L;
        if (memoryUsageVariant.getType() != 1) {
            memoryUsage = Long.parseLong(memoryUsageVariant.getObjectAsString().getString());
        }
        return memoryUsage;
    }

    public synchronized HashMap<String, Float> getVMCPULoads() throws JIException {
        JIVariant[] summary_variantArray;
        logger.debug((Object)"getVMCPULoads");
        HashMap<String, Float> cpuLoads = new HashMap<String, Float>();
        this.testConnectionHyperv();
        for (JIVariant element : summary_variantArray = this.getSummaryInfo(null)) {
            IJIDispatch dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)element.getObjectAsComObject());
            float processorLoad = dispatch.get("ProcessorLoad").getObjectAsInt();
            String elementName = dispatch.get("ElementName").getObjectAsString2();
            cpuLoads.put(elementName, Float.valueOf(processorLoad));
        }
        return cpuLoads;
    }

    private synchronized JIVariant[] getSummaryInfo(String nameLabel) throws JIException {
        logger.debug((Object)"getSummaryInfo");
        String wql = "SELECT * FROM Msvm_VirtualSystemManagementService";
        SWbemObjectSet virtualSystemSet = this.services.execQuery(wql, MsvmVirtualSystemManagementService.class);
        MsvmVirtualSystemManagementService virtualSystem = (MsvmVirtualSystemManagementService)virtualSystemSet.iterator().next();
        wql = nameLabel == null ? "SELECT * FROM Msvm_VirtualSystemSettingData" : "SELECT * FROM Msvm_VirtualSystemSettingData WHERE ElementName = '" + nameLabel + "'";
        SWbemObjectSet settingDataSet = this.services.execQuery(wql, MsvmVirtualSystemSettingData.class);
        JIVariant[] VirtualSystemVariantArray = new JIVariant[settingDataSet.getSize()];
        int i = 0;
        for (MsvmVirtualSystemSettingData vssd : settingDataSet) {
            VirtualSystemVariantArray[i] = new JIVariant(vssd.getObjectPath().getPath());
            ++i;
        }
        SWbemMethod getSummaryInformation = null;
        for (SWbemMethod m : virtualSystem.getMethods()) {
            if (!m.getName().equals("GetSummaryInformation")) continue;
            getSummaryInformation = m;
        }
        SWbemObject inParams = getSummaryInformation.getInParameters();
        inParams.getObjectDispatcher().put("SettingData", new JIVariant(new JIArray((Object)VirtualSystemVariantArray, true)));
        inParams.getObjectDispatcher().put("RequestedInformation", new JIVariant(new JIArray((Object)new Integer[]{0, 1, 2, 3, 4, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111}, true)));
        Object[] methodParams = new Object[]{new JIString("GetSummaryInformation"), new JIVariant((IJIComObject)inParams.getObjectDispatcher()), new Integer(0), JIVariant.NULL()};
        JIVariant result = virtualSystem.getObjectDispatcher().callMethodA("ExecMethod_", methodParams)[0];
        IJIDispatch dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)result.getObjectAsComObject());
        JIVariant summaryInformationValue = dispatch.get("SummaryInformation");
        return (JIVariant[])summaryInformationValue.getObjectAsArray().getArrayInstance();
    }

    public synchronized Set<Template> getHostVMTemplates(String imageStorePath) throws JIException {
        logger.info((Object)"getHostVMTemplates");
        HashSet<Template> setTemplate = new HashSet<Template>();
        String wql = "SELECT * FROM CIM_DataFile WHERE Path = '" + imageStorePath + "' AND FileType = 'vhd File'";
        this.testConnectionWin32();
        JIVariant[] results = this.services_dispatch.callMethodA("ExecQuery", new Object[]{new JIString(wql), new JIString("WQL"), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
        IJIDispatch wbemObjectSet_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)results[0].getObjectAsComObject());
        JIVariant variant = wbemObjectSet_dispatch.get("_NewEnum");
        IJIComObject object = variant.getObjectAsComObject();
        IJIEnumVariant enumVARIANT = (IJIEnumVariant)JIObjectFactory.narrowObject((IJIComObject)object.queryInterface("00020404-0000-0000-C000-000000000046"));
        JIVariant Count = wbemObjectSet_dispatch.get("Count");
        int count = Count.getObjectAsInt();
        for (int i = 0; i < count; ++i) {
            Object[] arrayObj;
            Template temp = new Template();
            Object[] values = enumVARIANT.next(1);
            JIArray array = (JIArray)values[0];
            for (Object element : arrayObj = (Object[])array.getArrayInstance()) {
                IJIDispatch wbemObject_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)((JIVariant)element).getObjectAsComObject());
                JIVariant elementName = wbemObject_dispatch.get("FileName");
                temp.setName(elementName.getObjectAsString().getString());
                JIVariant variant2 = wbemObject_dispatch.callMethodA("GetObjectText_", new Object[]{new Integer(1)})[0];
                temp.setMetaData(variant2.getObjectAsString().getString());
            }
            setTemplate.add(temp);
        }
        return setTemplate;
    }

    public synchronized boolean hostDeleteFile(String folderPath, String name) throws JIException {
        logger.info((Object)("hostDeleteFile " + folderPath + name));
        String wql = "SELECT * FROM CIM_DataFile WHERE Name = '" + folderPath + name + "'";
        this.testConnectionWin32();
        JIVariant[] results2 = this.services_dispatch.callMethodA("ExecQuery", new Object[]{new JIString(wql), new JIString("WQL"), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
        IJIDispatch wbemObjectSet_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)results2[0].getObjectAsComObject());
        JIVariant variant = wbemObjectSet_dispatch.get("_NewEnum");
        IJIComObject object = JIObjectFactory.narrowObject((IJIComObject)variant.getObjectAsComObject());
        IJIEnumVariant enumVARIANT = (IJIEnumVariant)JIObjectFactory.narrowObject((IJIComObject)object.queryInterface("00020404-0000-0000-C000-000000000046"));
        Object[] arrayObj = (Object[])((JIArray)enumVARIANT.next(1)[0]).getArrayInstance();
        IJIDispatch wbemObject_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)((JIVariant)arrayObj[0]).getObjectAsComObject());
        Object[] methodParams = new Object[]{new JIString("Delete"), JIVariant.NULL(), new Integer(0), JIVariant.NULL()};
        JIVariant result = wbemObject_dispatch.callMethodA("ExecMethod_", methodParams)[0];
        IJIDispatch dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)result.getObjectAsComObject());
        JIVariant returnValue = dispatch.get("ReturnValue");
        int resultat = returnValue.getObjectAsInt();
        logger.debug((Object)("resultat = " + resultat));
        return resultat == 0 || resultat == 4096;
    }

    public synchronized boolean hostCopyFile(String originPath, String destinationPath) throws JIException {
        logger.debug((Object)("hostCopyFile from " + originPath + " to " + destinationPath));
        String wql = "SELECT * FROM CIM_DataFile WHERE Name = '" + originPath + "'";
        this.testConnectionWin32();
        JIVariant[] results2 = this.services_dispatch.callMethodA("ExecQuery", new Object[]{new JIString(wql), new JIString("WQL"), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
        IJIDispatch wbemObjectSet_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)results2[0].getObjectAsComObject());
        JIVariant variant = wbemObjectSet_dispatch.get("_NewEnum");
        IJIComObject object2 = JIObjectFactory.narrowObject((IJIComObject)variant.getObjectAsComObject());
        IJIEnumVariant enumVARIANT = (IJIEnumVariant)JIObjectFactory.narrowObject((IJIComObject)object2.queryInterface("00020404-0000-0000-C000-000000000046"));
        Object[] arrayObj = (Object[])((JIArray)enumVARIANT.next(1)[0]).getArrayInstance();
        IJIDispatch wbemObject_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)((JIVariant)arrayObj[0]).getObjectAsComObject());
        JIVariant variant2 = wbemObject_dispatch.get("Methods_");
        IJIDispatch dispatch2 = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)variant2.getObjectAsComObject());
        JIVariant jiCount = dispatch2.get("Count");
        int count = jiCount.getObjectAsInt();
        JIVariant variant3 = dispatch2.get("_NewEnum");
        IJIEnumVariant enumVARIANT2 = (IJIEnumVariant)JIObjectFactory.narrowObject((IJIComObject)variant3.getObjectAsComObject().queryInterface("00020404-0000-0000-C000-000000000046"));
        for (int i = 0; i < count; ++i) {
            Object[] values = enumVARIANT2.next(1);
            JIArray array = (JIArray)values[0];
            Object[] arrayObj2 = (Object[])array.getArrayInstance();
            IJIDispatch dispatch3 = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)((JIVariant)arrayObj2[0]).getObjectAsComObject());
            if (!dispatch3.get("Name").getObjectAsString2().equals("Copy")) continue;
            JIVariant variant4 = dispatch3.get("InParameters");
            IJIDispatch inParamsDispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)variant4.getObjectAsComObject());
            inParamsDispatch.put("FileName", new JIVariant(destinationPath));
            Object[] methodParams = new Object[]{new JIString("Copy"), new JIVariant((IJIComObject)inParamsDispatch), new Integer(0), JIVariant.NULL()};
            JIVariant result = wbemObject_dispatch.callMethodA("ExecMethod_", methodParams)[0];
            IJIDispatch dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)result.getObjectAsComObject());
            JIVariant returnValue = dispatch.get("ReturnValue");
            int resultat = returnValue.getObjectAsInt();
            logger.debug((Object)("resultat = " + resultat));
            return resultat == 0;
        }
        return false;
    }

    public synchronized long getHostSizeMB(String path) throws JIException {
        logger.debug((Object)"getHostSizeMB");
        String wql = "SELECT * FROM Win32_LogicalDisk WHERE Name = '" + path + "'";
        this.testConnectionWin32();
        JIVariant[] results2 = this.services_dispatch.callMethodA("ExecQuery", new Object[]{new JIString(wql), new JIString("WQL"), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
        IJIDispatch wbemObjectSet_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)results2[0].getObjectAsComObject());
        JIVariant variant = wbemObjectSet_dispatch.get("_NewEnum");
        IJIComObject object2 = JIObjectFactory.narrowObject((IJIComObject)variant.getObjectAsComObject());
        IJIEnumVariant enumVARIANT = (IJIEnumVariant)JIObjectFactory.narrowObject((IJIComObject)object2.queryInterface("00020404-0000-0000-C000-000000000046"));
        Object[] arrayObj = (Object[])((JIArray)enumVARIANT.next(1)[0]).getArrayInstance();
        IJIDispatch dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)((JIVariant)arrayObj[0]).getObjectAsComObject());
        JIVariant returnValue = dispatch.get("Size");
        long resultat = Long.parseLong(returnValue.getObjectAsString().getString()) / 0x100000L;
        return resultat;
    }

    public synchronized long getHostFreeSpaceMB(String path) throws JIException {
        logger.debug((Object)"getHostFreeSpaceMB");
        String wql = "SELECT * FROM Win32_LogicalDisk WHERE Name = '" + path + "'";
        this.testConnectionWin32();
        JIVariant[] results2 = this.services_dispatch.callMethodA("ExecQuery", new Object[]{new JIString(wql), new JIString("WQL"), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
        IJIDispatch wbemObjectSet_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)results2[0].getObjectAsComObject());
        JIVariant variant = wbemObjectSet_dispatch.get("_NewEnum");
        IJIComObject object2 = JIObjectFactory.narrowObject((IJIComObject)variant.getObjectAsComObject());
        IJIEnumVariant enumVARIANT = (IJIEnumVariant)JIObjectFactory.narrowObject((IJIComObject)object2.queryInterface("00020404-0000-0000-C000-000000000046"));
        Object[] arrayObj = (Object[])((JIArray)enumVARIANT.next(1)[0]).getArrayInstance();
        IJIDispatch dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)((JIVariant)arrayObj[0]).getObjectAsComObject());
        JIVariant returnValue = dispatch.get("FreeSpace");
        long resultat = Long.parseLong(returnValue.getObjectAsString().getString()) / 0x100000L;
        return resultat;
    }

    public synchronized int getHostNumCPU() throws JIException {
        logger.debug((Object)"getHostNumCPU");
        String wql = "SELECT * FROM Win32_Processor";
        this.testConnectionWin32();
        JIVariant[] results = this.services_dispatch.callMethodA("ExecQuery", new Object[]{new JIString(wql), new JIString("WQL"), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
        IJIDispatch wbemObjectSet_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)results[0].getObjectAsComObject());
        int numCPU = wbemObjectSet_dispatch.get("Count").getObjectAsInt();
        return numCPU;
    }

    public synchronized HashMap<String, String> getHostCPUInfo() throws JIException {
        logger.debug((Object)"getHostCPUInfo");
        String wql = "SELECT * FROM Win32_Processor";
        this.testConnectionWin32();
        JIVariant[] results = this.services_dispatch.callMethodA("ExecQuery", new Object[]{new JIString(wql), new JIString("WQL"), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
        IJIDispatch wbemObjectSet_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)results[0].getObjectAsComObject());
        JIVariant variant = wbemObjectSet_dispatch.get("_NewEnum");
        IJIComObject object2 = JIObjectFactory.narrowObject((IJIComObject)variant.getObjectAsComObject());
        IJIEnumVariant enumVARIANT = (IJIEnumVariant)JIObjectFactory.narrowObject((IJIComObject)object2.queryInterface("00020404-0000-0000-C000-000000000046"));
        Object[] arrayObj = (Object[])((JIArray)enumVARIANT.next(1)[0]).getArrayInstance();
        IJIDispatch wbemObject_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)((JIVariant)arrayObj[0]).getObjectAsComObject());
        HashMap<String, String> cpuInfo = new HashMap<String, String>();
        cpuInfo.put("model", wbemObject_dispatch.get("Name").getObjectAsString2());
        cpuInfo.put("vendor", wbemObject_dispatch.get("Manufacturer").getObjectAsString2());
        cpuInfo.put("speed", Integer.toString(wbemObject_dispatch.get("CurrentClockSpeed").getObjectAsInt()));
        return cpuInfo;
    }

    public synchronized float[] getHostCPULoad() throws JIException {
        logger.debug((Object)"getHostCPULoad");
        String wql = "SELECT * FROM Win32_Processor";
        float[] loadPerCPU = new float[]{};
        int numCPU = 0;
        this.testConnectionWin32();
        JIVariant[] results = this.services_dispatch.callMethodA("ExecQuery", new Object[]{new JIString(wql), new JIString("WQL"), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
        IJIDispatch wbemObjectSet_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)results[0].getObjectAsComObject());
        JIVariant variant = wbemObjectSet_dispatch.get("_NewEnum");
        IJIComObject object2 = JIObjectFactory.narrowObject((IJIComObject)variant.getObjectAsComObject());
        IJIEnumVariant enumVARIANT = (IJIEnumVariant)JIObjectFactory.narrowObject((IJIComObject)object2.queryInterface("00020404-0000-0000-C000-000000000046"));
        JIVariant Count = wbemObjectSet_dispatch.get("Count");
        int count = Count.getObjectAsInt();
        for (int i = 0; i < count; ++i) {
            Object[] arrayObj;
            Object[] values = enumVARIANT.next(1);
            JIArray array = (JIArray)values[0];
            for (Object element : arrayObj = (Object[])array.getArrayInstance()) {
                IJIDispatch processor_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)((JIVariant)element).getObjectAsComObject());
                float[] temp = new float[numCPU + 1];
                int j = 0;
                float[] arr$ = loadPerCPU;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    float load;
                    temp[j] = load = arr$[i$];
                }
                temp[numCPU] = processor_dispatch.get("LoadPercentage").getObjectAsInt();
                loadPerCPU = temp;
                ++numCPU;
            }
        }
        return loadPerCPU;
    }

    static interface VmState {
        public static final int Enabled = 2;
        public static final int Disabled = 3;
        public static final int Reboot = 10;
        public static final int Paused = 32768;
        public static final int Suspended = 32769;
    }

    public class Template {
        private String name;
        private String metadata;

        public Template() {
            this.name = null;
            this.metadata = null;
        }

        public Template(String name, String metadata) {
            this.name = name;
            this.metadata = metadata;
        }

        public String getName() {
            return this.name;
        }

        public String getMetaData() {
            return this.metadata;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setMetaData(String metadata) {
            this.metadata = metadata;
        }
    }

    public class VM {
        private String nameLabel;
        private String uuid;

        public VM() {
            this.nameLabel = null;
            this.uuid = null;
        }

        public VM(String nameLabel, String uuid) {
            this.nameLabel = nameLabel;
            this.uuid = uuid;
        }

        public String getNameLabel() {
            return this.nameLabel;
        }

        public String getUuid() {
            return this.uuid;
        }

        public void setNameLabel(String nameLabel) {
            this.nameLabel = nameLabel;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }
    }
}

