/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.hyperv;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.driver.hyperv.HyperVConnection;
import org.ow2.jasmine.vmm.agent.driver.hyperv.HyperVHost;
import org.ow2.jasmine.vmm.agent.driver.hyperv.HyperVServerPool;
import org.ow2.jasmine.vmm.agent.driver.hyperv.HyperVVirtualMachine;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;

class HyperVEventCollector {
    static Logger logger = Logger.getLogger(HyperVEventCollector.class);
    private HyperVServerPool pool;
    private List<HyperVHost> hosts;
    private boolean close = false;

    public HyperVEventCollector(HyperVServerPool pool) {
        this.pool = pool;
        this.hosts = new ArrayList<HyperVHost>();
    }

    public void add(final HyperVHost host, final HyperVConnection hypervConnection) {
        this.close = false;
        if (!this.hosts.contains(host)) {
            this.hosts.add(host);
            try {
                this.pool.getExecutorService().execute(new Runnable(){

                    @Override
                    public void run() {
                        logger.debug((Object)("Start pulling events on host : " + host.getHostName()));
                        do {
                            try {
                                host.sync(hypervConnection);
                                if (!HyperVEventCollector.this.close) {
                                    for (VirtualMachineMXBean vm : host.getResidentVMs()) {
                                        if (HyperVEventCollector.this.close) break;
                                        ((HyperVVirtualMachine)vm).onVMStateChanged(((HyperVVirtualMachine)vm).getState(hypervConnection));
                                    }
                                    Thread.sleep(HyperVServerPool.EVENT_COLLECTOR_PERIOD * 1000);
                                    continue;
                                }
                                break;
                            }
                            catch (Exception ex) {
                                logger.error((Object)"In Hyperv event collector: ", (Throwable)ex);
                            }
                        } while (!HyperVEventCollector.this.close);
                    }
                });
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to initialize event collector", (Throwable)ex);
            }
        }
    }

    public void stop() {
        this.close = true;
        this.hosts.clear();
        logger.debug((Object)"Stopped periodic event collecting task");
    }
}

