/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.hyperv;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.ObjectName;
import org.ow2.jasmine.vmm.agent.domain.ServerPool;
import org.ow2.jasmine.vmm.agent.driver.hyperv.HyperVConnection;
import org.ow2.jasmine.vmm.agent.driver.hyperv.HyperVEventCollector;
import org.ow2.jasmine.vmm.agent.driver.hyperv.HyperVHost;
import org.ow2.jasmine.vmm.agent.driver.hyperv.HyperVVMImageStore;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;

public class HyperVServerPool
extends ServerPool {
    public static int EVENT_COLLECTOR_PERIOD;
    public static boolean LEGACY_NETWORK_ADAPTER;
    public static final String LEGACY_NETWORK_NAME = "Legacy Network Adapter";
    public static final String SYNTHETIC_NETWORK_NAME = "VMBus Network Adapter";
    private static final int THREADPOOL_SIZE = 20;
    private static ExecutorService executorService;
    private HyperVEventCollector eventCollector;
    private String hypervUser;
    private String hypervPassword;
    private VirtualMachineImageStoreMXBean imageStore;
    private String vmFolder;
    private String vmTemplateFolder;
    private String disk;

    public HyperVServerPool(String name, ObjectName objectName, Properties props) {
        super(name, objectName);
        this.hypervUser = props.getProperty("hypervUser");
        this.hypervPassword = props.getProperty("hypervPassword");
        this.vmFolder = props.getProperty("vmFolderPath").concat("\\").replaceAll("\\\\", "\\\\\\\\");
        this.vmTemplateFolder = props.getProperty("vmTemplateFolderPath").concat("\\").replaceAll("\\\\", "\\\\\\\\");
        LEGACY_NETWORK_ADAPTER = Boolean.valueOf(props.getProperty("Legacy_Network_Adapter", "true"));
        EVENT_COLLECTOR_PERIOD = Integer.parseInt(props.getProperty("Event_Collector_Period", "10"));
        this.disk = this.vmFolder.substring(0, 2);
        this.eventCollector = new HyperVEventCollector(this);
    }

    public ExecutorService getExecutorService() {
        return executorService;
    }

    @Override
    public HostMXBean newHost(String hostName, Map<String, String> props) {
        try {
            HostMXBean host2;
            for (HostMXBean host2 : this.hosts) {
                if (!host2.getHostName().equals(hostName)) continue;
                return host2;
            }
            ObjectName mbeanObjectName = MBeanObjectNamer.makeHostName(this.getPath() + "/" + hostName, hostName);
            host2 = HyperVHost.newHost(this, mbeanObjectName, hostName, this.vmFolder, this.vmTemplateFolder, new HyperVHost.HypervParams(this.hypervUser, this.hypervPassword), this.disk);
            if (host2 != null) {
                AgentCommon.getMBeanServer().registerMBean(host2, mbeanObjectName);
                this.hosts.add(host2);
                ServerPool.logger.info((Object)("In server pool " + this.name + ": added Host MBean " + mbeanObjectName));
                if (this.imageStore == null) {
                    String vmImageStoreName = hostName + "-VMIStore";
                    this.imageStore = new HyperVVMImageStore(MBeanObjectNamer.makeVMImageStoreName(vmImageStoreName), this.vmTemplateFolder, this.disk, host2.getHypervConnection());
                    AgentCommon.getMBeanServer().registerMBean(this.imageStore, this.imageStore.getObjectName());
                }
            }
            this.eventCollector.add((HyperVHost)host2, new HyperVConnection(hostName, this.hypervUser, this.hypervPassword));
            return host2;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ServerPool.logger.error((Object)"Failed to add HyperVHost", (Throwable)ex);
            return null;
        }
    }

    @Override
    public VirtualMachineImageStoreMXBean getVMImageStore() {
        return this.imageStore;
    }

    public synchronized void stopEventCollector() {
        this.eventCollector.stop();
    }

    static {
        executorService = Executors.newFixedThreadPool(20);
    }
}

