/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.hyperv;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.driver.hyperv.HyperVConnection;
import org.ow2.jasmine.vmm.agent.driver.hyperv.HyperVHost;
import org.ow2.jasmine.vmm.agent.driver.hyperv.HyperVVMImageStore;
import org.ow2.jasmine.vmm.api.BadVMPowerStateException;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.IllegalOperationException;
import org.ow2.jasmine.vmm.api.InsufficientResourcesException;
import org.ow2.jasmine.vmm.api.ResourceUsage;
import org.ow2.jasmine.vmm.api.VMCustomizationSpec;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;

public class HyperVVirtualMachine
extends ManagedResource
implements VirtualMachineMXBean {
    static Logger logger = Logger.getLogger(HyperVVirtualMachine.class);
    private HyperVHost host;
    private HyperVConnection connection;
    private HyperVConnection.VM vm;
    private String uuid;
    private String name;
    private String ipAddress;
    private Date startTime;
    private VirtualMachineMXBean.PowerState lastState = VirtualMachineMXBean.PowerState.UNKNOWN;

    public HyperVVirtualMachine(ObjectName objectName, HyperVHost host, HyperVConnection connection, HyperVConnection.VM vm, Map<String, String> userData) {
        super(objectName);
        try {
            this.host = host;
            this.connection = connection;
            this.vm = vm;
            this.uuid = this.vm.getUuid();
            this.name = this.vm.getNameLabel();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)"Failed to init VM", (Throwable)ex);
        }
    }

    public VirtualMachineMXBean cloneVM(String name, VMCustomizationSpec custSpec, boolean sync) throws InstanceNotFoundException, InsufficientResourcesException {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean canLiveMigrateToHost(HostMXBean targetHost) {
        throw new UnsupportedOperationException("not implemented");
    }

    public String getUuid() {
        return this.uuid;
    }

    public HostMXBean getHostMBean() {
        return this.host;
    }

    public Date getStartTime() {
        if (this.startTime == null) {
            try {
                String stringStartTime = this.connection.getStartTime(this.host, this.getNameLabel());
                HyperVVMImageStore.logger.debug((Object)("GetStartTime of " + this.getNameLabel()));
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss.'000000-000'");
                this.startTime = sdf.parse(stringStartTime);
            }
            catch (Exception ex) {
                logger.error((Object)("Failed to getStartTime of VM " + this.name), (Throwable)ex);
            }
        }
        logger.debug((Object)("VM " + this.name + " Start Time =" + this.startTime));
        return this.startTime;
    }

    public float getCPULoad() {
        float cpuLoad = 0.0f;
        try {
            cpuLoad = this.connection.getCPULoad(this.getNameLabel());
            logger.debug((Object)("VM " + this.name + " CPULoad = " + cpuLoad));
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to get CPULoad of VM " + this.name), (Throwable)ex);
        }
        return cpuLoad;
    }

    public float[] getLoadPerVCPU() {
        throw new UnsupportedOperationException("not implemented");
    }

    public long getMemorySizeMB() {
        long memorySize = 0L;
        try {
            memorySize = this.connection.getMemorySize(this.getNameLabel());
            logger.debug((Object)("VM " + this.name + " MemorySizeMB = " + memorySize));
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to get MemorySizeMB of VM " + this.name), (Throwable)ex);
        }
        return memorySize;
    }

    public ResourceUsage getResourceUsage() {
        ResourceUsage ru = new ResourceUsage();
        ru.setSamplingTime(new Date(System.currentTimeMillis()));
        ru.setCpuLoad(this.getCPULoad());
        ru.setMemoryUsedKBytes(this.getMemoryUsedMB() * 1024L);
        return ru;
    }

    public void setMemorySizeMB(long size) {
        try {
            boolean success = this.connection.setMemorySize(this.getNameLabel(), size);
            if (!success) {
                logger.error((Object)"Command setMemorySizeMB failed");
                return;
            }
            logger.debug((Object)"Command setMemorySizeMB succeed");
        }
        catch (Exception ex) {
            logger.error((Object)"setMemorySizeMB failure", (Throwable)ex);
        }
    }

    public long getMemoryUsedMB() {
        long memoryUsed = 0L;
        try {
            memoryUsed = this.connection.getMemoryUsage(this.getNameLabel());
            logger.debug((Object)("VM " + this.name + " MemoryUsedMB = " + memoryUsed));
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to get MemoryUsedMB of VM " + this.name), (Throwable)ex);
        }
        return memoryUsed;
    }

    public String getNameLabel() {
        return this.name;
    }

    public String getUserData(String key) {
        throw new UnsupportedOperationException("not implemented");
    }

    public int getNumVCPUs() {
        int numVCpus = 0;
        try {
            numVCpus = this.connection.getNumberOfProcessors(this.getNameLabel());
            logger.debug((Object)("VM " + this.name + " Num VCPUs = " + numVCpus));
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to get NumVCPUs of VM " + this.name), (Throwable)ex);
        }
        return numVCpus;
    }

    public int getSchedulingCap() {
        int schedulingCap = 0;
        try {
            schedulingCap = this.connection.getSchedulingCap(this.getNameLabel());
            logger.debug((Object)("VM " + this.name + " SchedulingCap = " + schedulingCap));
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to get SchedulingCap of VM " + this.name), (Throwable)ex);
        }
        return schedulingCap;
    }

    public int getSchedulingWeight() {
        int schedulingWeight = 0;
        try {
            schedulingWeight = this.connection.getSchedulingWeight(this.getNameLabel());
            logger.debug((Object)("VM " + this.name + " SchedulingWeight = " + schedulingWeight));
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to get SchedulingWeightp of VM " + this.name), (Throwable)ex);
        }
        return schedulingWeight;
    }

    public VirtualMachineMXBean.PowerState getState() {
        return this.getState(null);
    }

    public VirtualMachineMXBean.PowerState getState(HyperVConnection connection) {
        if (connection == null) {
            connection = this.connection;
        }
        try {
            int state = connection.getEnabledState(this.host, this.getNameLabel());
            if (state == 3) {
                return VirtualMachineMXBean.PowerState.HALTED;
            }
            if (state == 2) {
                return VirtualMachineMXBean.PowerState.RUNNING;
            }
            if (state == 32768) {
                return VirtualMachineMXBean.PowerState.PAUSED;
            }
            if (state == 32769) {
                return VirtualMachineMXBean.PowerState.SUSPENDED;
            }
        }
        catch (Exception ex) {
            logger.debug((Object)"Failed to get power state", (Throwable)ex);
        }
        return VirtualMachineMXBean.PowerState.UNKNOWN;
    }

    public String getGuestIpAddress() {
        throw new UnsupportedOperationException("not implemented");
    }

    public String getMacAddress() {
        String macAddress = null;
        try {
            macAddress = this.connection.getMacAddress(this.getNameLabel());
            macAddress = macAddress.substring(0, 2) + ':' + macAddress.substring(2, 4) + ':' + macAddress.substring(4, 6) + ':' + macAddress.substring(6, 8) + ':' + macAddress.substring(8, 10) + ':' + macAddress.substring(10);
            logger.debug((Object)("VM " + this.name + " Mac address = " + macAddress));
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to get MAC address of VM " + this.name), (Throwable)ex);
        }
        return macAddress;
    }

    public void setNumVCPUs(int numVCPUs) {
        try {
            boolean success = this.connection.setCPUCount(this.getNameLabel(), numVCPUs);
            if (!success) {
                logger.error((Object)"Command setNumVCPUs failed");
                return;
            }
            logger.debug((Object)"Command setNumVCPUs succeed");
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to setNumVCPUs of VM" + this.name), (Throwable)ex);
        }
    }

    public void setSchedulingCap(int schedulingCap) {
        try {
            boolean success = this.connection.setSchedulingCap(this.getNameLabel(), schedulingCap);
            if (!success) {
                logger.error((Object)"Command setSchedulingCap failed");
                return;
            }
            logger.debug((Object)"Command setSchedulingCap succeed");
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to set sched cap of VM " + this.name), (Throwable)ex);
        }
    }

    public void setSchedulingWeight(int schedulingWeight) {
        try {
            boolean success = this.connection.setSchedulingWeight(this.getNameLabel(), schedulingWeight);
            if (!success) {
                logger.error((Object)"Command setSchedulingWeight failed");
                return;
            }
            logger.debug((Object)"Command setSchedulingWeight succeed");
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to set sched weight of VM " + this.name), (Throwable)ex);
        }
    }

    public void suspend() throws BadVMPowerStateException {
        try {
            boolean success = this.connection.suspendVM(this.host, this.getNameLabel());
            if (!success) {
                logger.error((Object)"Command suspendVM failed");
                return;
            }
            logger.debug((Object)"Command suspendVM succeed");
        }
        catch (BadVMPowerStateException e) {
            throw new BadVMPowerStateException(e.getMessage());
        }
        catch (Exception ex) {
            logger.error((Object)"suspendVM failure", (Throwable)ex);
        }
    }

    public void migrate(HostMXBean targetHost, boolean live) throws IllegalOperationException, VMMException {
        throw new UnsupportedOperationException("not implemented");
    }

    public void shutdown() throws BadVMPowerStateException {
        try {
            boolean success = this.connection.shutdownVM(this.host, this.getNameLabel());
            if (!success) {
                logger.error((Object)"Command shutdownVM failed");
                return;
            }
            logger.debug((Object)"Command shutdownVM succeed");
        }
        catch (BadVMPowerStateException e) {
            throw new BadVMPowerStateException(e.getMessage());
        }
        catch (Exception ex) {
            logger.error((Object)"shutdownVM failure", (Throwable)ex);
        }
    }

    public void start() throws BadVMPowerStateException {
        try {
            boolean success = this.connection.startVM(this.host, this.getNameLabel());
            if (!success) {
                logger.error((Object)"Command startVM failed");
                return;
            }
            logger.debug((Object)"Command startVM succeed");
        }
        catch (BadVMPowerStateException e) {
            throw new BadVMPowerStateException(e.getMessage());
        }
        catch (Exception ex) {
            logger.error((Object)"Start failure", (Throwable)ex);
        }
    }

    synchronized void onVMStateChanged(VirtualMachineMXBean.PowerState state) {
        if (state != this.lastState) {
            this.emitNotification("vm.state", state.toString(), null);
            logger.debug((Object)("VM " + this.getNameLabel() + " new power state: " + state.toString()));
            this.lastState = state;
        }
    }

    public void reboot() throws BadVMPowerStateException {
        try {
            boolean success = this.connection.rebootVM(this.host, this.getNameLabel());
            if (!success) {
                logger.error((Object)"Command rebootVM failed");
                return;
            }
            logger.debug((Object)("VM " + this.name + " rebooted"));
        }
        catch (BadVMPowerStateException e) {
            throw new BadVMPowerStateException(e.getMessage());
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to reboot VM", (Throwable)ex);
        }
    }

    public void resume() throws BadVMPowerStateException {
        this.start();
    }

    public void pause() throws InstanceNotFoundException, BadVMPowerStateException {
        throw new UnsupportedOperationException();
    }

    public void unpause() throws InstanceNotFoundException, BadVMPowerStateException {
        throw new UnsupportedOperationException();
    }

    public void destroy() {
        try {
            try {
                this.shutdown();
            }
            catch (BadVMPowerStateException ex) {
                // empty catch block
            }
            boolean success = this.connection.destroyVM(this.host, this.getNameLabel());
            if (!success) {
                logger.error((Object)"DestroyVM failed");
            }
            logger.info((Object)("VM " + this.name + " destroyed"));
        }
        catch (Exception ex) {
            logger.error((Object)"Command destroyVM failed", (Throwable)ex);
        }
        try {
            boolean success = this.connection.hostDeleteFile(this.host.getVMFolderpath(), this.getNameLabel().concat(".vhd"));
            if (!success) {
                logger.error((Object)"Delete vm file failed");
            }
            logger.info((Object)("VM file " + this.name + " deleted"));
        }
        catch (Exception ex) {
            logger.error((Object)"Command deleteFile failed", (Throwable)ex);
        }
        try {
            this.host.onVMDestroy(this);
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to unregister VM MBean", (Throwable)ex);
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"vm.state", "vm.migration.abort", "vm.migration.start", "vm.migration", "log", "vm.error"}, Notification.class.getName(), "VM event")};
    }

    public void makeTemplate(String vmImageID, String name, String description) throws InsufficientResourcesException, IllegalOperationException, VMMException {
        VirtualMachineMXBean.PowerState state = this.getState();
        try {
            this.shutdown();
        }
        catch (BadVMPowerStateException ex) {
            // empty catch block
        }
        boolean success = false;
        try {
            success = this.connection.hostCopyFile(this.host.getVMFolderpath().concat(this.getNameLabel().concat(".vhd")), this.host.getVMTemplateFolderpath().concat(vmImageID.concat(".vhd")));
        }
        catch (Exception ex) {
            HyperVHost.logger.error((Object)"CopyFile failed ", (Throwable)ex);
            if (state.equals((Object)VirtualMachineMXBean.PowerState.RUNNING)) {
                this.start();
            } else if (state.equals((Object)VirtualMachineMXBean.PowerState.SUSPENDED)) {
                this.suspend();
            }
            throw new VMMException("Template creation failed: WMI connection failure", (Throwable)ex);
        }
        if (!success) {
            HyperVHost.logger.error((Object)"Command copyFile failed");
            if (state.equals((Object)VirtualMachineMXBean.PowerState.RUNNING)) {
                this.start();
            } else if (state.equals((Object)VirtualMachineMXBean.PowerState.SUSPENDED)) {
                this.suspend();
            }
            throw new VMMException("Template creation failed");
        }
        ((HyperVVMImageStore)this.host.getVMImageStore()).sync();
        if (state.equals((Object)VirtualMachineMXBean.PowerState.RUNNING)) {
            this.start();
        } else if (state.equals((Object)VirtualMachineMXBean.PowerState.SUSPENDED)) {
            this.suspend();
        }
    }
}

