/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.vmware;

import com.vmware.vim.CustomizationAdapterMapping;
import com.vmware.vim.CustomizationDhcpIpGenerator;
import com.vmware.vim.CustomizationFixedIp;
import com.vmware.vim.CustomizationFixedName;
import com.vmware.vim.CustomizationGlobalIPSettings;
import com.vmware.vim.CustomizationGuiUnattended;
import com.vmware.vim.CustomizationIPSettings;
import com.vmware.vim.CustomizationIdentification;
import com.vmware.vim.CustomizationIdentitySettings;
import com.vmware.vim.CustomizationIpGenerator;
import com.vmware.vim.CustomizationLicenseDataMode;
import com.vmware.vim.CustomizationLicenseFilePrintData;
import com.vmware.vim.CustomizationName;
import com.vmware.vim.CustomizationOptions;
import com.vmware.vim.CustomizationPassword;
import com.vmware.vim.CustomizationSpec;
import com.vmware.vim.CustomizationSysprep;
import com.vmware.vim.CustomizationUserData;
import com.vmware.vim.CustomizationWinOptions;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareHost;
import org.ow2.jasmine.vmm.api.VMConfigSpec;
import org.ow2.jasmine.vmm.api.VnicIPSettings;

public class VMwareHelper {
    static Logger logger = Logger.getLogger(VMwareHelper.class);
    private static String WINDOWS_SYSPREP_PASSWORD_KEY = "windows.sysprep.password";
    private static String WINDOWS_SYSPREP_LICENSE_TYPE_KEY = "windows.sysprep.license_type";
    private static String WINDOWS_SYSPREP_LICENSE_TYPE_PER_SEAT_VALUE = "per_seat";
    private static String WINDOWS_SYSPREP_LICENSE_TYPE_PER_SERVER_VALUE = "per_server";
    private static String WINDOWS_SYSPREP_WORKGROUP_KEY = "windows.sysprep.workgroup";
    private static String WINDOWS_SYSPREP_AUTO_LOGON_COUNT_KEY = "windows.sysprep.auto_logon_count";
    private static String WINDOWS_SYSPREP_TIMEZONE_KEY = "windows.sysprep.timezone";
    private static String WINDOWS_SYSPREP_USERDATA_FULLNAME_KEY = "windows.sysprep.userdata_fullname";
    private static String WINDOWS_SYSPREP_USERDATA_ORGNAME_KEY = "windows.sysprep.userdata_orgname";
    private static String WINDOWS_SYSPREP_USERDATA_PRODUCTID_KEY = "windows.sysprep.userdata_fullname";

    public static CustomizationSpec buildCustomizationSpec(VMConfigSpec vmSpec, boolean isWindows) {
        logger.debug((Object)("Preparing customizationSpec for VM " + vmSpec.getName()));
        CustomizationSpec custSpec = new CustomizationSpec();
        if (isWindows) {
            String workgroup;
            String licenseType;
            CustomizationSysprep custSysprep = new CustomizationSysprep();
            String password = (String)vmSpec.getGuestOsCustomizationParams().get(WINDOWS_SYSPREP_PASSWORD_KEY);
            String autoLogonCount = (String)vmSpec.getGuestOsCustomizationParams().get(WINDOWS_SYSPREP_AUTO_LOGON_COUNT_KEY);
            String timeZone = (String)vmSpec.getGuestOsCustomizationParams().get(WINDOWS_SYSPREP_TIMEZONE_KEY);
            if (autoLogonCount != null && timeZone != null) {
                VMwareHost.logger.debug((Object)("Customizing VM " + vmSpec.getName() + " password=" + password + " autoLogonCount=" + autoLogonCount + " timeZone=" + timeZone));
                CustomizationGuiUnattended custGuiUnattended = new CustomizationGuiUnattended();
                if (password != null) {
                    CustomizationPassword custPassword = new CustomizationPassword();
                    custPassword.setPlainText(true);
                    custPassword.setValue(password);
                    custGuiUnattended.setPassword(custPassword);
                }
                custGuiUnattended.setAutoLogon(true);
                custGuiUnattended.setAutoLogonCount(Integer.parseInt(autoLogonCount));
                custGuiUnattended.setTimeZone(Integer.parseInt(timeZone));
                custSysprep.setGuiUnattended(custGuiUnattended);
            }
            if ((licenseType = (String)vmSpec.getGuestOsCustomizationParams().get(WINDOWS_SYSPREP_LICENSE_TYPE_KEY)) != null) {
                CustomizationLicenseFilePrintData custLPD;
                if (licenseType.equalsIgnoreCase(WINDOWS_SYSPREP_LICENSE_TYPE_PER_SEAT_VALUE)) {
                    custLPD = new CustomizationLicenseFilePrintData();
                    custLPD.setAutoMode(CustomizationLicenseDataMode.perSeat);
                    custSysprep.setLicenseFilePrintData(custLPD);
                } else if (licenseType.equalsIgnoreCase(WINDOWS_SYSPREP_LICENSE_TYPE_PER_SERVER_VALUE)) {
                    custLPD = new CustomizationLicenseFilePrintData();
                    custLPD.setAutoMode(CustomizationLicenseDataMode.perServer);
                    custSysprep.setLicenseFilePrintData(custLPD);
                } else {
                    logger.warn((Object)("unknown license type: " + licenseType));
                }
            }
            if ((workgroup = (String)vmSpec.getGuestOsCustomizationParams().get(WINDOWS_SYSPREP_WORKGROUP_KEY)) != null) {
                CustomizationIdentification custId = new CustomizationIdentification();
                custId.setJoinWorkgroup(workgroup);
                custSysprep.setIdentification(custId);
            }
            String fullName = (String)vmSpec.getGuestOsCustomizationParams().get(WINDOWS_SYSPREP_USERDATA_FULLNAME_KEY);
            String orgName = (String)vmSpec.getGuestOsCustomizationParams().get(WINDOWS_SYSPREP_USERDATA_ORGNAME_KEY);
            String productId = (String)vmSpec.getGuestOsCustomizationParams().get(WINDOWS_SYSPREP_USERDATA_PRODUCTID_KEY);
            if (fullName != null && orgName != null && productId != null && vmSpec.getGuestOsHostName() != null) {
                CustomizationUserData custUserData = new CustomizationUserData();
                custUserData.setFullName(fullName);
                custUserData.setOrgName(orgName);
                custUserData.setProductId(productId);
                VMwareHost.logger.debug((Object)("Customizing VM " + vmSpec.getName() + " productId=" + productId));
                CustomizationFixedName custFixedName = new CustomizationFixedName();
                VMwareHost.logger.debug((Object)("Customizing VM " + vmSpec.getName() + " hostname=" + vmSpec.getGuestOsHostName()));
                custFixedName.setName(vmSpec.getGuestOsHostName());
                custUserData.setComputerName((CustomizationName)custFixedName);
                custSysprep.setUserData(custUserData);
            }
            custSpec.setIdentity((CustomizationIdentitySettings)custSysprep);
            CustomizationWinOptions custWinOptions = new CustomizationWinOptions();
            custWinOptions.setChangeSID(true);
            custSpec.setOptions((CustomizationOptions)custWinOptions);
        }
        if (vmSpec.getVnicIpSettingsList() != null && vmSpec.getVnicIpSettingsList().isEmpty()) {
            CustomizationGlobalIPSettings custGlobalIPSettings = new CustomizationGlobalIPSettings();
            custGlobalIPSettings.setDnsServerList(vmSpec.getGuestOsDnsServerList().toArray(new String[0]));
            custGlobalIPSettings.setDnsSuffixList(new String[]{vmSpec.getGuestOsDomain()});
            custSpec.setGlobalIPSettings(new CustomizationGlobalIPSettings());
            VnicIPSettings vnicIPSettings = (VnicIPSettings)vmSpec.getVnicIpSettingsList().get(0);
            CustomizationAdapterMapping custAdapterMapping = new CustomizationAdapterMapping();
            CustomizationIPSettings custIPSettings = new CustomizationIPSettings();
            custIPSettings.setDnsDomain(vmSpec.getGuestOsDomain());
            VMwareHost.logger.debug((Object)("Customizing VM " + vmSpec.getName() + " DNS server=" + (String)vmSpec.getGuestOsDnsServerList().get(0)));
            custIPSettings.setDnsServerList(vmSpec.getGuestOsDnsServerList().toArray(new String[0]));
            VMwareHost.logger.debug((Object)("Customizing VM " + vmSpec.getName() + " gateway=" + vnicIPSettings.getGateway()));
            custIPSettings.setGateway(new String[]{vnicIPSettings.getGateway()});
            custIPSettings.setSubnetMask(vnicIPSettings.getSubnetMask());
            if (vnicIPSettings.getIpAssignmentMode() == VnicIPSettings.IpAssignmentMode.FIXED) {
                CustomizationFixedIp custFixedIp = new CustomizationFixedIp();
                VMwareHost.logger.debug((Object)("Customizing VM " + vmSpec.getName() + " VNIC IP address=" + vnicIPSettings.getIpAddress()));
                custFixedIp.setIpAddress(vnicIPSettings.getIpAddress());
                custIPSettings.setIp((CustomizationIpGenerator)custFixedIp);
            } else if (vnicIPSettings.getIpAssignmentMode() == VnicIPSettings.IpAssignmentMode.DHCP) {
                CustomizationDhcpIpGenerator custDhcp = new CustomizationDhcpIpGenerator();
                custIPSettings.setIp((CustomizationIpGenerator)custDhcp);
            }
            custAdapterMapping.setAdapter(custIPSettings);
            custSpec.setNicSettingMap(new CustomizationAdapterMapping[]{custAdapterMapping});
        }
        return custSpec;
    }
}

