/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.vmware;

import com.vmware.vim.ArrayOfPerfCounterInfo;
import com.vmware.vim.ManagedObjectReference;
import com.vmware.vim.PerfCompositeMetric;
import com.vmware.vim.PerfCounterInfo;
import com.vmware.vim.PerfEntityMetric;
import com.vmware.vim.PerfEntityMetricBase;
import com.vmware.vim.PerfInterval;
import com.vmware.vim.PerfMetricId;
import com.vmware.vim.PerfMetricIntSeries;
import com.vmware.vim.PerfQuerySpec;
import com.vmware.vim.PerfSampleInfo;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareHost;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareServerPool;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareServiceConnection;

class VMwarePerfMonitor
extends TimerTask {
    private static Logger logger = Logger.getLogger(VMwarePerfMonitor.class);
    private VMwareServerPool.ConnectionPool connectionPool;
    private PerfQuerySpec qSpec = null;
    private PerfMetricId[] midList = null;
    private ManagedObjectReference perfManager = null;
    private HashMap<String, String> counterMap = null;
    private VMwareHost host = null;

    public VMwarePerfMonitor(VMwareServerPool.ConnectionPool connectionPool, VMwareHost host) {
        this.host = host;
        this.connectionPool = connectionPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(String[][] counterNames) {
        VMwareServiceConnection connection = this.connectionPool.getConnection();
        try {
            this.counterMap = new HashMap();
            int nbCounters = counterNames.length;
            if (this.perfManager == null) {
                this.perfManager = connection.getServiceContent().getPerfManager();
            }
            ArrayOfPerfCounterInfo cArray = (ArrayOfPerfCounterInfo)connection.getObjectProperty(this.perfManager, "perfCounter");
            PerfCounterInfo[] counterInfoList = cArray.getPerfCounterInfo();
            this.midList = new PerfMetricId[nbCounters];
            for (int i = 0; i < this.midList.length; ++i) {
                PerfCounterInfo counterInfo = this.getCounterInfo(counterInfoList, counterNames[i][0], counterNames[i][1], counterNames[i][2]);
                this.midList[i] = new PerfMetricId(null, null, counterInfo.getKey(), "");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to configure VMwarePerfMonitor", (Throwable)ex);
        }
        finally {
            connection.release();
        }
        PerfInterval interval = new PerfInterval();
        interval.setSamplingPeriod(5);
        interval.setLength(3600);
        this.qSpec = new PerfQuerySpec();
        this.qSpec.setMetricId(this.midList);
        this.qSpec.setIntervalId(new Integer(20));
        this.qSpec.setMaxSample(Integer.valueOf(1));
        this.qSpec.setEntity(this.host.getMOR());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HashMap<String, BigInteger> hostMetricValues = new HashMap<String, BigInteger>();
        HashMap<String, HashMap<String, BigInteger>> vmMetricValues = new HashMap<String, HashMap<String, BigInteger>>();
        long now = System.currentTimeMillis();
        VMwareServiceConnection connection = this.connectionPool.getConnection();
        try {
            logger.debug((Object)"Sending periodic perfQuery");
            PerfCompositeMetric cMetric = null;
            cMetric = connection.getService().queryPerfComposite(this.perfManager, this.qSpec);
            if (cMetric == null) {
                return;
            }
            PerfEntityMetric eMetric = (PerfEntityMetric)cMetric.getEntity();
            PerfMetricIntSeries iSeries = (PerfMetricIntSeries)eMetric.getValue(0);
            PerfEntityMetricBase[] childEntityMetric = cMetric.getChildEntity();
            PerfSampleInfo[] rootInfo = eMetric.getSampleInfo();
            int numSamples = eMetric.getSampleInfo().length;
            for (int i = 0; i < eMetric.getValue().length; ++i) {
                PerfMetricIntSeries rawSeries = (PerfMetricIntSeries)eMetric.getValue(i);
                String tName = this.counterMap.get("" + rawSeries.getId().getCounterId());
                long val = rawSeries.getValue(0);
                hostMetricValues.put(tName, BigInteger.valueOf(val));
            }
            if (childEntityMetric != null) {
                for (PerfEntityMetricBase element : childEntityMetric) {
                    PerfEntityMetric cStats = (PerfEntityMetric)element;
                    String eName = (String)connection.getObjectProperty(cStats.getEntity(), "name");
                    int numChildSamples = cStats.getSampleInfo().length;
                    HashMap<String, BigInteger> vmResult = new HashMap<String, BigInteger>();
                    vmMetricValues.put(eName, vmResult);
                    for (int k = 0; k < cStats.getValue().length; ++k) {
                        PerfMetricIntSeries cSeries = (PerfMetricIntSeries)cStats.getValue(k);
                        String tName = this.counterMap.get("" + cSeries.getId().getCounterId());
                        long val = cSeries.getValue(cSeries.getValue().length - 1);
                        vmResult.put(tName, BigInteger.valueOf(val));
                    }
                }
            }
            this.host.updateMetrics(hostMetricValues, vmMetricValues);
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to query perf metrics", (Throwable)ex);
        }
        finally {
            connection.release();
        }
    }

    private PerfCounterInfo getCounterInfo(PerfCounterInfo[] cInfo, String groupName, String counterName, String rollup) {
        String fullName = new String(groupName + "." + counterName);
        for (PerfCounterInfo current : cInfo) {
            if (!current.getGroupInfo().getKey().equals(groupName) || !current.getNameInfo().getKey().equals(counterName) || !current.getRollupType().getValue().equals(rollup)) continue;
            this.counterMap.put("" + current.getKey(), fullName);
            return current;
        }
        logger.debug((Object)("Warning - unable to find correct PerfCounterInfo for " + groupName + "." + counterName + " - " + rollup));
        return null;
    }
}

